Program MetaDemo;

{$A+,B-,F-,G+,O-,R-,S-,X+}

uses Crt, Dos, Gr, Graph, Bgi, BgiDriv, BgiFont, MetaGr;

Var
        TextX, Texty: Integer;
        Count: Word;
        OldProc: Procedure;
        Palettes: PPalettes;
        Colors: PColors;
        BaseLine, HeadLine: Integer;

Const
        Black = 0;
	White = 3;
        Red   = 13;

procedure InitGr;
Begin
  RegisterBgiDriver(@EgaVgaDriverProc);
  RegisterBgiFont(@TriplexFontProc);
  PathToDriver := '\BP\BGI';
  SetGrMode(grVgaHiStd);
  UserParams(0);
  If not InitGraphProc then Begin
    WriteLn('Die Graphik kann nicht initialisiert werden. Bitte stellen Sie');
    WriteLn('sicher, da Ihre Hardware den Standard-VGA-Modus untersttzt.');
    WriteLn('Starten Sie das Programm neu und geben Sie den Pfad zum');
    writeLn('Grafiktreiber (EGAVGA.BGI) als ersten Parameter an.');
    Halt(1)
  End;
End;

Procedure InitPalettes;
Var i,j:Byte;
Begin
  New(Palettes);
  New(Colors);
  For i:=0 to 15 do Palettes^[i]:=i;
  Palettes^[Border]:=7;
  ASM
	MOV	AX, 1002h
        LES	DX, Palettes
        INT	10h
  	LES	DI, Colors
        MOV	CX, 384
        MOV	AX, 0
        REP	STOSW
  	LES	DI, Colors
  	PUSH	DS
        CALL	FAR [@@1]
        DB	00,00,00, 26,26,26, 49,49,49, 63,63,63
        DB	31,41,31, 00,40,00, 00,00,40, 00,40,40
        DB	00,00,63, 00,63,63, 63,00,50, 40,00,32
        DB	40,15,00, 63,15,00, 63,50,15, 63,63,18
  @@1:  POP	SI
  	POP	DS
        MOV	CX, 48
        REP	MOVSB
        POP	DS
        MOV	BX, 0
        MOV	CX, 16
        LES	DX, Colors
        MOV	AX, 1012h
        INT	10h
  End;
End;

procedure NormRec;
Begin
  SetClipRect(0,0,640,480);
  SetDrawOrigin(0,0);
End;

Procedure TextPos(x,y: Integer);
Begin
  Textx:=x;
  Texty:=y;
End;

Procedure Window(x1, y1, x2, y2: Integer; FrameT, Back, Frame:Byte);
Begin
  NormRec;
  SetFillStyle(solidFill, Frame);
  Bar(x1,y1,x2,y2);
  Inc(x1, FrameT); Inc(y1, FrameT);
  Dec(x2, FrameT); Dec(y2, FrameT);
  Bar(x1,y1,x2,y2);
  if Back=0 then SetColor(3)
            else SetColor(0);
  HoriLine(x1+1,y1+1,x2-2);
  VertLine(x1+1,y1+1,y2-2);
  if Back=0 then SetColor(0)
            else SetColor(3);
  HoriLine(x1+2,y2-1,x2-1);
  VertLine(x2-1,y1+2,y2-1);
  SetClipRect(x1+2,y1+2,x2-1,y2-1);
  SetDrawOrigin(x1+2,y1+2);
End;

Procedure OutT(s: String);
Begin
  OutTextXY(Textx, Texty, s);
  Inc(Texty, TextHeight('')+5);
End;

procedure OutBT(S:String);
Begin
  OutTextXY(Textx, Texty, s);
  OutTextXY(Textx+1, Texty+1, s);
  OutTextXY(Textx, Texty+1, s);
  OutTextXY(Textx+1, Texty, s);
  Inc(Texty, TextHeight('')+6);
End;

procedure PointBar(f: Byte);
Var
	Delta: Byte;
Begin
  SetColor(white);
  SetFillStyle(solidFill, Black);
  Bar(319-3*f,369-2*f,321+3*f,371+2*f);
  Rectangle(319-3*f,369-2*f,321+3*f,371+2*f);
  Delta:=f div 2;
  SetFillStyle(solidFill, red);
  Graph.SetFillStyle(solidFill, red);
  Graph.Bar(320-f-Delta,370-Delta,320-f+Delta,370+Delta);
  Bar(320+f-Delta,370-Delta,320+f+Delta,370+Delta);
  Delay(50);
End;

procedure StartDemo;
Var
	i: Integer;
Begin
  NormRec;
  SetColor(white);
  Graph.SetColor(white);
  SetTextStyle(TriplexFont, HorizDir, 4);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,50);
  OutBT('Zwei Punkte.');
  Rectangle(317,368,323,372);
  Graph.PutPixel(319,370,Red);
  PutPixel(321,370,Red);
  SetTextStyle(TriplexFont, HorizDir, 2);
  SetTextJustify(LeftText, BottomText);
  TextX:=10;
  OutT('Auf den ersten Blick ist kein Unterschied zu erkennen.');
  ReadKey;;
  OutT('Auch bei nherer Betrachtung sehen die Punkte gleich aus.');
  For i:=1 to 13 do PointBar(i*2+1);
  ReadKey;;
  OutT('Worin besteht aber nun der Unterschied ?');
  ReadKey;;
  OutT('Dies ist ein Punkt der Unit Graph.');
  For i:=1 to 20 do Begin
    if i mod 2 =1 then Begin
      Graph.SetFillStyle(solidFill, white);
      Graph.Bar(280,357,306,383);
    End
    ELSE Begin
      Graph.SetFillStyle(solidFill, red);
      Graph.Bar(280,357,306,383);
    End;
    Delay(100);
  End;
  OutT('Und dies ist ein MetaGraph-Punkt.');
  For i:=1 to 20 do Begin
    if i mod 2 =1 then Begin
      SetFillStyle(solidFill, white);
      Bar(334,357,360,383);
    End
    ELSE Begin
      SetFillStyle(solidFill, red);
      Bar(334,357,360,383);
    End;
    Delay(100);
  End;
  ReadKey;;
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(Red);
  SetTextJustify(CenterText,BottomText);
  TextPos(320,300);
  OutBT('Na und ?');
  ReadKey;;
  ClearPage;
  SetTextStyle(TriplexFont, HorizDir, 3);
  Graph.SetColor(white);
  TextPos(20,50);
  SetTextJustify(LeftText, BottomText);
  OutT('Der Unterschied liegt in der Leistung.');
  OutT('Denn MetaGraph, Version 1.01, bietet:');
  SetTextStyle(TriplexFont, HorizDir, 1);
  OutT('- Ein komplettes Paket grafischer Funktionen');
  OutT('- Hochoptimierte Grafikroutinen fr maximale Geschwindigkeit');
  OutT('- Umfangreiche Palettenfunktionen');
  OutT('- Untersttzung von berbreiten VGA-Modi');
  OutT('- SVGA-Untersttzung (800x600-16 Farben)');
  OutT('- Untersttzung virtueller Bildschirme');
  OutT('- Untersttzung gepackter Grafikmodi fr mehr VGA-Restspeicher');
  OutT('- Bereitstellung von MetaFile-Funktionen zur Speicherung von');
  OutT('   Zeichen- und sonstigen Funktionsaufrufen');
  OutT('- Protected-Mode-Fhigkeit');
  ReadKey;;
End;

procedure DrawDemo;
Var x,y,i: Integer;
Begin
  NormRec;
  SetFillStyle(SolidFill, 0);
  Bar(0,0,640,480);
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(9);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,50);
  OutBT('MetaGraph Version 1.01');
  HeadLine:=Texty;
  OutBT('Die Zeichenfunktionen');
  BaseLine:=Texty;
  SetTextStyle(TriplexFont, HorizDir, 1);
  Graph.SetColor(white);
  SetTextJustify(CenterText, BottomText);
  TextPos(100, 148);
  OutT('Punkte');
  Window(50,150,150,250, 2,0 ,4);
  For x:=1 to 100 do
    For y:=1 to 100 do PutPixel(x,y,(x*y) mod 15);
  NormRec;
  TextPos(300, 148);
  OutT('Kreise');
  Window(250,150,350,250, 2,0 ,4);
  For i:=1 to 100 do Begin
    SetColor(random(15));
    Circle(random(100),random(100),30);
  End;
  NormRec;
  TextPos(500, 148);
  OutT('gefllte Kreise');
  Window(450,150,550,250, 2,0 ,4);
  For i:=1 to 50 do Begin
    SetFillStyle(solidFill, random(15));
    FillCircle(random(100),random(100),30);
  End;
  NormRec;
  TextPos(100, 298);
  OutT('Rechtecke');
  Window(50,300,150,400, 2,0 ,4);
  For i:=1 to 100 do Begin
    x:=Random(100);
    y:=Random(100);
    SetColor(Random(15));
    Rectangle(x,y,x+20,y+20);
  End;
  NormRec;
  TextPos(300, 298);
  OutT('gefllte Rechtecke');
  Window(250,300,350,400, 2,0 ,4);
  For i:=1 to 100 do Begin
    x:=Random(100);
    y:=Random(100);
    SetFillStyle(solidFill, Random(15));
    Bar(x,y,x+20,y+20);
  End;
  NormRec;
  TextPos(500, 298);
  OutT('Linien');
  Window(450,300,550,400, 2,0 ,4);
  For i:=1 to 100 do Begin
    SetColor(Random(15));
    SetLineStyle(solidLn, 0, random(3)+1);
    Line(Random(100),Random(100),Random(100),Random(100));
  End;
  NormRec;
  ReadKey;;
End;

Procedure PointDemo;
Var
	x,y,Delta: Integer;
Begin
  NormRec;
  SetFillStyle(solidFill, Black);
  Bar(0,HeadLine+5,639,479);
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(9);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,BaseLine);
  OutBT('PutPixel/GetPixel-Demonstration');
  Graph.SetColor(white);
  TextPos(320,300);
  OutBT('Taste zum Fortsetzen.');
  Delta:=TextHeight('T');
  Repeat
    y:=302-Delta;
    Repeat
      For x:=130 to 500 do
      if GetPixel(x,y)<>0 then
	PutPixel(x,y,random(14)+1);
      Inc(y);
    Until (y=302) or KeyPressed;
  Until KeyPressed;
  ReadKey;
End;

Procedure CircleDemo;
Begin
  NormRec;
  SetFillStyle(solidFill, Black);
  Bar(0,HeadLine+5,639,479);
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(9);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,BaseLine);
  OutBT('Circle/FillCircle-Demonstration');
  SetClipRect(50,BaseLine+25,589,440);
  SetDrawOrigin(0,BaseLine+5);
  Repeat
    SetColor(Random(14)+1);
    Circle(Random(640),Random(400),Random(30)+3);
  Until KeyPressed;
  if KeyPressed then ReadKey;
  Repeat
    SetFillStyle(solidFill, Random(14)+1);
    FillCircle(Random(640),Random(400),Random(30)+3);
  Until KeyPressed;
  ReadKey;
  NormRec;
End;

Procedure BarDemo;
Begin
  NormRec;
  SetFillStyle(solidFill, Black);
  Bar(0,HeadLine+5,639,479);
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(9);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,BaseLine);
  OutBT('Rectangle/Bar-Demonstration');
  SetClipRect(50,BaseLine+25,589,440);
  SetDrawOrigin(0,BaseLine+5);
  Repeat
    SetColor(Random(14)+1);
    Rectangle(Random(640),Random(400),Random(640),Random(400));
  Until KeyPressed;
  ReadKey;
  Repeat
    SetFillStyle(solidFill, Random(14)+1);
    Bar(Random(640),Random(400),Random(640),Random(400));
  Until KeyPressed;
  ReadKey;
  NormRec;
End;

Procedure LineDemo;
Begin
  NormRec;
  SetFillStyle(solidFill, Black);
  Bar(0,HeadLine+5,639,479);
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(9);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,BaseLine);
  OutBT('Line-Demonstration');
  SetClipRect(50,BaseLine+25,589,440);
  SetDrawOrigin(0,BaseLine+5);
  Repeat
    SetColor(Random(14)+1);
    SetLineStyle(solidLn, 0, Random(7)+1);
    Line(Random(640),Random(400),Random(640),Random(400));
  Until KeyPressed;
  ReadKey;
  NormRec;
End;

Procedure Text_2;
Begin
  NormRec;
  SetFillStyle(solidFill, Black);
  Bar(0,HeadLine+5,639,479);
  SetTextStyle(TriplexFont, HorizDir, 3);
  Graph.SetColor(white);
  SetTextJustify(LeftText, BottomText);
  TextPos(20,HeadLine+50);
  OutT('Weitere Leistungsmerkmale:');
  SetTextStyle(TriplexFont, HorizDir, 1);
  OutT('- beliebig breite Linien');
  OutT('- Verfgbarkeit der 4 VGA-Writemodi (normales Zeichnen,');
  OutT('   XOR-, OR-, AND-Verknpfung) fr alle Zeichenaktionen');
  OutT('- Clipping (Beschrnkung der Zeichenausgabe auf einen');
  OutT('   bestimmten Bildschirmbereich)');
  OutT('- Frei definierbarer Zeichenursprung');
  OutT('- Untersttzung der Konventionen der Gr-Unit (Zeiger-');
  OutT('   Qualitts-Konzept, Grafikparameter u.a.m.) ');
  OutT('- BGI-Kompatibilitt trotz direkter VGA-Zugriffe');
  ReadKey;
End;

Procedure PaletteDemo;
Var
	h, I: Byte;
Begin
  NormRec;
  SetPalettes(nil);
  SetRGBColors(nil, 0, 16);
  SetFillStyle(SolidFill, 0);
  Bar(0,0,640,480);
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(lightCyan);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,50);
  OutBT('MetaGraph Version 1.01');
  HeadLine:=Texty;
  OutBT('Die Palettenfunktionen');
  BaseLine:=Texty;
  SetClipRect(50,BaseLine+25,589,440);
  SetDrawOrigin(50,BaseLine+5);
  Graph.SetColor(15);
  SetTextStyle(TriplexFont, HorizDir, 1);
  SetTextJustify(LeftText, BottomText);
  TextPos(10,BaseLine+25);
  NormRec;
  OutT('MetaGraph ermglicht die Vernderung der Farbpalette ');
  SetColor(15);
  For i:=0 to 15 do Begin
    SetFillStyle(solidFill, i);
    Bar(5+i*30,BaseLine+50,30+i*30,BaseLine+150);
    Rectangle(5+i*30,BaseLine+50,30+i*30,BaseLine+150);
  End;
  ReadKey;
  Repeat
    h:=Random(14)+1;
    if h<>11 then SetPalette(h, Random(64));
  Until KeyPressed;
  ReadKey;
  GetPalettes(nil);
  TextPos(10,BaseLine+200);
  OutT('  und einzelner Farben.');
  i:=0;
  SetFillStyle(solidFill,1);
  Bar(100,Texty+10,300,Texty+40);
  SetPalette(1,1);
  Repeat
    SetRGBColor(1, i,i+30,i+60);
    Inc(i);
    Delay(50);
  Until KeyPressed;
  ReadKey;
  Inc(Texty, 70);
  OutT('Dabei ermglicht MetaGraph das Lesen und Schreiben aller Register.');
  ReadKey;
  ClearPage;
  InitPalettes;
End;

Procedure XorFillCircleDemo;
Var i:Word;
    p:Pointer;
Begin
  InitMetaGr;
  p:=GetBuffer(60000);
  SetBuffer(p);
  SetMetaState(ms_Draw+ms_Record+ms_BGI);
  SetWriteMode(1);
  Repeat
    SetFillStyle(solidFill,random(16));
    FillCircle(random(500)+50,random(300)+50,40);
  Until FullBuffer(p,1000);
  ReadKey;
  SetMetaState(ms_Draw+ms_BGI);
  DrawBuffer(p);
  SetWriteMode(0);
  DoneMetaGr;
End;

procedure MetaFileDemo;
Begin
  NormRec;
  SetTextStyle(TriplexFont, HorizDir, 4);
  Graph.SetColor(9);
  SetTextJustify(CenterText, BottomText);
  TextPos(320,50);
  OutBT('MetaGraph Version 1.01');
  HeadLine:=Texty;
  OutBT('Die MetaFile-Funktionen');
  BaseLine:=Texty;
  SetTextStyle(TriplexFont, HorizDir, 1);
  Graph.SetColor(white);
  Inc(Texty, 50);
  SetTextJustify(LeftText, BottomText);
  Textx:=20;
  OutT('MetaGraph ermglicht es, eine Sequenz von Funktionsaufrufen');
  OutT('(Grafikfunktionen oder Funktionen des Anwenders) in einen');
  OutT('Puffer zu speichern, um sie beliebig oft zu wiederholen.');
  OutT('Dieses Verfahren eignet sich besonders zur Hintergrundwieder-');
  OutT('herstellung, wenn dazu kein VGA-Restspeicher verwendet werden');
  OutT('kann. Oder durch Wiederholung der Zeichenoperationen im Write-');
  OutT('Mode 1 der VGA-Karte (XOR-Verknpfung) kann der Ausgangs-');
  OutT('zustand wiederhergestellt werden.');
  ReadKey;
  XorFillCircleDemo;
  ReadKey;
End;

procedure EndDemo;
Begin
  NormRec;
  SetFillStyle(solidFill, 0);
  Bar(0,0,640,480);
  TextPos(20,50);
  setTextStyle(TriplexFont, HorizDir, 1);
  SetTextJustify(LeftText, BottomText);
  OutT('Dies war eine Demonstration zur MetaGraph-Unit, Version 1.01.');
  OutT('Wir danken Ihnen fr Ihre Aufmerksamkeit und wnschen Ihnen');
  OutT('viel Erfolg beim Einsatz der Software. Bitte lesen Sie auch');
  OutT('die Begleittexte.');
  ReadKey;
End;

BEGIN
  InitGr;
  GetRGBColors(nil,0,16);
  GetPalettes(nil);
  InitPalettes;
  StartDemo;
  DrawDemo;
  PointDemo;
  CircleDemo;
  BarDemo;
  LineDemo;
  Text_2;
  PaletteDemo;
  MetaFileDemo;
  EndDemo;
  UserParams(0);
  CloseGraphProc;
END.
