
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias K"oppe              }
{                                                       }
{*******************************************************}

{ $Id: exam0202.pas 1.3 1999/02/13 14:31:50 mkoeppe Exp $ }

(* This example shows:
   - how to load a dialog from a Windows resource
   - how to use BWCC-style dialogs

   We get our Windows resource from the exam.dll file.
   This `DLL' includes a resource which has been built from
   the gvsh.rc script.
*)

uses
  { Turbo Vision units }
  Objects, Drivers,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox, WinRes, KeyNames,
  { Graphics Vision Windows Dialogs unit }
  GvWinDlg,
  { Graphics Vision BWCC support unit }
  GvBWCC,
  { Following is the symbol unit, which has been created with
    Resource Workshop. It includes identifiers for commands,
    help contexts and strings. }
  GvShCmd;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

function LoadWinDialog(Name: PChar): PWinDialog;
{ Load a Windows dialog from the resource and center it.
  The essential function is WinRes.LoadDialog.
}
var
  Dlg: PWinDialog;
begin
  Dlg := PWinDialog(Application^.ValidView(LoadDialog(Res^, Name)));
  If Dlg <> nil
  then Dlg^.Options := Dlg^.Options or ofCentered;
  LoadWinDialog := Dlg
end;

type
{ The application
}
  TDemoApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  { Open the Windows resource.
  }
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  { Start up the Windows dialog class management.
  }
  InitClasses;
  { Register standard Windows dialog classes and controls.
  }
  RegisterGvWinDlg;
  { Open the BWCC.DLL resource. It will be searched for in the
    PATH and in the Windows system directory.
  }
  InitBWCC;
  { Do the normal application start-up
  }
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  { Normal application shut-down
  }
  inherited Done;
  { Shut down the Windows dialog class management.
  }
  DoneClasses;
  { Close the BWCC resource
  }
  DoneBWCC;
  { Close the resource
  }
  Dispose(Res, Done);
end;

procedure TDemoApp.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  If Event.What = evCommand
  then begin
    { We handle just a few commands that lead to simple
      dialogs from our Windows resource.
    }
    case Event.Command of
      cmGREP:
	ExecuteDialog(LoadWinDialog('grep'), nil);
      cmDirs:
	ExecuteDialog(LoadWinDialog('dirs'), nil);
      cmBPOptions:
	ExecuteDialog(LoadWinDialog('bpc_compiler'), nil);
      cmBPLinker:
	ExecuteDialog(LoadWinDialog('bpc_linker'), nil);
      cmBPTarget:
	ExecuteDialog(LoadWinDialog('bpc_target'), nil);
      cmTASMWarnings:
	ExecuteDialog(LoadWinDialog('tasm_warn'), nil);
      else Exit;
    end;
    ClearEvent(Event)
  end
end;

procedure TDemoApp.InitMenubar;
var
  R: TRect;
  Menu: PMenu;
  Acc: PAccelerators;
Begin
  Menu := LoadMenu(Res^, 'Menu', mo_GraphicsVision);
  Acc := LoadAccelerators(Res^, 'GV');
  AddAccelerators(Menu, Acc);
  FreeAccelerators(Acc);
  Main^.GetExtent(R);
  R.B.Y := 21;
  MenuBar := New(PMenuBar, Init(R, Menu));
End;

var
  App: TDemoApp;

Begin
  App.Init;
  MessageBox('Try Compiler|BP|Options (and others) for a Windows dialog.',
    nil, mfInformation + mfOKButton);
  App.Run;
  App.Done
End.
