
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias K"oppe              }
{                                                       }
{*******************************************************}

{ $Id: exam0204.pas 1.3 1999/02/13 14:31:54 mkoeppe Exp $ }

(* This example shows:
   - how to integrate both the language resource and the BWCC
     into the application resource
   - this reduces the number of open files and allows more flexibility
 
   We get our Windows resource from the exam.dll file.
   This `DLL' includes a resource which has been built from
   the gvsh.rc script.
*)

uses
  { Turbo Vision units }
  Objects, Drivers, Validate,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox, WinRes, KeyNames, GvWinDlg, GvBWCC,
  GvDialog, GvValid,
  { Graphics Vision language-specific texts }
  GvTexts,
  { Following is the symbol unit, which has been created with
    Resource Workshop. It includes identifiers for commands,
    help contexts and strings. }
  GvShCmd;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

function LoadWinDialog(Name: PChar): PWinDialog;
var
  Dlg: PWinDialog;
begin
  Dlg := PWinDialog(Application^.ValidView(LoadDialog(Res^, Name)));
  If Dlg <> nil
  then Dlg^.Options := Dlg^.Options or ofCentered;
  LoadWinDialog := Dlg
end;

type
{ The application
}
  TDemoApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitTexts; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  InitClasses;
  RegisterGvWinDlg;
  { We would normally need InitBWCC here. But our resource includes
    all the bitmaps and dialogs from BWCC, so this assignment gives
    the access needed.
  }
  BWCC := Res;
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  inherited Done;
  DoneClasses;
  {we don't use DoneBWCC since we did't use InitBWCC.}
  Dispose(Res, Done);
end;

procedure TDemoApp.HandleEvent(var Event: TEvent);

	procedure BPMemory;
	var
	  D: PWinDialog;
	  Data: record
	    RealStack: LongInt;
	    RealMinHeap: LongInt;
	    RealMaxHeap: LongInt;
	    ProtStack: LongInt;
	    WinStack: LongInt;
	    WinHeap: LongInt
	  end;

		procedure Rangify(ID: Integer; Min, Max: LongInt);
		var
		  Val: PValidator;
		begin
		  Val := New(PRangeValidator, Init(Min, Max));
		  Val^.Options := Val^.Options or voTransfer;
		  PInputLine(D^.GetControl(ID))^.SetValidator(Val)
		end;

	begin
	  with Data do
	  begin
	    RealStack := 16384;
	    RealMinHeap := 0;
	    RealMaxHeap := 655360;
	    ProtStack := 16384;
	    WinStack := 8192;
	    WinHeap := 8192
	  end;
	  D := LoadWinDialog('bpc_memory');
	  Rangify(hiBPCRealStack, 1024, 65520);
	  Rangify(hiBPCRealMinHeap, 0, 655360);
	  Rangify(hiBPCRealMaxHeap, 0, 655360);
	  Rangify(hiBPCProtStack, 1024, 65520);
	  Rangify(hiBPCWinStack, 1024, 65536);
	  Rangify(hiBPCWinHeap, 1024, 65536);
	  ExecuteDialog(D, @Data);
	end;

begin
  inherited HandleEvent(Event);
  If Event.What = evCommand
  then begin
    case Event.Command of
      cmGREP:
	ExecuteDialog(LoadWinDialog('grep'), nil);
      cmDirs:
	ExecuteDialog(LoadWinDialog('dirs'), nil);
      cmBPOptions:
	ExecuteDialog(LoadWinDialog('bpc_compiler'), nil);
      cmBPLinker:
	ExecuteDialog(LoadWinDialog('bpc_linker'), nil);
      cmBPTarget:
	ExecuteDialog(LoadWinDialog('bpc_target'), nil);
      cmTASMWarnings:
	ExecuteDialog(LoadWinDialog('tasm_warn'), nil);
      cmBPMemory:
	BPMemory;
      else Exit;
    end;
    ClearEvent(Event)
  end
end;

procedure TDemoApp.InitMenubar;
var
  R: TRect;
  Menu: PMenu;
  Acc: PAccelerators;
Begin
  Menu := LoadMenu(Res^, 'Menu', mo_GraphicsVision);
  Acc := LoadAccelerators(Res^, 'GV');
  AddAccelerators(Menu, Acc);
  FreeAccelerators(Acc);
  Main^.GetExtent(R);
  R.B.Y := 21;
  MenuBar := New(PMenuBar, Init(R, Menu));
End;

procedure TDemoApp.InitTexts;
{ Our application is a very Windows-bound one, so
  we choose to get the language-specific texts
  from the program resource.
}
begin
  SetTextResource(Res)
end;

var
  App: TDemoApp;

Begin
  App.Init;
  MessageBox('This app gets all resources from one file, including language-specific system texts and the BWCC.',
    nil, mfInformation + mfOKButton);
  App.Run;
  App.Done
End.
