
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

(* Application with standard statusline and a menubar *)

Uses Objects, Drivers, Bgi, GVViews, GVMenus, GVApp, GvDialog;

type

  TDemoApp = object(TApplication)
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

(***************************** TDemoApp object ******************************)

procedure TDemoApp.HandleEvent(var Event: TEvent);

  procedure NewWin;
  var
    R: TRect;
  begin
    R.Assign(0, 0, 400, 300);
    R.Move(Random(300), Random(300));
    Desktop^.Insert(New(PWindow, Init(R, 'Test', 0)));
  end;

  procedure NewDlg;
  var
    R: TRect;
  begin
    R.Assign(0, 0, 400, 300);
    R.Move(Random(300), Random(300));
    Desktop^.Insert(New(PDialog, Init(R, 'Test')));
  end;


begin
  inherited HandleEvent(Event);
  If (Event.What = evCommand) then
    Case Event.Command Of
	101: NewWin;
	102: NewDlg;
    end;
end;

procedure TDemoApp.InitMenuBar;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.B.Y := 21;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', 0, NewMenu(
      NewItem('Open ~t~ext...', 'F3', kbF3, 101, 0,
      NewItem('Open ~b~itmap...', 'F4', kbF4, 102, 0,
      NewLine(
      NewItem('~C~hange directory...', '', kbNoKey, 103, 0,
      NewLine(
      NewItem('D~O~S shell', '', kbNoKey, 104, 0,
      NewItem('~Q~uit', 'Alt+X', kbAltX, cmQuit, 0, nil)))))))),
    NewSubMenu('~W~indows', 0, NewMenu(
      StdWindowMenuItems(
      NewLine(
      NewItem('Window ~l~ist...', 'Alt+0', kbAlt0, 105, 0,
      NewItem('Desktop ~m~ap', 'Alt+Minus', kbAltMinus, 106, 0, nil))))),
    nil)))));
End;

procedure TDemoApp.InitStatusLine;
Var R: TRect;
Begin
  Main^.GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt+X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F2~ Window', kbF2, 101,
      NewStatusKey('~F10~ Menu', kbF10, cmMenu, nil))),
    nil)));
End;

var App: TDemoApp;

Begin
  {NoGraphics := true;}
  App.Init;
  App.Run;
  App.Done;
End.
