{ Hier sind Anf"ange f"ur die Behandlung der Filemanager-Funktionen auf der
  entfernten Maschine. Die Funktionen Handle... werden bei Empfang entsprechender
  Kommandos aufgerufen. Auf der lokalen Maschine werden die Funktionen Request...
  bereitgestellt; sie bauen Kommandobl"ocke zusammen und senden sie an die
  entfernte Maschine. -- Der Kommunikationsanteil mu"s noch implementiert werden.

  Wenn ich die Funktionen Compar.Fileholen usw. richtig gelesen habe, ist es bis
  jetzt nur m"oglich, Files unter Beibehaltung des Namens zu kopieren. Dies m"u"ste
  so angepa"st werden, da"s der lokale Name und der entfernte Name frei w"ahlbar
  sind.

  Die Integration in den Filemanager werde ich dann auf Grundlage funktionierender
  Request...-Funktionen vornehmen k"onnen.
}

type
  { Wird an entfernte Maschine gesendet, um Verzeichnis einzulesen;
    Path kann Wildcards enthalten. }
  TRemoteFindFilesRec = record
    Path: PathStr;
    Attr: Word
  end;

  { Wird an entfernte Maschine gesendet, um Datei umzubenennen. }
  TRemoteRenameRec = record
    OldName: PathStr;
    NewName: PathStr
  end;

  { Wird an entfernte Maschine gesendet, um Datei zu l"oschen. }
  TRemoteDeleteRec = record
     Name: PathStr;
  end;

  { Wird an entfernte Maschine gesendet, um Datei zu kopieren
    (entfernt-entfernt). }
  TRemoteCopyRec = record
    Path: PathStr;
    Dest: PathStr
  end;

(*** Funktionen f"ur die entfernte Maschine ***)

{ Gibt einen neuen Speicherstream zur"uck, welcher alle passenden
  Verzeichniseintr"age als SearchRec enth"alt. }
function HandleFindFiles(const Rec: TRemoteFindFilesRec): PStream;
var
  S: PStream;
  SR: SearchRec;
begin
  S := New(PMemoryStream, Init(16384, 1024));
  FindFirst(Rec.Path, Rec.Attr, SR);
  while DosError <> 0 do
  begin
    S^.Write(SR, SizeOf(SR));
    FindNext(SR)
  end;
  S^.Seek(0);
  HandleFindFiles := S
end;

{ F"uhrt eine Kopieraktion auf dem entfernten Rechner aus. }
procedure HandleCopy(const Rec: TRemoteCopyRec);
var
  C: TCopier; { aus Unit GvFmTool }
begin
  C.Init(20);
  C.CopyFile(Rec.Path, Rec.Dest, coNormal);
  C.Done;
end;

procedure HandleRename(const Rec: TRemoteRenameRec);
var
  F: File;
  I: Integer;
begin
  Assign(F, Rec.OldName);
  {$i-}
  Rename(F, Rec.NewName);
  {$i+}
  I := IOResult;
end;

procedure HandleDelete(const Rec: TRemoteDeleteRec);
var
  F: File;
  I: Integer;
begin
  Assign(F, Rec.Name);
  {$i-}
  Erase(F);
  {$i+}
  I := IOResult;
end;

(*** Funktionen f"ur die lokale Maschine ***)

function RequestFindFiles(const Path: PathStr; Attr: Word): PStream;
var
  Rec: TRemoteFindFilesRec;
begin
  Rec.Path := Path;
  Rec.Attr := Attr;
  { senden .... Stream lesen }
  RequestFindFiles := nil
end; { RequestFindFiles }

procedure RequestDelete(const Path: PathStr);
var
  Rec: TRemoteDeleteRec;
  F: File;
  I: Integer;
begin
  Rec.Name := Path;
  { senden .... }
end;

{...}
