// This is a -*- C++ -*- header file.

#if !defined(_SKIPLIST_H_)
#define _SKIPLIST_H_

template <class T>
class TSkipNode {
public:
  T Content;
  TSkipNode *Next;
  TSkipNode *Prev;
  TSkipNode *Earlier;
  TSkipNode(T c) : Content(c), Next(0), Prev(0), Earlier(0) {}
  inline TSkipNode(); //sentinel
};

template <class T>
class TSkipList {
public:
  typedef TSkipNode<T> TNode;
  typedef T TElement;
  TNode *Latest;
  int Generations;

  TSkipList() : Latest(new TNode), Generations(1) {}
  void Insert(T Content);
  void Delete(T Content);
  TNode *Find(T Content) {
    TNode *x = FindInEarliest(Content);
    if (Content == x->Content) return x;
    return 0;
  }
private: 
  int ExpRandom();
  TNode *FindInEarliest(T Content);
};

template <class T>
TSkipNode<T> *TSkipList<T>::FindInEarliest(T Content)
{
  TNode *x = Latest;
  do {
    while (x->Next && x->Next->Content <= Content) x = x->Next;
  } while (x->Earlier && (x = x->Earlier));
  return x;
}

template <class T>
void TSkipList<T>::Insert(T Content) 
{
  // Determine the number of generations for this element.
  int Gens = ExpRandom();

  TNode *x = Latest;
  int i;
  
  for (i = Gens; i < Generations; i++) {
    while (x->Next && x->Next->Content < Content) x = x->Next;
    x = x->Earlier;
  }
  
  TNode *w;
  TNode *y = w = new TNode(Content);
  do {
    while (x->Next && x->Next->Content < Content) x = x->Next;
    y->Next = x->Next, x->Next = y;
    if (x->Earlier) {
      y = y->Earlier = new TNode(Content);
    }
    x = x->Earlier;
  } while (x);
  
  for (i = Generations; i<Gens; i++) {
    TNode *z = new TNode; // left sentinel
    TNode *y = new TNode(Content);
    y->Earlier = w;
    z->Next = y;
    z->Earlier = Latest;
    Latest = z;
    w = y;
    Generations++;
  }
}

template <class T>
void TSkipList<T>::Delete(T Content) 
{
  TNode *x = Latest;
  do {
    while (x->Next && x->Next->Content < Content) x = x->Next;
    if (x->Next && x->Next->Content == Content) {
      TNode *y = x->Next;
      x->Next = y->Next;
      delete y;
    }
    x = x->Earlier;
  } while (x);
  // Remove empty generations
  while (Latest && Latest->Earlier && !Latest->Next) {
    TNode *x = Latest;
    Latest = x->Earlier;
    delete x;
    Generations--;
  }
}

template <class T>
int TSkipList<T>::ExpRandom()
{
  // draw an integer from a 1/2-exponential distribution of the
  // positive natural numbers 
  //& I believe this can be done faster!
  int i;
  for (i = 1; rand() & 1; i++);
  return i;
}

#endif
