/*****************************************************************************/
/* Betriebssysteme I, Uni-Magdeburg, SS 97                                   */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*                               AsmMacro                                    */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* Das File stellt eine Reihe von Inline-Makros bereit, die verschiedene     */
/* Assemblerbefehle ber Assembler-Templates bereitstellen, um Register-     */
/* konflikten mit dem GCC-Code vorzubeugen und gesonderte Assemblermodule    */
/* zu vermeiden                                                              */
/* weitere Infos: siehe GCC-Manual Seite ~150, 270-280                       */
/*****************************************************************************/

#ifndef _ASM_MACROS_
#define _ASM_MACROS_

#include "debug.h"

// memcpyb: copy n bytes from src to dst 
// usage: memcpyb(<const|var>, <const|var>, <const,var>)
#undef  memcpyb
#define memcpyb(src, dst, n) \
asm ("cld\n\trep\n\tmovsb" : \
     /* nothing back*/: \
     "D" (dst), "S" (src), "c" (n) : \
     "cx")

// memcpyl: copy n dwords from src to dst
// usage: memcpyl(<const|var>, <const|var>, <const,var>)
#undef  memcpyl
#define memcpyl(src, dst, n) \
  asm ("cld\n\trep\n\tmovsl" : \
       /* nothing back */ : \
       "D" (dst), "S" (src), "c" (n) : \
       "cx")
  
// memfillb: fill memory from dst to dst+n-1 with ch  
// usage: memfillb(<const|var>, <const|var>, <const,var>)
#undef  memfillb
#define memfillb(dst, ch, n) \
  asm ("cld\n\trep\n\tstosb" : \
       /* nothing back*/: \
       "D" (dst), "a" (ch), "c" (n) : \
       "cx")
  
// memfilll: fill memory from dst to dst+n*4-1 with ch  
// usage: memfilll(<const|var>, <const|var>, <const,var>)
#undef  memfilll
#define memfilll(dst, ch, n) \
  asm ("cld\n\trep\n\tstosl" : \
       /* nothing back*/: \
       "D" (dst), "c" (n), "a" (ch) : \
       "cx")
  
// write byte val to port dst
// usage: outb(<const|var> , <const|var>)
#undef outb
#define outb(dst, val) \
  asm ("outb %%al, %%dx\n": /*nothing back*/: "a" (val), "d" (dst))

// write word val to port dst
// usage: outw(<const|var> , <const|var>) 
#undef outw
#define outw(dst, val) \
  asm ("outw %%ax, %%dx\n": /*nothing back*/: "a" (val), "d" (dst))

// read byte from port src, store in val
// usage: inb(<const|var> , <var>)
#undef inb
#define inb(src, val) \
  asm ("xor %%eax, %%eax\n\t" \
       "inb %%dx, %%al\n": "=a" (val): "d" (src) ) 

// read word from port src, store in val
// usage: inw(<const|var> , <var>)
#undef inw
#define inw(src, val) \
  asm ("xor %%eax, %%eax\n\t" \
       "inw %%dx, %%ax\n": "=a" (val): "d" (src) ) 

#define loadeax(val) \
  asm ("movl %0, %%eax\n": :"1" (val))

#define loadebx(val) \
  asm ("movl %0, %%ebx\n": :"1" (val))

#define loadecx(val) \
  asm ("movl %0, %%ecx\n": :"1" (val))

#define loadedx(val) \
  asm ("movl %0, %%edx\n": :"1" (val))

#define loadebp(val) \
  asm ("movl %0, %%ebp\n": :"1" (val))

#define loadesi(val) \
  asm ("movl %0, %%esi\n": :"1" (val))

#define loadedi(val) \
  asm ("movl %0, %%edi\n": :"1" (val))

#define loadesp(val) \
  asm ("movl %0, %%esp\n": :"1" (val))

#define storeeax(val) \
  asm ("movl %%eax, %0\n": "=1" (val))

#define storeebx(val) \
  asm ("movl %%ebx, %0\n": "=1" (val))

#define storeecx(val) \
  asm ("movl %%ecx, %0\n": "=1" (val))

#define storeedx(val) \
  asm ("movl %%edx, %0\n": "=1" (val))

#define storeebp(val) \
  asm ("movl %%ebp, %0\n": "=1" (val))

#define storeesi(val) \
  asm ("movl %%esi, %0\n": "=1" (val))

#define storeedi(val) \
  asm ("movl %%edi, %0\n": "=1" (val))

#define storeesp(val) \
  asm ("movl %%esp, %0\n": "=1" (val))

#define storeregs(buf) \
  asm ("movl %%eax, %0\n\tmovl %%ebx, 4%0\n\tmovl %%ecx, 8%0\n\tmovl %%edx, 12%0\n\tmovl %%ebp, 16%0\n\tmovl %%esi, 20%0\n\tmovl %%edi, 24%0\n\tmovl %%esp, 28%0": "=g" (buf))

#define ack outb(0x20,0x20);outb(0x20,0xa0)

#define enable_int asm("sti"); debug_int = 1;

#define disable_int asm("cli"); debug_int = 0;

#endif /* _ASM_MACROS_ */



