"Esso: Feature management"
"Written by Daniel Mahrenholz <mahrenho@csmd.cs.uni-magdeburg.de>"

(define feature-list '())

(define (require feature)
  (if (symbol? feature)
      (set! feature (symbol->string feature)))
  (if (string? feature)
      (if (member feature feature-list)
	  #t
	  (let ((name (string-append (slashify-path current-directory) feature ".scm")))
	    (if (and (file-exists? name)
		     (equal? (load name) feature))
		(begin 
		  (set! feature-list (cons feature feature-list))
		  #t)
		#f)))))

'(require 'info)
'(set! info-file-list (cons "feature.sci"
			   info-file-list))

"feature"
