#include "library/libfile.h"
#include "library/syslib.h"
#include "library/iolib.h"
#include "library/error.h"
#include "system/mailbox.h"
#include "system/loader.h"
#include "system/process.h"

/* This has been stolen from `minish.c', but special support for Esso
   has been added. */

#define tab_save_size 512
static char tab_save[tab_save_size];
int tab_saved = 0;

char* esso_gets (char* buf, struct mailbox *imbox, struct mailbox *ombox)
  {
    int c;
    int i = 0;
    if (tab_saved) {
      /* restore original input from tab */
      strcpy(buf, tab_save);
      mprintf(ombox, buf);
      i = strlen(buf);
      tab_saved = 0;
    }
    for (;;)
      {
	c = mgetchar (imbox);
	switch (c)
	  {
	  case '\n': /* LF */
	    buf[i++] = '\n';
	    buf[i++] = 0;
	    mprintf (ombox, "\n");
	    return buf;
	    break;
	  case '\t': /* TAB */
	    /* save the current line */
	    buf[i] = 0;
	    strncpy(tab_save, buf, tab_save_size);
	    tab_saved = 1;
	    /* say that tab was recognized */
	    mprintf(ombox, " [tab]\n");
	    /* find the current symbol */
	    {
	      char *P;
	      for (P = tab_save + i - 1;
		   P >= tab_save && *P != ' ' && *P != ')' && *P != '(' && *P != '\''
		     && *P != '"';
		   P--);
	      strcpy(buf, "(tab \"");
	      strcat(buf, P+1);
	      strcat(buf, "\")\n");
	    }
	    return buf;
	  case '\b': /* BS */
	    if (i > 0)
	      {
		i--;
		mprintf (ombox, "%c", 8);
	      }
	    break;
	  case ')': /* Electric paren */
	    {
	      char *P;
	      int level = 0;
	      buf[i++] = c; buf[i] = 0;
	      mprintf(ombox, "%c", c);
	      for (P = buf + i - 1; P >= buf; P--)
		if (*P == ')') level++;
		else if (*P == '(' && !--level) break;
	      if (!level) {
		/* show corresponding left paren */
		memset(tab_save, '\b', buf + i - P);
		tab_save[buf + i - P] = 0;
		mprintf (ombox, "%s", tab_save);
		sys_sleep(330);
		mprintf(ombox, "%s", P);
	      }
	      else {
		/* indicate bracket error */
		mprintf(ombox, " !Bracket!");
		sys_sleep(660);
		mprintf(ombox, "\b\b\b\b\b\b\b\b\b\b");
	      }
	      break;
	    } 
	  case '\003': /* CANCEL */
	    mprintf(ombox, " [canceled]\n");
	    strcpy(buf, "\003\n");
	    return buf;
	  default:
	    /* Prevent silly control chars from being typed in */
	    if (c >= ' ') {
	      *(buf+i++) = c;
	      mprintf (ombox, "%c", c);
	    }
	  }
      }
  }
