// This is a -*- C++ -*- header file.

// Implementations of `pipes' using Stubs mailboxes.
// <mkoeppe@cs.uni-magdeburg.de>

#if !defined(_MBOXPIPE_H)
#define _MBOXPIPE_H

extern "C" {
#include "library/syslib.h"
#include "system/loader.h"
}
#include "pipebase.h"
#include "cmailbox.h"

// line editor
extern "C" char *esso_gets(char *buf,
			   struct mailbox *imbox,
			   struct mailbox *ombox);

class TIMailBoxPipe : public TPipeBase<char> {
protected:
  TMailBox *is;
  bool deleteis;
public:
  TIMailBoxPipe(TMailBox &i) : is(&i), deleteis(false) {}
  TIMailBoxPipe(TMailBox *i) : is(i), deleteis(true) {}
  virtual ~TIMailBoxPipe() { if (deleteis) delete is; }
  virtual char *Get() { 
    char *Buf = new char[128];
    Buf[sys_receive(*is, Buf, 127)] = 0;
    return Buf;
  }
  virtual char *Read() { return Get(); }
  virtual void Put(const char *Item) {}
  virtual void Write(const char* Item) {}
};

class TInteractiveMailBoxPipe : public TIMailBoxPipe {
  TMailBox *os;
  //  char Buf[512];
public:
  TInteractiveMailBoxPipe(TMailBox &i, TMailBox &o) :
    TIMailBoxPipe(i), os(&o) {}
  virtual char *Get() { 
    char *Buf = new char[128];
    esso_gets(Buf, *is, *os);    
    return Buf;
  }
};

#define MAX_SIZE 3
/* FIXME:
   127 should work but doesn't.
   60 works but if the other side does mgetchar(), only the first
   character is read and the rest is discarded.
   So we say 3, that is, send one char (plus \000) per message. What a
   mess. */

class TOMailBoxPipe : public TPipeBase<char> {
public: //&
  TMailBox *os;
  bool deleteos;
  bool closed;
public:
  TOMailBoxPipe(TMailBox &o) : os(&o), deleteos(false), closed(false) {}
  TOMailBoxPipe(TMailBox *o) : os(o), deleteos(true), closed(false) {}
  virtual ~TOMailBoxPipe() { 
    // Send EOF message 
    Close();
    // Get rid of mailbox if needed
    if (deleteos) delete os; 
  }
  void Close(int s=0) {
    if (!s) sys_send(*os, "\004", 2);
    closed = true; 
  }
  bool Closed() { return closed; }
  virtual char *Get() { return 0; } 
  virtual char *Read() { return 0; }
  virtual void Put(const char *Item) {
    if (!Closed()) {
      int len = strlen(Item);
      char *P = const_cast<char *>(Item);
      while (len >= MAX_SIZE-1) {
	char c = P[MAX_SIZE-2];
	P[MAX_SIZE-2] = 0;
	sys_send(*os, P, MAX_SIZE-1);
	len -= MAX_SIZE-2;
	P[MAX_SIZE-2] = c;
	P += MAX_SIZE-2;
      }
      if (len > 0) sys_send(*os, const_cast<char *>(P), len+1);
    }
    delete[] Item;
  }
  virtual void Write(const char* Item) { Put(Item); }
};

class TIMailBoxExecPipe : public TIMailBoxPipe {
  TOMailBoxPipe *Omboxpipe;
  prog_info *Pi;
  int Pid;
  char *Stack;
public:
  TIMailBoxExecPipe(TMailBox *i, TOMailBoxPipe *omboxpipe,
		    prog_info *pi, int pid, char *stack)
    : TIMailBoxPipe(i), Omboxpipe(omboxpipe), Pi(pi), Pid(pid),
      Stack(stack) {} 
  virtual ~TIMailBoxExecPipe() {
    /* Kill process and delete its stack */
    // Typically, this process should have sys_exit_process()'ed
    // already. 
//     kprintf("~~");
    /* FIXME: We have no way to find out if the process
       still lives. So rather don't kill it as killing gives a
       warning. */
    //     sys_kill_process(Pid);
    delete Stack;
    /* remove loaded code */
    delete Pi->mem_ptr;
    /* delete prog-info */
    delete Pi;
    // Mark associated omboxpipe as closed. That way, the other side
    // will no longer put data (meant as input for the process that we
    // have just killed) into the ombox.
    TMailBox *ombox = Omboxpipe->os;
    if (!Omboxpipe->Closed()) {
//       kprintf("~1~");
      // Mark as closed but do not send EOF message
      Omboxpipe->Close(1);
      // Flush the ombox -- that is, waiting (by blocking-receive) for
      // EOF at the omboxpipe -- (such that the writing process will
      // unblock). This will cause the writing process to terminate,
      // thereby deleting the output port, which will send a single EOF
      // message but does NOT free the ombox. 
      {
	char Buf[3];
	do {
	  sys_receive(*ombox, Buf, 3);
	} while (*Buf != '\004');
      }
//        kprintf("~2~");
      // The writing process has just sent the EOF message. It will
      // never touch the ombox again. The ombox will be deleted here.
       /* FIXME: If we do this, things will be destroyed. So rather don't. */
       /* delete ombox; delete Omboxpipe;*/
//        kprintf("~3~");
    }
    // Inherited dtor will remove this mailbox. 
  }
};

#endif
