s returned.
{
    unsigned AreaCodeLen;
    String Dummy = IstecGetAreaCodeInfo (Phone, AreaCodeLen);
    return AreaCodeLen;
}



String IstecBeautifyPhone (const String& Phone)
// Try to "beautify" the phone number by putting a separator between the
// areacode and the local number
{
    // Be careful here: If we do not find the number in the database,
    // don't change anything, leave all separators in place
    if (Phone.NotEmpty ()) {
	String S = CleanPhone (Phone);;
	unsigned AreaCodeLen = IstecGetAreaCodeLen (S);
	if (AreaCodeLen == 0) {
	    // Return the original string unchanged
	    return Phone;
	} else {
	    S.Ins (AreaCodeLen, '/');
	    return S;
	}
    } else {
	return Phone;
    }
}



String CleanPhone (const String& Phone)
// Remove all unwanted characters from the given phone number and return the
// result.
{
    String TmpPhone = Phone;
    TmpPhone.Remove ("+-/()", rmAll);
    return TmpPhone;
}



                                                                                      /*****************************************************************************/
/*									     */
/*				    ICAC.H				     */
/*									     */
/* (C) 1997	Ullrich von Bassewitz					     */
/*		Wacholderweg 14						     */
/*		D-70597 Stuttgart					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// This is the ESTIC interface to the area code module



#ifndef _ICAC_H
#define _ICAC_H



#include "str.h"



/*****************************************************************************/
/*				     Data				     */
/*****************************************************************************/



// Code for the country we say we are in
extern String CountryCode;

// Code for the area, we say we are in
extern String AreaCode;

// The digit that is used as a dial prefix (usually '0')
extern char DialPrefix;



/*****************************************************************************/
/*				     Code				     */
/*****************************************************************************/



void SetAreaCodeFilename (const String& Name);
// Set the name of the areacode data file

String IstecGetAreaCodeInfo (const String& Phone, unsigned& AreaCodeLen);
// Return an info string for the given phone number. The phone number is
// expected to use the usual national conventions, that is:
//
//    * if it is prefixed by two DialPrefix chars, it is assumed to be
//	"fully qualified", that means, it starts with a country code.
//    * if it is prefixed by one DialPrefix chars, it is assumed to be
//	a number with an area code but without a country code.
//    * if it does not start with any DialPrefix chars, it is assumed to
//	be a local number.
//
// The function returns the info string found and sets AreaCodeLen to the
// length of the area code in Phone. If no info is found, AreaCodeLen is set
// to zero.

unsigned IstecGetAreaCodeLen (const String& Phone);
// Return the length of the area code for the given phone number. The phone
// number is expected to use the usual national conventions, that is:
//
//    * if it is prefixed by two DialPrefix chars, it is assumed to be
//	"fully qualified", that means, it starts with a country code.
//    * if it is prefixed by one DialPrefix chars, it is assumed to be
//	a number with an area code but without a country code.
//    * if it does not start with any DialPrefix chars, it is assumed to
//	be a local number.
//
// If no info is found, zero is returned.

String IstecBeautifyPhone (const String& Phone);
// Try to "beautify" the phone number by putting a separator between the
// areacode and the local number

String CleanPhone (const String& Phone);
// Remove all unwanted characters from the given phone number and return the
// result.



// End of ICAC.H

#endif
                                                                                                                                                                                       Ը1ҊUԸ
ظ^   =ظ    = t
h9t!Ujhj Qh=   = t
h9t!Ujhj 
hPiN  Ը1ҊUԸ
ظE   t& E    }[    E    =l   l]3P߅  p=ȸ ttʹu1t& VӃtPPEPV~F   ~ۋlȉʃtzt80t1@80t,@80t'@utt   t   u߃@@)Ըȉʃtzt80t1@80t,@80t'@utt   t   u߃@@)ȋظ)Уظ   = t
h9t!Ujhj Ih=   = t
h9t!Ujhj hPaL  Ը1ҊUԸ
ظ  EЋEЃ< '}\      =ظ    = t
h9ĳt!Ujhj khĳ=   =ȳ t
h9̳t!Ujhj $ȳh̳ȳPK  Ը1Ҋ