 // This may be used to change the amount of screen output, a program
    // produces.

    inline void SetTransTable (unsigned char* NewTable);
    // Set a new translation table. The old table is deleted. NewTable can
    // be NULL to clear the table.

};



inline unsigned char Screen::Translate (unsigned char C)
// Translate the char via the translation table
{
    return TransTable? TransTable [C] : C;
}



inline u16 Screen::GetXSize () const
{
    return XSize;
}



inline u16 Screen::GetYSize () const
{
    return YSize;
}



inline Rect Screen::GetSize () const
{
    return Rect (0, 0, XSize, YSize);
}



inline u16 Screen::GetMode () const
{
    return CurrentMode;
}



inline int Screen::IsColor () const
{
    return Color;
}



inline int Screen::IsConsole () const
{
    return Console;
}



inline void Screen::SetTransTable (unsigned char* NewTable)
// Set a new translation table. The old table is deleted. NewTable can be NULL
// to clear the table.
{
    delete [] TransTable;
    TransTable = NewTable;
}



// End of SCREEN.H

#endif

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      /*****************************************************************************/
/*                                                                           */
/*                                 SCRMODES.H                                */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef __SCRMODES_H
#define __SCRMODES_H



#include "machine.h"



/*****************************************************************************/
/*                           Video mode constants                            */
/*****************************************************************************/


static const u16 vmBW40         = 0x0000;
static const u16 vmCO40         = 0x0001;
static const u16 vmBW80         = 0x0002;
static const u16 vmCO80         = 0x0003;
static const u16 vmMono         = 0x0007;

// Extended modes
static const u16 vmVGA_80x25    = vmCO80;
static const u16 vmVGA_80x30    = 0x0101;
static const u16 vmVGA_80x34    = 0x0102;
static const u16 vmVGA_80x43    = 0x0103;
static const u16 vmVGA_80x50    = 0x0104;
static const u16 vmVGA_80x60    = 0x0105;
static const u16 vmVGA_94x25    = 0x0110;
static const u16 vmVGA_94x30    = 0x0111;
static const u16 vmVGA_94x34    = 0x0112;
static const u16 vmVGA_94x43    = 0x0113;
static const u16 vmVGA_94x50    = 0x0114;
static const u16 vmVGA_94x60    = 0x0115;

// Card specific modes
static const u16 vmET4_100x40   = 0x012A;

// Ask the hardware for the current mode (*nix, X Window)
static const u16 vmAsk          = 0x0200;

// The "don't know" video mode
static const u16 vmInvalid      = 0xFFFF;



// End of SCRMODES.H

#endif

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ??B     ! @#! r #! t @#! 6 #!a 7 #! 9 #!L*F #!?K #!`R#!\ #!@#!#!|&@#!n@#!ɭ #!N !!@#!=#!#!62#! 4#!m?;A#!j#!-l#!7 p#!,s!"`"=#":f#"G#"#"C[#",	'!"D	,#"	A#"
^#"<
g#"[
nB#"-
{#"B
#"bk#"#"8#"y#M#.	####8 

##

>!#
D##
E##y##L##
####
#a##j##s##;##)##z######K##^##	##'##z-##4##:)C##dQ##X##j^##_##a##|#a }$D$W
$E$g
$h
$̵$7E$$8E$PE$O$$J % ) %Ob %Ec % % % %% %L %gÆ %oņ % % %YG; %VO= %DN E{ & &e Ƈ &-!0 &o"O &^# &u# &y# &# &t$ &$ &$ $ '
&D '5&O '`&[I 'vz&bI '' '`#' 'W*(؉ 'l>(	 'L(J '*( 'V)* 'w)3 t*y
 (P*+
 (=+ (q+ (, (-5 (-6 (~-7 (-8 (z-9 (-: (0. (.K 	w/ )50 )ҙ0> )b1z )tL2L )T3 
L4v
 *5 *75 *I5 *5Í *<7H *,7k * 9 uY9 +9'O +
Y;Ͼ +<о =r ,> ,*?퐲 ,I? ,?ѱ ,@uQ ,aA ,Aѱ 
A -4CfҦ -eCyҦ En .)F .bH I /I /<I /vI /Js /JxU /JL& /5LG $SS' $SS $SS $SS $SSu $SS
 $SSb $SSf7 $SSyn $SSl $SS; $SSV $SS $SS3 $SS s; $SSxB $SS&= $SS&> $SSG>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                