; MetaGraph setting procs

; Copyright 1994,96 by Daniel Mahrenholz

include metagr.str
include metagr.con
include grdef.asm



data	segment word
	assume ds: data

extrn	LnPattern	: DWord
extrn	FillPattern	: DWord
extrn	FillBase	: Word
extrn	FillNext	: Word
extrn	FillFlag	: Word
extrn	DColor256	: DWord
extrn	FColor256	: DWord
extrn	HColor256	: DWord
extrn	DColor16	: Word
extrn	FColor16	: Word
extrn	HColor16	: Word
extrn	daLnStyle	: Word
extrn	daThickness	: Word
extrn	MetaState	: Word
extrn	MColors		: DWord
extrn	MPalettes	: DWord
extrn	csAlias		: Word
extrn	SF		: DWord

data	ends

code	segment byte public
	assume cs: code

.386p
extrn	Save : near

LOCALS	@@

IDEAL

MACRO   Metafile        ParamSize, Start
; prepares register for metafiling and calls save-proc

; Input    ParamSize    size of procs parameters in words
;           Start        new starting label for metafiled proc

           mov          cx, ParamSize
           mov          dx, offset(Start)
           call         Save

ENDM


PROC	SetColor 	FAR
PUBLIC	SetColor

	ARG	Color: Byte : 2 = RetBytes

	push	bp
	mov	bp, sp

	mov	ah, [Color]
	mov	al, ah
	mov	bx, ax
	shl	eax, 16
	mov	ax, bx

	push	offset (@@1) eax
	jmp	@@2

@@1:

	pop	bp
	retf	RetBytes

@@2:
	test	[MetaState], ms_Record
	jz	@@3
        metafile   2, @@3
@@3:
	pop	eax
	mov	[DColor256], eax
	mov	[HColor256], eax
	xor	al, al
	mov	[DColor16], ax
	mov	[HColor16], ax

	retn

ENDP

PROC	SetFillColor 	FAR
PUBLIC	SetFillColor

	ARG	Color : Byte : 2 = ArgSize

	push	bp
	mov	bp, sp

	mov	ah, [Color]
	mov	al, ah
	mov	bx, ax
	shl	eax, 16
	mov	ax, bx

	push	offset (@@1) eax
	jmp	@@2

@@1:

	pop	bp
	retf	RetBytes

@@2:
	test	[MetaState], ms_Record
	jz	@@3
        metafile   2, @@3
@@3:
	pop	eax
	mov	[FColor256], eax
	xor	al, al
	mov	[FColor16], ax

	retn

ENDP


PROC	SetColors	FAR
PUBLIC	SetColors

	ARG	FillColor: Byte: 2, Color: Byte : 2 = RetBytes

	push	bp
	mov	bp, sp

	mov	ah, [Color]
	mov	al, ah
	mov	bx, ax
	shl	eax, 16
	mov	ax, bx
	mov	bh, [FillColor]
	mov	bl, bh
	mov	cx, bx
	shl	ebx, 16
	mov	bx, cx

	push	offset (@@1) eax ebx
	jmp	@@2

@@1:
	pop	bp
	retf	RetBytes

@@2:
	test	[MetaState], ms_Record
	jz	@@3
        metafile   4, @@3
@@3:
	pop	ebx eax
	mov	[DColor256], eax
	mov	[HColor256], eax
	xor	al, al
	mov	[DColor16], ax
	mov	[HColor16], ax
	mov	[FColor256], ebx
	xor	bl, bl
	mov	[FColor16], bx

	retn


ENDP

PROC	SetFillStyle	FAR
PUBLIC	SetFillStyle

	ARG	Color: Byte : 2, FillStyle : Byte : 2 = RetBytes

	push	bp
	mov	bp, sp

	mov	ah, [Color]
	mov	al, ah
	mov	bx, ax
	shl	eax, 16
	mov	ax, bx

	push	offset (@@1) eax
	mov	al, [FillStyle]
	and	ax, 0fh
	shl	ax, 4
	mov	si, SMALL OFFSET (FillPattern)
	add	si, ax
	push	si
	jmp	@@2
@@1:
	pop	bp
	retf	RetBytes

@@2:
	test	[MetaState], ms_Record
	jz	@@3
        metafile   3, @@3
@@3:
	pop	si ebx
	mov	[FColor256], ebx
	xor	bl, bl
	mov	[FColor16], bx
	mov	[FillBase], si
	add	si, 16
	mov	[FillNext], si

	retn

ENDP

PROC	SetFillPattern	FAR
PUBLIC	SetFillPattern

	ARG	aFillPattern: DWord = RetBytes

	push	bp
	mov	bp, sp

	mov	di, SMALL OFFSET (FillPattern)
	add	di, 192
	push	ds
	push	ds
	pop	es
	lds	si, [aFillPattern]
	mov	cx, 8
@@1:
	lodsb
	stosb
	stosb
	dec	cx
	jnz	@@1
	pop	ds

	pop	bp
	ret	RetBytes

ENDP

PROC	SetLineStyle	FAR
PUBLIC	SetLineStyle

	ARG	Thickness: Word, Pattern: Word, LineStyle: Word = RetBytes

	push	bp
	mov	bp, sp

	cmp	[LineStyle], 3
	jng	@@1
	mov	ax, [Pattern]
	jmp	@@2
@@1:
	mov	ax, [LineStyle]
	shl	ax, 1
	mov	si, SMALL OFFSET (LnPattern)
	add	si, ax
	mov	ax, [ds:si]
@@2:

	push	offset (@@4) ax [Thickness]
	jmp	@@5
@@4:
	pop	bp
	ret	RetBytes

@@5:
	test	[MetaState], ms_Record
	jz	@@6
        metafile   2, @@6
@@6:
	pop	[daThickness] [daLnStyle]

	retn

ENDP

PROC	SetMetaState	FAR
PUBLIC	SetMetaState

	ARG	State: Word = RetBytes

	push	bp
	mov	bp, sp

	mov	ax, [State]
	mov	[MetaState], ax

	pop	bp
	ret	RetBytes

ENDP

PROC    SetSingleMS     FAR
PUBLIC  SetSingleMS

        ARG	State: Word = RetBytes

        push	bp
        mov	bp, sp
        mov	ax, [State]
        or	[MetaState], ax

        pop	bp
        ret	RetBytes

ENDP

PROC	ClearSingleMS	FAR
PUBLIC	ClearSingleMS

	ARG	State: Word = RetBytes

        push	bp
        mov	bp, sp
        mov	ax, [State]
        not	ax
        and	[MetaState], ax

        pop	bp
        ret	RetBytes

ENDP

PROC	SetRGBColor far
PUBLIC	SetRGBColor

	arg	Blue: Byte: 2, Green: Byte: 2, Red: Byte: 2, \
		aColor: Byte: 2 = ArgSize
	push	bp
	mov	bp, sp

	mov	dx, 03c8h
	mov	al, [aColor]
	out	dx, al
	inc	dx
	mov	al, [Red]
	out	dx, al
	mov	al, [Green]
	out	dx, al
	mov	al, [Blue]
	out	dx, al

	pop	bp
	ret	ArgSize

ENDP


PROC	SetRGBColors far
PUBLIC	SetRGBColors

	arg	Count : Byte : 2, Start : Byte : 2, Colors : DWord = ArgSize
	push	bp
	mov	bp, sp

	push	ds
	mov	al, [Start]
	xor	ah, ah
	mov	bx, ax
	mov	cl, [Count]
	xor	ch, ch
	inc	cx
	imul	bx, 3
	imul	cx, 3
	cmp	[Colors], 0
	je	@@mc
	lds	si, [Colors]
	jmp	@@0
@@mc:
	lds	si, [MColors]
@@0:
	add	si, bx
@@1:
	mov	dx, 03c8h
	out	dx, al
	inc	dx
	rep	outsb
	pop	ds

	pop	bp
	ret	ArgSize
ENDP

PROC	SetRGBColorEntry far
PUBLIC	SetRGBColorEntry

	arg	Blue: Byte:2, Green: Byte:2, Red: Byte:2, \
		aColor: Byte:2 = ArgSize
	push	bp
	mov	bp, sp
	les	di, [MColors]
	mov	al, [aColor]
	xor	ah, ah
	shl	ax, 1
	mov	bl, [aColor]
	xor	bh, bh
	add	ax, bx
	add	di, ax
	mov	al, [Red]
	mov	[(Byte es:di)], al
	mov	al, [Green]
	mov	[(Byte es:di+1)], al
	mov	al, [Blue]
	mov	[(Byte es:di+2)], al
	pop	bp
	ret	ArgSize

ENDP

PROC	GetRGBColorEntry far
PUBLIC	GetRGBColorEntry

	arg	Blue : DWord, Green : DWord, Red : DWord, \
		aColor : Byte : 2 = ArgSize
	push	bp
	mov	bp, sp
	les	di, [MColors]
	mov	al, [aColor]
	xor	ah, ah
	shl	ax, 1
	mov	bl, [aColor]
	xor	bh, bh
	add	ax, bx
	add	di, ax
	mov	al, [(Byte es:di)]
	mov	bl, [(Byte es:di+1)]
	mov	cl, [(Byte es:di+2)]
	les	di, [Red]
	mov	[(Byte es:di)], al
	les	di, [Green]
	mov	[(Byte es:di)], bl
	les	di, [Blue]
	mov	[(Byte es:di)], cl
	pop	bp
	ret	ArgSize

ENDP

PROC	GetRGBColors far
PUBLIC	GetRGBColors

	arg	Count : Byte : 2, Start : Byte : 2, Colors : DWord = ArgSize
	push	bp
	mov	bp, sp

	mov	al, [Start]
	xor	ah, ah
	mov	bx, ax
	mov	cl, [Count]
	xor	ch, ch
	inc	cx
	imul	bx, 3
	imul	cx, 3
	cmp	[Colors], 0
	je	@@mc
	les	di, [Colors]
	jmp	@@0
@@mc:
	les	di, [MColors]
@@0:
	add	di, bx
@@1:
	mov	dx, 03c7h
	out	dx, al
	add	dx, 2
	rep	insb

	pop	bp
	ret	ArgSize

ENDP

PROC	SetPalette far
PUBLIC	SetPalette

	arg	aColor : Byte : 2, Palette : Byte : 2 = ArgSize
	push	bp
	mov	bp, sp
	mov	ax, 1000h
	mov	bh, [aColor]
	mov	bl, [Palette]
	int	10h
	pop	bp
	ret	ArgSize

ENDP

PROC	GetPalette far
PUBLIC	GetPalette

	arg	Palette : Byte : 2 = ArgSize
        push	bp
	mov	bp, sp
        mov	ax, 1007h
	mov	bl, [Palette]
	int	10h
	mov	ax, bx
	pop	bp
	ret	ArgSize

ENDP

PROC	GetRGBColor far
PUBLIC	GetRGBColor

	arg	Blue : DWord, Green : DWord, Red : DWord, \
		aColor : Byte : 2 = ArgSize
	push	bp
	mov	bp, sp

	mov	dx, 03c7h
	mov	al, [aColor]
	out	dx, al
	add	dx, 2

	les	di, [Red]
	in	al, dx
	mov	[(Byte es:di)], al
	les	di, [Green]
	in	al, dx
	mov	[(Byte es:di)], al
	les	di, [Blue]
	in	al, dx
	mov	[(Byte es:di)], al

	pop	bp
	ret	ArgSize

ENDP

PROC	SetPaletteEntry far
PUBLIC	SetPaletteEntry

	arg	aColor : Byte : 2, Palette : Byte : 2 = ArgSize
	push	bp
	mov	bp, sp
	les	di, [MPalettes]
	mov	al, [Palette]
	xor	ah, ah
	add	di, ax
	mov	al, [aColor]
	mov	[(BYte es:di)], al
	pop	bp
	ret	ArgSize

ENDP

PROC	GetPaletteEntry far
PUBLIC	GetPaletteEntry

	arg	Palette : Byte : 2 = ArgSize
	push	bp
	mov	bp, sp
	les	di, [MPalettes]
	mov	al, [Palette]
	xor	ah, ah
	add	di, ax
	mov	al, [(Byte es:di)]
	pop	bp
	ret	ArgSize

ENDP

PROC	SetPalettes far
PUBLIC	SetPalettes

	arg	Palettes : DWord = ArgSize
	push	bp
	mov	bp, sp
	mov	ax, 1002h
	les	dx, [Palettes]
	mov	bx, es
	mov	cx, dx
	or	cx, bx
	jnz	@@1
	les	dx, [MPalettes]
@@1:
	int	10h
	pop	bp
	ret	ArgSize

ENDP

PROC	GetPalettes far
PUBLIC	GetPalettes

	arg	Palettes : DWord = ArgSize
	push	bp
	mov	bp, sp
	mov	ax, 1009h
	les	dx, [Palettes]
	mov	bx, es
	mov	cx, dx
	or	cx, bx
	jnz	@@1
	les	dx, [MPalettes]
@@1:
	int	10h
	pop	bp
	ret	ArgSize

ENDP

PROC	SetBorder far
PUBLIC	SetBorder

	arg	aColor : Byte : 2 = ArgSize
	push	bp
	mov	bp, sp
	mov	ax, 1001h
	mov	bh, [aColor]
	int	10h
	pop	bp
	ret	ArgSize

ENDP

PROC	GetBorder far
PUBLIC	GetBorder

	mov	ax, 1008h
	int	10h
	mov	al, bh
	ret

ENDP

PROC	SetMetaOrigin far
PUBLIC	SetMetaOrigin

	arg	y1 : Word, x1 : Word = ArgSize
	push	bp
	mov	bp, sp
	mov	ax, [x1]
	mov	[(TPoint MetaOrigin).x], ax
	mov	ax, [y1]
	mov	[(TPoint MetaOrigin).y], ax
	pop	bp
	ret	ArgSize

ENDP

PROC	SetMetaOriginP far
PUBLIC	SetMetaOriginP

	arg	P : DWord = ArgSize
	push	bp
	mov	bp, sp
	mov	ax, [(word P)]
	mov	[(TPoint MetaOrigin).x], ax
	mov	ax, [(word P+2)]
	mov	[(TPOint MetaOrigin).y], ax
	pop	bp
	ret	ArgSize

ENDP

PROC	SetMetaClipRect far
PUBLIC	SetMetaClipRect

	arg	y2 : Word, x2 : Word, y1 : Word, x1 : Word = ArgSize
	push	bp
	mov	bp, sp
	push	ds
	pop	es
	mov	di, SMALL offset (MetaClipRect)
	cld
	mov	ax, [x1]
	stosw
	mov	ax, [y1]
	stosw
	mov	ax, [x2]
	stosw
	mov	ax, [y2]
	stosw
	pop	bp
	ret	ArgSize

ENDP

PROC	SetMetaClipRectR far
PUBLIC	SetMetaClipRectR

	arg	R : DWord = ArgSize
	push	bp
	mov	bp, sp
	push	ds ds
	pop	es
	mov	di, SMALL offset (MetaClipRect)
	lds	si, [R]
	mov	cx, 4
	cld
	rep	movsw
	pop	ds bp
	ret	ArgSize

ENDP

PROC	DefaultPattern near
PUBLIC	DefaultPattern

	dw	00000h, 00000h, 00000h, 00000h, 00000h, 00000h, 00000h, 00000h
	dw	0ffffh, 0ffffh, 0ffffh, 0ffffh, 0ffffh, 0ffffh, 0ffffh, 0ffffh
	dw	00000h, 00000h, 00000h, 0eeeeh, 0eeeeh, 00000h, 00000h, 00000h
	dw	01111h, 01111h, 02222h, 02222h, 04444h, 04444h, 08888h, 08888h
	dw	03333h, 03333h, 06666h, 06666h, 0cccch, 0cccch, 09999h, 09999h
	dw	0c1c1h, 0e0e0h, 07070h, 03838h, 01c1ch, 00e0eh, 00707h, 08383h
	dw	0e3e3h, 0f1f1h, 0f8f8h, 07c7ch, 03e3eh, 01f1fh, 08f8fh, 0c7c7h
	dw	09292h, 02424h, 04949h, 09292h, 02424h, 04949h, 09292h, 02424h
	dw	01818h, 03c3ch, 06666h, 0c3c3h, 0c3c3h, 06666h, 03c3ch, 01818h
	dw	00000h, 0ffffh, 00000h, 0ffffh, 00000h, 0ffffh, 00000h, 0ffffh
	dw	08888h, 00000h, 02222h, 00000h, 08888h, 00000h, 02222h, 00000h
	dw	0a5a5h, 05a5ah, 0a5a5h, 05a5ah, 0a5a5h, 05a5ah, 0a5a5h, 05a5ah
	dw	018e5h, 00447h, 00445h, 07d7dh, 0b6cdh, 06a98h, 0a388h, 0a2b8h
	dw	08080h, 09e9eh, 08282h, 08282h, 0f2f2h, 00202h, 00000h, 00000h
	dw	0eeeeh, 08888h, 0bbbbh, 02222h, 0eeeeh, 08888h, 0bbbbh, 02222h
	dw	02222h, 04444h, 0aaaah, 01111h, 02222h, 04444h, 0aaaah, 01111h
	; LnPattern
	dw      0ffffh
	dw	03333h
	dw      01e4fh
	dw	01f1fh
	dw	0
	dw	0
	dw	0
	dw	0

ENDP

PROC	InitPattern near
PUBLIC	InitPattern

	cld
	mov	ax, [csAlias]
	push	ds
	push	ds
	pop	es
	lea	di, [FillPattern]
	mov	si, offset (DefaultPattern)
	mov	ds, ax
	mov	cx, 136
	rep	movsw
	pop	ds
	ret

ENDP

PROC	SetSF	far
PUBLIC	SetSF

	arg	aSF: DWord = ArgSize
	push	bp
	mov	bp, sp

	mov	eax, [aSF]
	cmp	eax, 010000h
	jng	@@1
	mov	eax, 010000h
@@1:
	mov	[SF], eax

	pop	bp
	ret	ArgSize

ENDP

ENDS

END