{
   *********************************************************************
   Bitmap-resource access, derived from bmp.pp (version: 1998.06.09)
   Copyright (C) 1997, 1998 Gertjan Schouten
   Copyright (C) 1999 Matthias K"oppe

   $Id$
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   *********************************************************************
}

{ Note: If some sort of bitmap is not supported by this unit,
 have a look at the (LGPL'ed) WinRes unit in the Graphics Vision
 package. This also contains some sophisticated BMP-load code but it
 has not been ported to FPC. Someone might want to do this, or to
 improve the code in this unit with ideas from there. -- mkoeppe }

unit bmpres;

interface

uses objects, bitmaps;

type
   TBitMapInfoHeader = record
      Size:longint;
      Width:longint;
      Height:longint;
      Planes:word;
      BitCount:word;
      Compression:longint;
      SizeImage:longint;
      XPelsPerMeter:Longint;
      YPelsPerMeter:Longint;
      ClrUsed:longint;
      ClrImportant:longint;
   end ;

   TBitmapIO_BMPRes = object(TBitmapIO)
   private
     Size: LongInt;
     BFI: TBitMapInfoHeader;
     Palet:array[0..255] of longint;
   public
      constructor Create;
      function LoadHeader(stream:pstream):boolean; virtual;
      procedure LoadRLE8(stream:pstream);
      function LoadImage(stream:pstream):boolean; virtual;
      procedure SetSize(asize: LongInt); 
      destructor Destroy; virtual;
   end ;

var
   BitmapIO_BMPRes: TBitmapIO_BMPRes;

implementation

const
   biRGB = 0;
   biRLE8 = 1;

constructor TBitmapIO_BMPRes.Create;
begin
  inherited create;
  FFileExt := '.$$$';  {doesnt correspond to a file}
end ;

function TBitmapIO_BMPRes.LoadHeader(stream:pstream):boolean;
begin
result := false;
stream^.read(bfi,sizeof(TBitMapInfoHeader));
if FBitmap^.getBytesPerPixel = 0 then begin
      case bfi.bitcount of
	      1, 4, 8: FBitmap^.setBytesPerPixel(1);
         else FBitmap^.setBytesPerPixel(4);
      end ;
   end ;
Fbitmap^.setWidth(bfi.Width);
Fbitmap^.setHeight(bfi.Height);
if (bfi.bitCount <= 8) then begin
  stream^.read(Palet, 4 shl bfi.bitcount);
   Fbitmap^.setPalette(@Palet, 1 shl bfi.bitCount, ptBGR8, 4);
   end ;
result := true;
end ;

procedure TBitmapIO_BMPRes.LoadRLE8(Stream:pstream);
var i,x,y:integer;
    n:word;count:byte;
    buffer:array[0..255] of byte;
    done:boolean;
begin
y := bfi.Height - 1;
x := 0;
done := false;
while not done do begin
   stream^.read(n, 2);
   count := n shr 8;
   if n and 255 <> 0 then begin
      count := n and 255;
      Fillchar(Buffer, Count, n shr 8);
      fbitmap^.PutPixels(x, y, Count, @Buffer, 8);
      x := x + count;
      end
   else begin
         case count of
            0: begin
               y := y - 1;
               x := 0;
               end ;
            1: done := true;
            2: begin
               stream^.read(n, 2);
               inc(x, n and 255);
               dec(y, n shr 8);
               end ;
            else begin
               stream^.read(Buffer, (Count + 1) and $FFFE); { word align }
               fbitmap^.PutPixels(x, y, count, @Buffer, 8);
               x := x + count;
               count := 0;
               end ;
         end ;
      end ;
   end ;
end ;

function TBitmapIO_BMPRes.LoadImage(stream:pstream):boolean;
var
   y:integer;
   Buffer:pointer;
   BufSize:longint;
begin
BufSize := ((bfi.Width * bfi.BitCount div 8) + 3) and $FFFFFFFC;
Getmem(buffer, bufSize);
result := true;
if (bfi.bitcount = 24) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      fbitmap^.PutPixels(0, y, bfi.Width, buffer, 24);
      end ;
   end
else if (bfi.Bitcount = 8) and (bfi.Compression = biRGB) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      fbitmap^.PutPixels(0, y, bfi.Width, buffer, 8); 
      end ;
   end
else if (bfi.Bitcount = 8) and (bfi.Compression = biRLE8) then
   LoadRLE8(Stream)
else if (bfi.Bitcount = 4) and (bfi.Compression = biRGB) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      Fbitmap^.PutPixels(0, y, bfi.Width, buffer, 4); 
   end ;
end
else if (bfi.Bitcount = 1) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      Fbitmap^.PutPixels(0, y, bfi.Width, buffer, 1);
   end ;
end
else result := false;
Freemem(buffer, bufSize);
end ;

destructor TBitmapIO_BMPRes.Destroy;
begin
end ;

procedure TBitmapIO_BMPRes.SetSize(asize: LongInt);
begin
  size := asize
end;

procedure DebugInfo;
begin
// writeln('Used colors: ',bfi.ClrUsed);
// writeln('Imp colors: ',bfi.ClrImportant);
end ;

begin
BitmapIO_BMPRes.Create;
end .
