{*******************************************************}
{ Free Vision Runtime Library                           }
{ TextView Unit                                         }
{ Version: 0.1.0                                        }
{ Release Date: July 23, 1998                           }
{                                                       }
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Turbo Vision Unit                               }
{                                                       }
{       Copyright (c) 1992 Borland International        }
{                                                       }
{*******************************************************}
{                                                       }
{ This unit is a port of Borland International's        }
{ TextView.pas unit.  It is for distribution with the   }
{ Free Pascal (FPK) Compiler as part of the 32-bit      }
{ Free Vision library.  The unit is still fully         }
{ functional under BP7 by using the tp compiler         }
{ directive when rebuilding the library.                }
{                                                       }
{*******************************************************}
{ To Do List:                                           }
{   - reimplement and debug TTerminal.NextLines         }
{                                                       }
{*******************************************************}

unit TextView;

{$i platform.inc}

{$ifdef PPC_FPC}
  {$H-}
{$else}
  {$F+,O+,E+,N+}
{$endif}
{$X+,R-,I-,Q-,V-}
{$ifndef OS_LINUX}
  {$S-}
{$endif}

interface

uses Objects, Drivers, Views, Dos;

type

  { TTextDevice }

  PTextDevice = ^TTextDevice;
  TTextDevice = object(TScroller)
    function StrRead(var S: TextBuf): Byte; virtual;
    procedure StrWrite(var S: TextBuf; Count: Byte); virtual;
  end;

  { TTerminal }

  PTerminalBuffer = ^TTerminalBuffer;
  TTerminalBuffer = array[0..65534] of Char;

  PTerminal = ^TTerminal;
  TTerminal = object(TTextDevice)
    BufSize: Sw_Word;
    Buffer: PTerminalBuffer;
    QueFront, QueBack: Sw_Word;
    constructor Init(var Bounds:TRect; AHScrollBar, AVScrollBar: PScrollBar; ABufSize: Sw_Word);
    destructor Done; virtual;
    procedure BufDec(var Val: Sw_Word);
    procedure BufInc(var Val: Sw_Word);
    function CalcWidth: Sw_Integer;
    function CanInsert(Amount: Sw_Word): Boolean;
    procedure Draw; virtual;
    function NextLine(Pos:Sw_Word): Sw_Word;
    function PrevLines(Pos,Lines: Sw_Word): Sw_Word;
    function StrRead(var S: TextBuf): Byte; virtual;
    procedure StrWrite(var S: TextBuf; Count: Byte); virtual;
    function QueEmpty: Boolean;
  end;

procedure AssignDevice(var T: Text; Screen: PTextDevice);

implementation


{ TTextDevice }

function TTextDevice.StrRead(var S: TextBuf): Byte;
begin
  StrRead := 0;
end;

procedure TTextDevice.StrWrite(var S: TextBuf; Count: Byte);
begin
end;


{ TTerminal }

constructor TTerminal.Init(var Bounds:TRect; AHScrollBar,AVScrollBar: PScrollBar; ABufSize: Sw_Word);
begin
  TTextDevice.Init(Bounds, AHScrollBar, AVScrollBar);
  GrowMode := gfGrowHiX + gfGrowHiY;
  BufSize := ABufSize;
  if BufSize > 65520 then
    BufSize := 65520;
  GetMem(Buffer, BufSize);
  QueFront := 0;
  QueBack := 0;
  SetLimit(0,1);
  SetCursor(0,0);
  ShowCursor;
end;


destructor TTerminal.Done;
begin
  FreeMem(Buffer, BufSize);
  TTextDevice.Done;
end;


procedure TTerminal.BufDec(var Val: Sw_Word);
begin
  if Val = 0 then
    Val := BufSize - 1
  else
    Dec(Val);
end;


procedure TTerminal.BufInc(var Val: Sw_Word);
begin
  Inc(Val);
  if Val >= BufSize then
    Val := 0;
end;


function TTerminal.CalcWidth: Sw_Integer;
var
  I, Len, Width: Sw_Integer;
  CurPos, EndPos: Sw_Integer;
begin
  Width := 0;
  CurPos := QueBack;
  for I := 1 to Limit.Y do
  begin
    EndPos := NextLine(CurPos);
    if EndPos >= CurPos then
      Len := EndPos - CurPos else
      Len := BufSize - CurPos + EndPos;
    if Buffer^[EndPos-1] = #10 then
      Dec(Len) else
      Inc(Len);
    if Len > Width then
      Width := Len;
    CurPos := EndPos;
  end;
  CalcWidth := Width;
end;


function TTerminal.CanInsert(Amount: Sw_Word): Boolean;
var
  T: Longint;
begin
  if QueFront < QueBack then T := QueFront + Amount
  else T := LongInt(QueFront) - LongInt(BufSize) + Amount;
  CanInsert := QueBack > T;
end;


procedure TTerminal.Draw;
var
  I: Sw_Integer;
  BegLine, EndLine: Sw_Word;
  S: String;
  T: Longint;
  BottomLine: Sw_Word;
begin
  BottomLine := Size.Y + Delta.Y;
  if Limit.Y > BottomLine then
  begin
    EndLine := PrevLines(QueFront, Limit.Y-BottomLine);
    BufDec(EndLine);
  end
  else EndLine := QueFront;
  if Limit.Y-1 >= Size.Y then I := Size.Y-1
  else
  begin
    for I := Limit.Y to Size.Y-1 do
      WriteChar(0, I, ' ', 1, Size.X);
    I := Limit.Y-1;
  end;
  for I := I downto 0 do
  begin
    BegLine := PrevLines(EndLine,1);
    if EndLine >= BegLine then
    begin
      T := EndLine - BegLine;
      Move(Buffer^[BegLine], S[1], T);
      S[0] := Char(T);
    end
    else
    begin
      T := BufSize - BegLine;
      Move(Buffer^[BegLine], S[1], T);
      Move(Buffer^, S[T+1], EndLine);
      S[0] := Char(T + EndLine);
    end;
    if Delta.X >= Length(S) then S := ''
    else S := Copy(S, Delta.X+1, 255);
    WriteStr(0, I, S, 1);
    WriteChar(Length(S), I, ' ', 1, Size.X);
    EndLine := BegLine;
    BufDec(EndLine);
  end;
end;


function TTerminal.NextLine(Pos:Sw_Word): Sw_Word;
begin
  if Pos <> QueFront then
  begin
    while (Buffer^[Pos] <> #10) and (Pos <> QueFront) do
      BufInc(Pos);
    if Pos <> QueFront then
      BufInc(Pos);
  end;
  NextLine := Pos;
end;


function TTerminal.PrevLines(Pos,Lines: Sw_Word): Sw_Word;
begin
  while Lines > 0 do
  begin
    if Pos <> QueBack then
    begin
      while (Buffer^[Pos] <> #10) and (Pos <> QueBack) do
        BufDec(Pos);
      if Pos <> QueBack then
        BufDec(Pos);
    end;
    Dec(Lines);
  end;
  PrevLines := Pos;
end;


function TTerminal.StrRead(var S: TextBuf): Byte;
begin
  StrRead := 0;
end;


procedure TTerminal.StrWrite(var S: TextBuf; Count: Byte);
var
  I, J: Sw_Word;
  ScreenLines: Sw_Word;
begin
  if Count = 0 then
    Exit
  else
    if Count >= BufSize then
      Count := BufSize-1;
  ScreenLines := Limit.Y;
  J := 0;
  for I := 0 to Count-1 do
    case S[I] of
      #13: Dec(Count)
      else
      begin
        if S[I] = #10 then
          Inc(ScreenLines);
        S[J] := S[I];
        Inc(J);
      end;
    end;

  while not CanInsert(Count) do
  begin
    QueBack := NextLine(QueBack);
    Dec(ScreenLines);
  end;

  if LongInt(QueFront) + Count >= BufSize then
  begin
    I := BufSize - QueFront;
    Move(S,Buffer^[QueFront], I);
    Move(S[I],Buffer^, Count - I);
    QueFront := Count - I;
  end
  else
  begin
    Move(S,Buffer^[QueFront],Count);
    Inc(QueFront,Count);
  end;
  SetLimit(CalcWidth,ScreenLines);
  ScrollTo(0, ScreenLines+1);
  I := PrevLines(QueFront,1);
  if I <= QueFront then I := QueFront - I
  else I := BufSize - (I - QueFront);
  SetCursor(I, ScreenLines-Delta.Y-1);
  DrawView;
end;


function TTerminal.QueEmpty: Boolean;
begin
  QueEmpty := QueBack = QueFront;
end;


{ Window Text Device Driver }

type
  WindowData = record
    Screen: PTextDevice;
    Filler: Array [1..12] of Char;
  end;


function WindowWrite(var F: TextRec): Integer;{$ifdef PPC_BP}far;{$endif}
begin
  with F do
  begin
    WindowData(UserData).Screen^.StrWrite(BufPtr^, BufPos);
    BufPos := 0;
  end;
  WindowWrite := 0;
end;


function WindowRead(var F: TextRec): Integer;{$ifdef PPC_BP}far;{$endif}
begin
  with F do
  begin
    BufPos := 0;
    BufEnd := WindowData(F.UserData).Screen^.StrRead(BufPtr^);
  end;
  WindowRead := 0;
end;


function WindowFlush(var F: TextRec): Integer;{$ifdef PPC_BP}far;{$endif}
begin
  F.BufPos := 0;
  F.BufEnd := 0;
  WindowFlush := 0;
end;


function WindowOpen(var F: TextRec): Integer;{$ifdef PPC_BP}far;{$endif}
begin
  with F do
  begin
    if Mode = fmInput then
    begin
      InOutFunc := @WindowRead;
      FlushFunc := @WindowFlush;
    end
    else
    begin
      InOutFunc := @WindowWrite;
      FlushFunc := @WindowWrite;
    end;
    WindowOpen := 0;
  end;
end;


function WindowIgnore(var F: TextRec): Integer;{$ifdef PPC_BP}far;{$endif}
begin
  WindowIgnore := 0;
end;


procedure AssignDevice(var T: Text; Screen: PTextDevice);
begin
  with TextRec(T) do
  begin
    Handle := $FFFF;
    Mode := fmClosed;
    BufSize := SizeOf(Buffer);
    BufPtr := @Buffer;
    OpenFunc := @WindowOpen;
    CloseFunc := @WindowIgnore;
    WindowData(UserData).Screen:= Screen;
  end;
end;

end.
