{*******************************************************}
{ Free Vision Runtime Library                           }
{ String Handling Unit                                  }
{ Version: 0.1.0                                        }
{ Release Date: July 23, 1998                           }
{                                                       }
{       Turbo Pascal Runtime Library                    }
{       String Handling Unit                            }
{                                                       }
{       Copyright (C) 1990,92 Borland International     }
{                                                       }
{*******************************************************}
{                                                       }
{ This unit is a port of Borland International's        }
{ String.pas unit.  It is for distribution with the     }
{ Free Pascal (FPK) Compiler as part of the 32-bit      }
{ Free Vision library.  The unit is still fully         }
{ functional under BP7 by using the tp compiler         }
{ directive when rebuilding the library.                }
{                                                       }
{*******************************************************}
{ To Do List:                                           }
{   - test all FPK routines                             }
{                                                       }
{*******************************************************}

unit Strings;

{$ifndef linux}
  {$S-}
{$endif}  

interface

const
  UpperCase = ['A'..'Z'];
  LowerCase = ['a'..'z'];

{ LoCase returns the lowercase equivalent of Chr. }

function LoCase(Ch: Char): Char;

{ StrLen returns the number of characters in Str, not counting  }
{ the null terminator.                                          }

function StrLen(Str: PChar): Word;

{ StrEnd returns a pointer to the null character that           }
{ terminates Str.                                               }

function StrEnd(Str: PChar): PChar;

{ StrMove copies exactly Count characters from Source to Dest   }
{ and returns Dest. Source and Dest may overlap.                }

function StrMove(Dest, Source: PChar; Count: Word): PChar;

{ StrCopy copies Source to Dest and returns Dest.               }

function StrCopy(Dest, Source: PChar): PChar;

{ StrECopy copies Source to Dest and returns StrEnd(Dest).      }

function StrECopy(Dest, Source: PChar): PChar;

{ StrLCopy copies at most MaxLen characters from Source to Dest }
{ and returns Dest.                                             }

function StrLCopy(Dest, Source: PChar; MaxLen: Word): PChar;

{ StrPCopy copies the Pascal style string Source into Dest and  }
{ returns Dest.                                                 }

function StrPCopy(Dest: PChar; Source: String): PChar;

{ StrCat appends a copy of Source to the end of Dest and        }
{ returns Dest.                                                 }

function StrCat(Dest, Source: PChar): PChar;

{ StrLCat appends at most MaxLen - StrLen(Dest) characters from }
{ Source to the end of Dest, and returns Dest.                  }

function StrLCat(Dest, Source: PChar; MaxLen: Word): PChar;

{ StrComp compares Str1 to Str2. The return value is less than  }
{ 0 if Str1 < Str2, 0 if Str1 = Str2, or greater than 0 if      }
{ Str1 > Str2.                                                  }

function StrComp(Str1, Str2: PChar): Integer;

{ StrIComp compares Str1 to Str2, without case sensitivity. The }
{ return value is the same as StrComp.                          }

function StrIComp(Str1, Str2: PChar): Integer;

{ StrLComp compares Str1 to Str2, for a maximum length of       }
{ MaxLen characters. The return value is the same as StrComp.   }

function StrLComp(Str1, Str2: PChar; MaxLen: Word): Integer;

{ StrLIComp compares Str1 to Str2, for a maximum length of      }
{ MaxLen characters, without case sensitivity. The return value }
{ is the same as StrComp.                                       }

function StrLIComp(Str1, Str2: PChar; MaxLen: Word): Integer;

{ StrScan returns a pointer to the first occurrence of Chr in   }
{ Str. If Chr does not occur in Str, StrScan returns NIL. The   }
{ null terminator is considered to be part of the string.       }

function StrScan(Str: PChar; Chr: Char): PChar;

{ StrRScan returns a pointer to the last occurrence of Chr in   }
{ Str. If Chr does not occur in Str, StrRScan returns NIL. The  }
{ null terminator is considered to be part of the string.       }

function StrRScan(Str: PChar; Chr: Char): PChar;

{ StrPos returns a pointer to the first occurrence of Str2 in   }
{ Str1. If Str2 does not occur in Str1, StrPos returns NIL.     }

function StrPos(Str1, Str2: PChar): PChar;

{ StrUpper converts Str to upper case and returns Str.          }

function StrUpper(Str: PChar): PChar;

{ StrLower converts Str to lower case and returns Str.          }

function StrLower(Str: PChar): PChar;

{ StrPas converts Str to a Pascal style string.                 }

function StrPas(Str: PChar): String;

{ StrNew allocates a copy of Str on the heap. If Str is NIL or  }
{ points to an empty string, StrNew returns NIL and doesn't     }
{ allocate any heap space. Otherwise, StrNew makes a duplicate  }
{ of Str, obtaining space with a call to the GetMem standard    }
{ procedure, and returns a pointer to the duplicated string.    }
{ The allocated space is StrLen(Str) + 1 bytes long.            }

function StrNew(Str: PChar): PChar;

{ StrDispose disposes a string that was previously allocated    }
{ with StrNew. If Str is NIL, StrDispose does nothing.          }

procedure StrDispose(Str: PChar);

implementation

{$ifdef tp}
{$W-}
{$else}
const
  MaxWord = 65535;
{$endif tp}

function LoCase(Ch: Char): Char;
begin
  if Ch in UpperCase then
    LoCase := Chr(Ord(Ch) + 32)
  else
    LoCase := Ch;
end;

{$ifdef tp}
function StrLen(Str: PChar): Word; assembler;
asm
	CLD
	LES	DI,Str
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	MOV	AX,0FFFEH
	SUB	AX,CX
end;
{$else}
function StrLen(Str: PChar): Word;
var
  i: Word;
begin
  i := 0;
  while (Str[i] <> #0) and (i < MaxWord) do
    Inc(i);
  StrLen := i;
end;
{$endif tp}

{$ifdef tp}
function StrEnd(Str: PChar): PChar; assembler;
asm
	CLD
	LES	DI,Str
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	MOV	AX,DI
	MOV	DX,ES
	DEC	AX
end;
{$else}
function StrEnd(Str: PChar): PChar;
var
  i: Word;
begin
  i := StrLen(Str);
  if i = 0 then
    StrEnd := Str
  else
    StrEnd := Addr(Str[i]);
end;
{$endif tp}

{$ifdef tp}
function StrMove(Dest, Source: PChar; Count: Word): PChar; assembler;
asm
	PUSH	DS
	CLD
	LDS	SI,Source
	LES	DI,Dest
	MOV	AX,DI
	MOV	DX,ES
	MOV	CX,Count
	CMP	SI,DI
	JAE	@@1
	STD
	ADD	SI,CX
	ADD	DI,CX
	DEC	SI
	DEC	DI
@@1:	REP	MOVSB
	CLD
	POP	DS
end;
{$else}
function StrMove(Dest, Source: PChar; Count: Word): PChar;
begin
  Move(Source^,Dest^,Count);
  StrMove := Dest;
end;
{$endif tp}

{$ifdef tp}
function StrCopy(Dest, Source: PChar): PChar; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Source
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	NOT	CX
	LDS	SI,Source
	LES	DI,Dest
	MOV	AX,DI
	MOV	DX,ES
	REP	MOVSB
	POP	DS
end;
{$else}
function StrCopy(Dest, Source: PChar): PChar;
var
  i: Word;
begin
  i := StrLen(Source);
  StrMove(Dest,Source,i);
  Dest[i] := #0;
  StrCopy:=Dest;
end;
{$endif tp}

{$ifdef tp}
function StrECopy(Dest, Source: PChar): PChar; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Source
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	NOT	CX
	LDS	SI,Source
	LES	DI,Dest
	REP	MOVSB
	MOV	AX,DI
	MOV	DX,ES
	DEC	AX
	POP	DS
end;
{$else}
function StrECopy(Dest, Source: PChar): PChar;
begin
  StrCopy(Dest,Source);
  StrECopy := @Dest[StrLen(Dest)];
end;
{$endif tp}

{$ifdef tp}
function StrLCopy(Dest, Source: PChar; MaxLen: Word): PChar; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Source
	MOV	CX,MaxLen
	MOV	BX,CX
	XOR	AL,AL
	REPNE	SCASB
	SUB	BX,CX
	MOV	CX,BX
	LDS	SI,Source
	LES	DI,Dest
	MOV	BX,DI
	MOV	DX,ES
	REP	MOVSB
	STOSB
	XCHG	AX,BX
	POP	DS
end;
{$else}
function StrLCopy(Dest, Source: PChar; MaxLen: Word): PChar;
var
  i: Word;
begin
  i := StrLen(Source);
  if i > MaxLen then
    i := MaxLen;
  Move(Source^,Dest^,i);
  Dest[i] := #0;
  StrLCopy := Dest;
end;
{$endif tp}

{$ifdef tp}
function StrPCopy(Dest: PChar; Source: String): PChar; assembler;
asm
	PUSH	DS
	CLD
	LDS	SI,Source
	LES	DI,Dest
	MOV	BX,DI
	MOV	DX,ES
	LODSB
	XOR	AH,AH
	XCHG	AX,CX
	REP	MOVSB
	XOR	AL,AL
	STOSB
	XCHG	AX,BX
	POP	DS
end;
{$else}
function StrPCopy(Dest: PChar; Source: String): PChar;
begin
  Move(@(Source[1]),Dest^,Byte(Source[0]));
  Dest[Byte(Source[0])] := #0;
  StrPCopy:=Dest;
end;
{$endif tp}

{$ifdef tp}
function StrCat(Dest, Source: PChar): PChar; assembler;
asm
	PUSH	Dest.Word[2]
	PUSH	Dest.Word[0]
	PUSH	CS
	CALL	NEAR PTR StrEnd
	PUSH	DX
	PUSH	AX
	PUSH	Source.Word[2]
	PUSH	Source.Word[0]
	PUSH	CS
	CALL	NEAR PTR StrCopy
	MOV	AX,Dest.Word[0]
	MOV	DX,Dest.Word[2]
end;
{$else}
function StrCat(Dest, Source: PChar): PChar;
begin
  StrCat := StrCopy(@Dest[StrLen(Dest)],Source);
end;
{$endif tp}

{$ifdef tp}
function StrLCat(Dest, Source: PChar; MaxLen: Word): PChar; assembler;
asm
	PUSH	Dest.Word[2]
	PUSH	Dest.Word[0]
	PUSH	CS
	CALL	NEAR PTR StrEnd
	MOV	CX,Dest.Word[0]
	ADD	CX,MaxLen
	SUB	CX,AX
	JBE	@@1
	PUSH	DX
	PUSH	AX
	PUSH	Source.Word[2]
	PUSH	Source.Word[0]
	PUSH	CX
	PUSH	CS
	CALL	NEAR PTR StrLCopy
@@1:	MOV	AX,Dest.Word[0]
	MOV	DX,Dest.Word[2]
end;
{$else}
function StrLCat(Dest, Source: PChar; MaxLen: Word): PChar;
begin
  StrLCat := StrLCopy(@Dest[StrLen(Dest)],Source,MaxLen);
end;
{$endif tp}

{$ifdef tp}
function StrComp(Str1, Str2: PChar): Integer; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Str2
	MOV	SI,DI
	MOV	CX,0FFFFH
	XOR	AX,AX
	CWD
	REPNE	SCASB
	NOT	CX
	MOV	DI,SI
	LDS	SI,Str1
	REPE	CMPSB
	MOV	AL,DS:[SI-1]
	MOV	DL,ES:[DI-1]
	SUB	AX,DX
	POP	DS
end;
{$else}
function StrComp(Str1, Str2: PChar): Integer;
var
  Len1, Len2: Word;
begin
  Len1 := StrLen(Str1);
  Len2 := StrLen(Str2);
  if Len1 > Len2 then
    Len1 := Succ(Len2)
  else
    Inc(Len1);
  StrComp := StrLComp(Str1,Str2,Len1)
end;
{$endif tp}

{$ifdef tp}
function StrIComp(Str1, Str2: PChar): Integer; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Str2
	MOV	SI,DI
	MOV	CX,0FFFFH
	XOR	AX,AX
	CWD
	REPNE	SCASB
	NOT	CX
	MOV	DI,SI
	LDS	SI,Str1
@@1:	REPE	CMPSB
	JE	@@4
	MOV	AL,DS:[SI-1]
	CMP	AL,'a'
	JB	@@2
	CMP	AL,'z'
	JA	@@2
	SUB	AL,20H
@@2:	MOV	DL,ES:[DI-1]
	CMP	DL,'a'
	JB	@@3
	CMP	DL,'z'
	JA	@@3
	SUB	DL,20H
@@3:	SUB	AX,DX
	JE	@@1
@@4:	POP	DS
end;
{$else}
function StrIComp(Str1, Str2: PChar): Integer;
var
  Len1, Len2: Word;
begin
  Len1 := StrLen(Str1);
  Len2 := StrLen(Str2);
  if Len1 > Len2 then
    Len1 := Succ(Len2)
  else
    Inc(Len1);
  StrIComp := StrLIComp(Str1,Str2,Len1)
end;
{$endif tp}

{$ifdef tp}
function StrLComp(Str1, Str2: PChar; MaxLen: Word): Integer; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Str2
	MOV	SI,DI
	MOV	AX,MaxLen
	MOV	CX,AX
	JCXZ	@@1
	XCHG	AX,BX
	XOR	AX,AX
	CWD
	REPNE	SCASB
	SUB	BX,CX
	MOV	CX,BX
	MOV	DI,SI
	LDS	SI,Str1
	REPE	CMPSB
	MOV	AL,DS:[SI-1]
	MOV	DL,ES:[DI-1]
	SUB	AX,DX
@@1:	POP	DS
end;
{$else}
function StrLComp(Str1, Str2: PChar; MaxLen: Word): Integer;
var
  i, Len, Len1, Len2: Word;
  j: Integer;
begin
  i := 0;
  Len1 := StrLen(Str1);
  Len2 := StrLen(Str2);
  if Len1 > Len2 then
    Len := Len2
  else
    Len := Len1;
  if Len > MaxLen then
    Len := MaxLen;
  j := 0;
  while (i < Len) do
  begin
    if Str1[i] = Str2[i] then
      Inc(i)
    else
      if Str1[i] < Str2[i] then
        j := -1
      else
        j := 1;
  end;
  if (i > Len) then
    if Len1 > Len2 then
      j := 1
    else
      j := -1;
  StrLComp := j;
end;
{$endif tp}

{$ifdef tp}
function StrLIComp(Str1, Str2: PChar; MaxLen: Word): Integer; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Str2
	MOV	SI,DI
	MOV	AX,MaxLen
	MOV	CX,AX
	JCXZ	@@4
	XCHG	AX,BX
	XOR	AX,AX
	CWD
	REPNE	SCASB
	SUB	BX,CX
	MOV	CX,BX
	MOV	DI,SI
	LDS	SI,Str1
@@1:	REPE	CMPSB
	JE	@@4
	MOV	AL,DS:[SI-1]
	CMP	AL,'a'
	JB	@@2
	CMP	AL,'z'
	JA	@@2
	SUB	AL,20H
@@2:	MOV	DL,ES:[DI-1]
	CMP	DL,'a'
	JB	@@3
	CMP	DL,'z'
	JA	@@3
	SUB	DL,20H
@@3:	SUB	AX,DX
	JE	@@1
@@4:	POP	DS
end;
{$else}
function StrLIComp(Str1, Str2: PChar; MaxLen: Word): Integer;
var
  i, Len, Len1, Len2: Word;
  Ch1, Ch2: Char;
  j: Integer;
begin
  i := 0;
  Len1 := StrLen(Str1);
  Len2 := StrLen(Str2);
  if Len1 > Len2 then
    Len := Len2
  else
    Len := Len1;
  if Len > MaxLen then
    Len := MaxLen;
  j := 0;
  while (i < Len) do
  begin
    Ch1 := Str1[i];
    Ch2 := Str2[i];
    if Ch1 = Ch2 then
      Inc(i)
    else
      if Ch1 < Ch2 then
        j := -1
      else
        j := 1;
  end;
  if (i > Len) then
    if Len1 > Len2 then
      j := 1
    else
      j := -1;
  StrLIComp := j;
end;
{$endif tp}

{$ifdef tp}
function StrScan(Str: PChar; Chr: Char): PChar; assembler;
asm
	CLD
	LES	DI,Str
	MOV	SI,DI
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	NOT	CX
	MOV	DI,SI
	MOV	AL,Chr
	REPNE	SCASB
	MOV	AX,0
	CWD
	JNE	@@1
	MOV	AX,DI
	MOV	DX,ES
	DEC	AX
@@1:
end;
{$else}
function StrScan(Str: PChar; Chr: Char): PChar;
var
  i, Len: Word;
begin
  Len := StrLen(Str) + 1;
  i := 0;
  while (i < Len) and (Str[i] <> Chr) do
    Inc(i);
  if i = Len then
    StrScan := nil
  else StrScan := Addr(Str[i]);
end;
{$endif tp}

{$ifdef tp}
function StrRScan(Str: PChar; Chr: Char): PChar; assembler;
asm
	CLD
	LES	DI,Str
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	NOT	CX
	STD
	DEC	DI
	MOV	AL,Chr
	REPNE	SCASB
	MOV	AX,0
	CWD
	JNE	@@1
	MOV	AX,DI
	MOV	DX,ES
	INC	AX
@@1:	CLD
end;
{$else}
function StrRScan(Str: PChar; Chr: Char): PChar;
var
  i: Word;
begin
  i := StrLen(Str);
  while (i <> 0) and (Str[i] <> Chr) do
    Dec(i);
  if (Chr = Str[i]) then
    StrRScan := Addr(Str[i])
  else
    StrRScan := nil;
end;
{$endif tp}

{$ifdef tp}
function StrPos(Str1, Str2: PChar): PChar; assembler;
asm
	PUSH	DS
	CLD
	XOR	AL,AL
	LES	DI,Str2
	MOV	CX,0FFFFH
	REPNE	SCASB
	NOT	CX
	DEC	CX
	JE	@@2
	MOV	DX,CX
	MOV	BX,ES
	MOV	DS,BX
	LES	DI,Str1
	MOV	BX,DI
	MOV	CX,0FFFFH
	REPNE	SCASB
	NOT	CX
	SUB	CX,DX
	JBE	@@2
	MOV	DI,BX
@@1:	MOV	SI,Str2.Word[0]
	LODSB
	REPNE	SCASB
	JNE	@@2
	MOV	AX,CX
	MOV	BX,DI
	MOV	CX,DX
	DEC	CX
	REPE	CMPSB
	MOV	CX,AX
	MOV	DI,BX
	JNE	@@1
	MOV	AX,DI
	MOV	DX,ES
	DEC	AX
	JMP	@@3
@@2:	XOR	AX,AX
	MOV	DX,AX
@@3:	POP	DS
end;
{$else}
function StrPos(Str1, Str2: PChar): PChar;
var
  count: Longint;
  oldindex: Longint;
  found: boolean;
  Str1Length: Longint;
  Str2Length: Longint;
  ll: Longint;
Begin
  Str1Length := StrLen(Str1);
  Str2Length := StrLen(Str2);
  found := true;
  oldindex := 0;
  { If the search string is greater than the string to be searched }
  { it is certain that we will not find it.                        }
  { Furthermore looking for a null will simply give out a pointer, }
  { to the null character of str1 as in Borland Pascal.            }
  if (Str2Length > Str1Length) or (Str2[0] = #0) then
   begin
     StrPos := nil;
     exit;
   end;
  Repeat
    { Find first matching character of Str2 in Str1 }
    { put index of this character in oldindex       }
    for count:= oldindex to Str1Length-1 do
     begin
       if Str2[0] = Str1[count] then
        begin
          oldindex := count;
          break;
        end;
       { nothing found - exit routine }
       if count = Str1Length-1 then
        begin
          StrPos := nil;
          exit;
        end;
     end;
    found := true;
    { Compare the character strings }
    { and check if they match.      }
    for ll := 0 to Str2Length-1 do
     begin
       { no match, stop iteration }
       if (Str2[ll] <> Str1[ll+oldindex]) then
        begin
          found := false;
          break;
        end;
     end;
    { Not found, the index will no point at next character }
    if not found then
     Inc(oldindex);
    { There was a match }
    if found then
     begin
       StrPos := @(Str1[oldindex]);
       exit;
     end;
    { If we have gone through the whole string to search }
    { then exit routine.                                 }
  Until (Str1Length-oldindex) <= 0;
  StrPos := nil;
end;
{$endif tp}

{$ifdef tp}
function StrUpper(Str: PChar): PChar; assembler;
asm
	PUSH	DS
	CLD
	LDS	SI,Str
	MOV	BX,SI
	MOV	DX,DS
@@1:	LODSB
	OR	AL,AL
	JE	@@2
	CMP	AL,'a'
	JB	@@1
	CMP	AL,'z'
	JA	@@1
	SUB	AL,20H
	MOV	[SI-1],AL
	JMP	@@1
@@2:	XCHG	AX,BX
	POP	DS
end;
{$else}
function StrUpper(Str: PChar): PChar;
var
  i: Word;
begin
  for i := 0 to StrLen(Str) do
    Str[i] := UpCase(Str[i]);
  StrUpper := Str;
end;
{$endif tp}

{$ifdef tp}
function StrLower(Str: PChar): PChar; assembler;
asm
	PUSH	DS
	CLD
	LDS	SI,Str
	MOV	BX,SI
	MOV	DX,DS
@@1:	LODSB
	OR	AL,AL
	JE	@@2
	CMP	AL,'A'
	JB	@@1
	CMP	AL,'Z'
	JA	@@1
	ADD	AL,20H
	MOV	[SI-1],AL
	JMP	@@1
@@2:	XCHG	AX,BX
	POP	DS
end;
{$else}
function StrLower(Str: PChar): PChar;
var
  i: Word;
begin
  for i := 0 to StrLen(Str) do
    Str[i] := LoCase(Str[i]);
  StrLower := Str;
end;
{$endif tp}

{$ifdef tp}
function StrPas(Str: PChar): String; assembler;
asm
	PUSH	DS
	CLD
	LES	DI,Str
	MOV	CX,0FFFFH
	XOR	AL,AL
	REPNE	SCASB
	NOT	CX
	DEC	CX
	LDS	SI,Str
	LES	DI,@Result
	MOV	AL,CL
	STOSB
	REP	MOVSB
	POP	DS
end;
{$else}
function StrPas(Str: PChar): String;
type
  WordRec = record
    Lo, Hi: Byte;
  end;
var
  S: String;
  Len: Word;
  LenRec: WordRec absolute Len;
begin
  Len := StrLen(Str);
  Move(@(Str[0]),@(S[1]),Len);
  Byte(S[0]) := LenRec.Lo;
  StrPas:=S;
end;
{$endif tp}

{$ifdef tp}
{$W+}
{$endif tp}

function StrNew(Str: PChar): PChar;
var
  L: Word;
  P: PChar;
begin
  StrNew := nil;
  if (Str <> nil) and (Str^ <> #0) then
  begin
    L := StrLen(Str) + 1;
    GetMem(P, L);
    if (P <> nil) then
      StrNew := StrMove(P, Str, L);
  end;
end;

procedure StrDispose(Str: PChar);
begin
  if (Str <> nil) then
    FreeMem(Str, StrLen(Str) + 1);
end;

end.
