program BmpCursorsToGvResource;

uses Dos, Objects, WinRes, GenData, BmpCursr;

type
  PCursorBlock = ^TCursorBlock;
  TCursorBlock = object(TGenericDataMaker)
    Bitmap: PBitmap;
    constructor Init(Path: PathStr);
    procedure Store(var S: TStream);
    destructor Done; virtual;
  end;

const
  RCursorBlock: TStreamRec = (
    ObjType: 999;
    VmtLink: Ofs(TypeOf(TCursorBlock)^);
    Load:    nil;
    Store:   @TCursorBlock.Store);

constructor TCursorBlock.Init;
var
  S: PStream;
Begin
  TObject.Init;
  S := New(PDosStream, Init(Path, stOpenRead));
  Bitmap := LoadBitmapFile(S^);
  Dispose(S, Done)
End;

procedure TCursorBlock.Store(var S: TStream);
var
  P, Q: LongInt;
  Z: Word;

 procedure StoreCursor(Ident, AtX, HotspotX, HotspotY, SizeX, SizeY: Integer);
 var
   Cursor: pointer;
   size: Word;
 Begin
   Cursor := ExtractCursorFromBitmap(
     HotspotX, HotspotY, AtX, 0, AtX, 64, SizeX, SizeY, Bitmap);
   S.Write(Ident, 2);
   size := GetCursorSize(Cursor);
   S.Write(Cursor^, size);
   FreeMem(Cursor, size)
 End;

Begin
  P := S.GetPos;
  S.Write(P, 4);		{ Platzhalter }
  StoreCursor( 0,   0, 0, 0, 32, 32);
  StoreCursor( 2, 128, 0, 0, 32, 32);
  StoreCursor( 3, 192, 0, 0, 32, 32);
  StoreCursor(50,  64, 0, 0, 32, 32);
  StoreCursor(51, 320, 0, 0, 32, 32);
  StoreCursor(52, 384, 0, 0, 32, 32);
  StoreCursor(53, 448, 0, 0, 32, 32);
  StoreCursor(54, 576, 0, 0, 32, 32);
  StoreCursor(55, 512, 0, 0, 32, 32);
  Z := 0;
  S.Write(Z, 2);
  Q := S.GetPos;
  S.Seek(P);
  P := Q - (P + 4);
  S.Write(P, 4);
  S.Seek(Q)
End;

destructor TCursorBlock.Done;
Begin
  DeleteBitmap(Bitmap);
  TObject.Done
End;

var
  Res: TResourceFile;

procedure CursorFrom(Path: PathStr; Name: string);
var
  Cursor: TCursorBlock;
Begin
  Cursor.Init(Path);
  Res.Put(@Cursor, Name);
  Cursor.Done
End;

begin
  RegisterType(RCursorBlock);
  Res.Init(New(PDosStream, Init('test.rez', stCreate)));
  CursorFrom('M640350.BMP', 'Cursor640350');
  CursorFrom('M640480.BMP', 'Cursor640480');
  CursorFrom('M800600.BMP', 'Cursor800600');
  CursorFrom('M1024768.BMP', 'Cursor1024768');
  Res.Done
end.
