
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{	Portions copyright (c) 1992 Borland Intl.       }
{       Copyright (c) 1994 Stefan Milius                }
{	Copyright (c) 1997 Matthias Koeppe              }
{                                                       }
{*******************************************************}

Unit GVWList;

{$ifndef FPK}
{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-,V-}
{$endif}

interface

{$ifdef FPK}
uses Objects, Drivers, Views, GVViews, GVDialog, GVApp, GvTexts;
{$else}
uses Objects, Drivers, Views, GVViews, GVDialog, GVApp;
{$endif}

const

{ TWindowList flags }

  wlNormal        = $0000;
  wlNoShowDesktop = $0001;
  wlHelpButton    = $0002;

type
  PWindowColl = ^TWindowColl;
  TWindowColl = object(TCollection)
    procedure FreeItem(Item: pointer); virtual;
  end;

{ TWindowlist object }

  PWindowList = ^TWindowList;
  TWindowList = object (TListBox)
                  constructor Init(var Bounds: TRect; AScrollBar: PScrollBar);
                  destructor Done; virtual;
                  procedure GetDesktop;
                  function GetText(Item: Integer; MaxLen: Integer): String; virtual;
                  procedure HandleEvent(var Event: TEvent); virtual;
                  procedure Store(var S: TStream);
                end;

{ TWListDialog object }

  PWListDialog = ^TWListDialog;
  TWListDialog = object (TDialog)
                   List: PWindowList;
                   constructor Init(AOptions: Word);
                   constructor Load(var S: TStream);
                   procedure GetDeskTop;
                   procedure Store(var S: TStream);
                 end;

{ TWListDialog execution procedure }

procedure ExecuteWindowList(AWListDialog: PWListDialog);

{ Stream registration procedure }

procedure RegisterGVWList;

const

{ Stream registration records }

  RWindowList: TStreamRec = (
     ObjType: 190;
     VmtLink: Ofs(TypeOf(TWindowList)^);
     Load:    @TWindowList.Load;
     Store:   @TWindowList.Store);

  RWListDialog: TStreamRec = (
     ObjType: 191;
     VmtLink: Ofs(TypeOf(TWListDialog)^);
     Load:    @TWListDialog.Load;
     Store:   @TWListDialog.Store);

implementation

{$ifndef FPK}
Uses GVTexts;
{$endif FPK}

const

{ TWindowlist commands }

  cmSelect = 900; cmDelete = 901;

{*********************** TWListDialog execution procedure *******************}

procedure ExecuteWindowList(AWListDialog: PWListDialog);
Begin
  If Application^.ValidView(AWListDialog) <> nil then Begin
    Application^.ExecView(AWListDialog);
    Dispose(AWListDialog, Done)
  End
End;

{***************************** TWindowColl object ***************************}

procedure TWindowColl.FreeItem(Item: pointer);
begin
end;

{***************************** TWindowList object ***************************}

constructor TWindowList.Init(var Bounds: TRect; AScrollBar: PScrollBar);
Begin
  TListBox.Init (Bounds, AScrollBar);
  Options:=Options or ofPostProcess;
  NewList (nil);
End;

destructor TWindowList.Done;
Begin
  NewList(nil);
  inherited Done
End;

procedure TWindowList.GetDesktop;
var NList: PCollection;

 procedure SearchWindows (P: PGView); {$ifndef FPK}far;{$endif}
 Begin
   If P^.GetState(sfVisible) and
      (Message(P, evBroadcast, 40 {cmHeyYou}, nil) = P)
   then NList^.Insert(P)
 End;

Begin
  NList:=New (PWindowColl, Init (8,8));
  Desktop^.ForEachInMethod(@SearchWindows, @Self);
  NewList (NList);
End;

function TWindowList.GetText(Item: Integer; MaxLen: Integer): string;
begin
  GetText := PWindow(List^.At(Item))^.GetTitle(MaxLen)
end;

procedure TWindowList.HandleEvent(var Event: TEvent);

 function GetSel: PGView;
 Begin
   If Focused < List^.Count
   then GetSel := List^.At(Focused)
   else GetSel := nil
 End;

 procedure SelectSel;
 var P: PGView;
 Begin
   P := GetSel;
   If P<>nil then P^.Select;
 End;

 procedure CloseSel;
 var P: PGView;
 Begin
   P:=GetSel;
   If P <> nil then Begin
     PWindow(P)^.Close;
     GetDesktop;
   End;
 End;

Begin
  If GetState (sfSelected) then inherited HandleEvent (Event);
  If (Event.What=evKeyDown) and (Event.KeyCode=kbDel) then Begin
    CloseSel;
    ClearEvent (Event);
  End;
  If Event.What=evBroadCast then Begin
    Case Event.Command Of
      cmSelect: Begin
                  SelectSel;
                  GOwner^.EndModal (cmOK);
                End;
      cmDelete: CloseSel;
     else Exit;
    End;
    ClearEvent (Event);
  End;
  If (Event.What=evCommand) and (Event.Command=cmListItemSelected) and
     (Event.InfoPtr=@Self) then Begin
    Message (@Self, evBroadCast, cmSelect, nil);
    ClearEvent (Event);
  End;
End;

procedure TWindowList.Store(var S: TStream);
var
  Save: PCollection;
begin
  Save := List;
  List := nil;
  inherited Store(S);
  List := Save
end;

{***************************** TWListDialog object **************************}

constructor TWListDialog.Init(AOptions: Word);
var R: TRect;
    Control: PGView;
Begin

  R.Assign (0,0,430,220);
  TDialog.Init (R, GetStr(132));

  Options:=Options or ofCentered;

  R.Assign (Size.X-125,35,Size.X-25,60);
  Insert (New (PButton, Init (R, '~O~K', cmSelect, bfDefault+bfBroadCast)));
  R.Move (0,35);
  Insert (New (PButton, Init (R, GetStr(133), cmDelete, bfNormal+bfBroadCast)));
  R.Move (0,35);
  Insert (New (PButton, Init (R, GetStr(134), cmCancel,bfNormal)));
  R.Move (0,35);
  If AOptions and wlHelpButton <>0 then Begin
    Control:=New (PButton, Init (R, GetStr(135),cmHelp,bfNormal));
    Insert (Control);
  End;

  R.Assign (262,60,280,198);
  Control:=New (PScrollBar, Init(R));
  R.Assign(15,60,263,198);
  List:=New (PWindowList, Init (R, PScrollBar(Control)));
  Insert (Control);
  R.Assign (15,35,80,55);
  Control:=New (PLabel, Init (R, GetStr(136), List));
  Insert (List);
  Insert (Control);
  If AOptions and wlNoShowDesktop = 0 then GetDesktop;
End;

constructor TWListDialog.Load(var S: TStream);
Begin
  inherited Load (S);
  GetSubViewPtr (S,List);
  GetDesktop;
End;

procedure TWListDialog.GetDesktop;
Begin
  List^.GetDesktop;
  List^.FocusItem(1);
End;

procedure TWListDialog.Store(var S: TStream);
Begin
  inherited Store (S);
  PutSubViewPtr (S, PGView (List));
End;

{*********************** Stream registration procedure **********************}

procedure RegisterGVWList;
Begin
  RegisterType(RWindowList);
  RegisterType(RWListDialog);
End;

End.
