unit KeyNames;

{ Graphics Vision Unit,
  Copr. 1995, 1999 Matthias Koeppe

  $Id: keynames.pas 1.3 1999/02/12 12:21:47 mkoeppe Exp $
 
  Determines the name of a key specified by its scan-code, using
  language-dependent components.
}

{$ifndef FPK}
{$A+,B-,F+,G+,I-,O+,P-,Q-,R-,S-,T-,V+,X+}
{$endif FPK}

interface

{$ifdef Windows}
uses WinRes, WinGr, GvViews, GvMenus;
{$else}
uses WinRes, GvViews, GvMenus;
{$endif}

const
  sComposeKeys   = 200;
  sSequenceKeys  = 201;
  sAltModifier   = 202;
  sCtrlModifier  = 203;
  sShiftModifier = 204;
  sFunctionKey   = 205;
  sEscapeKey     = 206;
  sTabKey        = 207;
  sPrintKey      = 208;
  sScrollKey     = 209;
  sPauseKey      = 210;
  sBackspaceKey  = 211;
  sEnterKey      = 212;
  sInsertKey     = 213;
  sDeleteKey     = 214;
  sHomeKey       = 215;
  sEndKey        = 216;
  sPageUpKey     = 217;
  sPageDownKey   = 218;
  sSpaceKey      = 219;
  sLeftKey       = 220;
  sRightKey      = 221;
  sUpKey         = 222;
  sDownKey       = 223;
  sMinusKey      = 224;
  sPlusKey       = 225;
  sAltMinusKey   = 226;
  sAltEqualKey   = 227;
  sCursorKeys    = 228;

function kn(KeyCode: Word): string;

{ Simplified menu NewItem function
}
function NewItemKn(const Name: TMenuStr; KeyCode: Word; Command: Word;
  AHelpCtx: Word; Next: PMenuItem): PMenuItem;
function NewItemKnHc(const Name: TMenuStr; KeyCode: Word; Command: Word;
  Next: PMenuItem): PMenuItem;

{ Simplified NewStatusKey function
}
function NewStatusKeyKn(const Text: String; KeyCode: Word; Command: Word;
  Next: PStatusItem): PStatusItem;

{ Add accelerator codes and key names to a menu
}
procedure AddAccelerators(Menu: PMenu; Accelerators: PAccelerators);

implementation

uses Objects, GvTexts, Drivers, Strings;

{$ifdef FPK}
var
  Temp: PChar;
{$endif}

function kn(KeyCode: Word): string;
var
  c: Char;
  Result_: PChar;
  Cur: PChar;

	procedure F(num: integer);
	var
	  s: string[2];
	begin
	  Cur := StrEnd(StrGet(sFunctionKey, Cur, 255));
	  Str(num, s);
	  Cur := StrEnd(StrPCopy(Cur, s));
	end;

	procedure S(Key: Integer);
	begin
	  Cur := StrEnd(StrGet(Key, Cur, 255));
	end;

	procedure Ch(c: Char);
        begin
	  Cur[0] := c;
	  Inc(Cur);
	  Cur[0] := #0;
	end;

	procedure Compose(Modifier: Integer);
	begin
	  Cur := StrEnd(StrGet(Modifier, Cur, 255));
	  Cur := StrEnd(StrGet(sComposeKeys, Cur, 255));
	end;

	procedure Comp(Modifier: Integer; Key: Integer);
	begin
	  Compose(Modifier);
	  Cur := StrEnd(StrGet(Key, Cur, 255));
	end;

begin
{$ifdef FPK}
  asm
    movl __Result, %eax
    movl %eax, _TEMP
  end;
  Result_ := Temp;
{$else}
  asm
     les di, @Result;
     mov Result_.word, di
     mov Result_.2.word, es
  end;
{$endif}
  Cur := Result_ + 1;
  If Lo(KeyCode) = 0 then
  case Hi(KeyCode) of
    $3B..$44:
      F(Hi(KeyCode) - $3A);
    $54..$5D:
      begin
	Compose(sShiftModifier);
	F(Hi(KeyCode) - $53)
      end;
    $5E..$67:
      begin
	Compose(sCtrlModifier);
        F(Hi(KeyCode) - $5D)
      end;
    $68..$71:
      begin
        Compose(sAltModifier);
        F(Hi(KeyCode) - $67)
      end;
    Hi(Word(kbAltEqual)):
      S(sAltEqualKey);
    Hi(Word(kbAltMinus)):
      S(sAltMinusKey);
    Hi(Word(kbAltSpace)):
      Comp(sAltModifier, sSpaceKey);
    Hi(Word(kbCtrlDel)):
      Comp(sCtrlModifier, sDeleteKey);
    Hi(Word(kbCtrlEnd)):
      Comp(sCtrlModifier, sEndKey);
    Hi(Word(kbCtrlHome)):
      Comp(sCtrlModifier, sHomeKey);
    Hi(Word(kbCtrlIns)):
      Comp(sCtrlModifier, sInsertKey);
    Hi(Word(kbCtrlLeft)):
      Comp(sCtrlModifier, sLeftKey);
    Hi(Word(kbCtrlPgDn)):
      Comp(sCtrlModifier, sPageDownKey);
    Hi(Word(kbCtrlPgUp)):
      Comp(sCtrlModifier, sPageUpKey);
    Hi(Word(kbCtrlPrtSc)):
      Comp(sCtrlModifier, sPrintKey);
    Hi(Word(kbCtrlRight)):
      Comp(sCtrlModifier, sRightKey);
    Hi(Word(kbDel)):
      S(sDeleteKey);
    Hi(Word(kbDown)):
      S(sDownKey);
    Hi(Word(kbEnd)):
      S(sEndKey);
    Hi(Word(kbHome)):
      S(sHomeKey);
    Hi(Word(kbIns)):
      S(sInsertKey);
    Hi(Word(kbLeft)):
      S(sLeftKey);
    Hi(Word(kbPgDn)):
      S(sPageDownKey);
    Hi(Word(kbPgUp)):
      S(sPageUpKey);
    Hi(Word(kbRight)):
      S(sRightKey);
    Hi(Word(kbShiftDel)):
      Comp(sShiftModifier, sDeleteKey);
    Hi(Word(kbShiftIns)):
      Comp(sShiftModifier, sInsertKey);
    Hi(Word(kbShiftTab)):
      Comp(sShiftModifier, sTabKey);
    Hi(Word(kbUp)):
      S(sUpKey);
    else begin
      c := GetAltChar(KeyCode);
      If c <> #0
      then begin
	Compose(sAltModifier);
	Ch(c)
      end
    end;
  end else
  case KeyCode of
    kbBack:
      S(sBackspaceKey);
    kbCtrlBack:
      Comp(sCtrlModifier, sBackspaceKey);
    kbCtrlEnter:
      Comp(sCtrlModifier, sEnterKey);
    kbEnter:
      S(sEnterKey);
    kbEsc:
      S(sEscapeKey);
    kbGrayMinus:
      S(sMinusKey);
    kbGrayPlus:
      S(sPlusKey);
    kbTab:
      S(sTabKey);
    else begin
      c := GetCtrlChar(KeyCode);
      If c <> #0
      then begin
	Compose(sCtrlModifier);
	Ch(c)
      end;
    end;
  end;
  Result_[0] := Chr((Cur - Result_) - 1);
end;

function NewItemKn(const Name: TMenuStr; KeyCode: Word; Command: Word;
  AHelpCtx: Word; Next: PMenuItem): PMenuItem;
begin
  NewItemKn := NewItem(Name, kn(KeyCode), KeyCode, Command, AHelpCtx, Next)
end;

function NewItemKnHc(const Name: TMenuStr; KeyCode: Word; Command: Word;
  Next: PMenuItem): PMenuItem;
begin
  NewItemKnHc := NewItem(Name, kn(KeyCode), KeyCode, Command, hc + Command, Next)
end;

function NewStatusKeyKn(const Text: String; KeyCode: Word; Command: Word;
  Next: PStatusItem): PStatusItem;
begin
  NewStatusKeyKn := NewStatusKey('~' + kn(KeyCode) + '~ ' + Text,
    KeyCode, Command, Next)
end;

procedure AddAccelerators(Menu: PMenu; Accelerators: PAccelerators);
var
  Item: PMenuItem;
begin
  If Menu <> nil
  then begin
    Item := Menu^.Items;
    while Item <> nil do
      with Item^ do
      begin
	If Command = 0
	then AddAccelerators(SubMenu, Accelerators)
	else begin
	  If Accelerators <> nil
	  then begin
	    if KeyCode = 0
	    then KeyCode := LookUpAccelerator(Accelerators, Command)
	  end;
	  If (KeyCode <> 0) and (Param = nil)
	  then Param := NewStr(kn(KeyCode))
	end;
	Item := Next
      end
  end
end;

end.
