{
   $Id: mouse.pas,v 1.2 1998/12/11 00:13:17 peter Exp $

   Mouse unit, part of the portable API for Pascal

   Copyright (c) 1997 Balazs Scheidler (bazsi@balabit.hu)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.


   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************}
unit Mouse;

interface
{$i platform.inc}

uses
  Common;

const
  { We have an errorcode base of 1010 }
  errMouseInitError               = errMouseBase + 0;
  errMouseNotImplemented          = errMouseBase + 1;

type
  PMouseEvent=^TMouseEvent;
  TMouseEvent=packed record { 8 bytes }
    buttons : word;
    x,y     : word;
    Action  : word;
  end;

const
  MouseActionDown = $0001;                         { Mouse down event }
  MouseActionUp   = $0002;                         { Mouse up event }
  MouseActionMove = $0004;                         { Mouse move event }
  MouseActionAuto = $0008;                         { Mouse auto event }

  MouseLeftButton   = $01;                         { Left mouse button }
  MouseRightButton  = $02;                         { Right mouse button }
  MouseMiddleButton = $04;                         { Middle mouse button }

  MouseEventBufSize = 16;

var
  PendingMouseEvent  : array[0..MouseEventBufSize-1] of TMouseEvent;
  PendingMouseHead,
  PendingMouseTail   : PMouseEvent;
  PendingMouseEvents : byte;

  LastMouseEvent : TMouseEvent;

  MouseIntFlag : Byte;                                { Mouse in int flag }
  MouseButtons : Byte;                                { Mouse button state }
  MouseWhereX,
  MouseWhereY  : Word;                                { Mouse position }


procedure InitMouse;
{ Initialize the mouse interface }

procedure DoneMouse;
{ Deinitialize the mouse interface }

function DetectMouse:byte;
{ Detect if a mouse is present, returns the amount of buttons or 0
  if no mouse is found }

procedure ShowMouse;
{ Show the mouse cursor }

procedure HideMouse;
{ Hide the mouse cursor }

function GetMouseX:word;
{ Return the current X position of the mouse }

function GetMouseY:word;
{ Return the current Y position of the mouse }

function GetMouseButtons:word;
{ Return the current button state of the mouse }

procedure SetMouseXY(x,y:word);
{ Place the mouse cursor on x,y }

procedure GetMouseEvent(var MouseEvent:TMouseEvent);
{ Returns the last Mouseevent, and waits for one if not available }

procedure PutMouseEvent(const MouseEvent: TMouseEvent);
{ Adds the given MouseEvent to the input queue. Please note that depending on
  the implementation this can hold only one value (NO FIFOs etc) }

function PollMouseEvent(var MouseEvent: TMouseEvent):boolean;
{ Checks if a Mouseevent is available, and returns it if one is found. If no
  event is pending, it returns 0 }

implementation

{ Include platform dependent routines }

{$i mouse.inc}

{ Platform independent routines }

procedure PutMouseEvent(const MouseEvent: TMouseEvent);
begin
  if PendingMouseEvents<MouseEventBufSize then
   begin
     PendingMouseTail^:=MouseEvent;
     inc(PendingMouseTail);
     if longint(PendingMouseTail)=longint(@PendingMouseEvent)+sizeof(PendingMouseEvent) then
      PendingMouseTail:=@PendingMouseEvent;
   end
end;

end.
{
  $Log: mouse.pas,v $
  Revision 1.2  1998/12/11 00:13:17  peter
    + SetMouseXY
    * use far for exitproc procedure

  Revision 1.1  1998/12/04 12:48:24  peter
    * moved some dirs

  Revision 1.1  1998/10/28 00:02:07  peter
    + mouse
    + video.clearscreen, video.videobufsize

}
