{
   $Id: keyboard.inc,v 1.2 1999/01/09 07:30:00 florian Exp $
   System independent keyboard interface for windows

   Copyright (c) 1999 by Florian Klaempfl
   Member of the Free Pascal development team

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.


   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************}

uses
   Event;

var
   keyboardeventqueue : array[0..maxqueuesize] of KEYBOARD_EVENT_RECORD;
   nextkeyevent,nextfreekeyevent : longint;

procedure incqueueindex(var l : longint);

  begin
     inc(l);
     { wrap around? }
     if l>maxqueuesize then
       l:=0;
  end;

{ this handler is called by the event unit }
procedure HandleKeyboard;
var
   ir : INPUT_RECORD;
   dwRead : DWord;
begin
   dwRead:=1;
   repeat
     ReadConsoleInput(FileRec(Input).Handle,ir,1,dwRead);
     if (dwRead=1) and (ir.EventType=KEY_EVENT) then
       begin
           with ir.Event.KeyEvent do
             begin
                { key up events are ignored }
                if bKeyDown then
                  begin
                     for i:=1 to wRepeatCount do
                       begin
                          keyboardeventqueue[nextfreekeyevent]:=
                            ir.Event.KeyEvent
                       end;
                  end;
             end;
       end;
   until dwRead=0;
end;

procedure InitKeyboard;
begin
   SetKeyboardEventHandler(HandleKeyboard);
   nextkeyevent:=0;
   nextfreekeyevent:=0;
end;

procedure DoneKeyboard;
begin
   SetKeyboardEventHandler(nil);
end;

function GetKeyEvent: TKeyEvent;
begin
end;

function PollKeyEvent: TKeyEvent;
begin
end;

function TranslateKeyEvent(KeyEvent: TKeyEvent): TKeyEvent;
begin
end;

function TranslateKeyEventUniCode(KeyEvent: TKeyEvent): TKeyEvent;
begin
end;

{
  $Log: keyboard.inc,v $
  Revision 1.2  1999/01/09 07:30:00  florian
    * small additions, not completed yet

  Revision 1.1  1998/12/04 12:49:01  peter
    * moved some dirs

  Revision 1.1  1998/10/26 11:31:49  peter
    + inital include files
}
