{Known Bugs
----------
TPrinterInstallDlg  -  If the TTVPrinterCollection.Error
method is deleted, a collection index error occurs when
deleting an installed printer that is usually the last item
in the list of installed printers.  The error method
eleviates the problem, at least in real mode. }
{***************************************************}
{                                                   }
{     WVS Software Company                          }
{     TurboVision Printing Unit                     }
{     Version Unit 1.1                              }
{     Programmers: Brad Williams, DVM               }
{     Last Update: 05/01/94                         }
{                                                   }
{***************************************************}
{                                                   }
{ Conditional compilation directives:               }
{                                                   }
{ ResourceFile - gets dialogs off of a resource     }
{    declared in the Resource unit as ResourceFile; }
{    the default is to NOT use resource files       }
{                                                   }
{ OnePrinter - only allows the user to have one     }
{    printer installed;  the default is multiple    }
{    printer support                                }
{                                                   }
{ NewEdit - use the NewEdit unit instead of the     }
{    Editors unit that comes with TV                }
{                                                   }
{***************************************************}
UNIT tvPrint;

{$i platform.inc}

{$ifdef PPC_FPC}
  {$H-}
{$else}
  {$F+,O+,E+,N+}
{$endif}
{$X+,R-,I-,Q-,V-}
{$ifndef OS_LINUX}
  {$S-}
{$endif}

{****************************************************************************}
                                INTERFACE
{****************************************************************************}
USES Dos, Objects, Validate, Drivers, Views, Dialogs, Menus, StdDlg,
     {$IFDEF NewEdit} NewEdit, {$ELSE} Editors, {$ENDIF NewEdit}
     Printers;

CONST
  DriverMask      = '*.DRV';
  PrinterFileMask = '*.PRN';

  cmPrint              = 1;
  cmPrintSelected      = cmPrint + 1;

  cmPrinterInstall     = cmPrintSelected + 1;
  cmPrinterSelect      = cmPrinterInstall + 1;
  cmPrinterSetup       = cmPrinterSelect + 1;
  cmPrintQueue         = cmPrinterSetup + 1;
  cmPrinterSettings    = cmPrintQueue + 1;
  cmPrinterMakeDefault = cmPrinterSettings + 1;
  cmPrinterPause       = cmPrinterMakeDefault + 1;
  cmPrinterPauseAll    = cmPrinterPause + 1;
  cmPrinterResume      = cmPrinterPauseAll + 1;
  cmPrinterResumeAll   = cmPrinterResume + 1;
  cmPrintFile          = cmPrinterResumeAll + 1;
  cmPrintFormatedFile  = cmPrintFile + 1;

    { Help Contexts }
  hcPrint               = 1;
  hcPrintFile           = hcPrint + 1;
  hcPrintFormatedFile   = hcPrintFile + 1;
  hcPrintEditorDlg      = hcPrintFormatedFile + 1;
  hcPrintRange          = hcPrintEditorDlg + 1;
  hcPrintSelected       = hcPrintRange + 1;
  hcPrinterOutPutDevice = hcPrintSelected + 1;
  hcPrinterSetup        = hcPrinterOutPutDevice + 1;
  hcPrintQueue          = hcPrinterSetup + 1;
  hcPrintDlg            = hcPrintQueue + 1;
  hcPrinter             = hcPrintDlg + 1;
  hcPrinterSettings     = hcPrinter + 1;
  hcPrintNumberOfCopies = hcPrinterSettings + 1;
  hcPrinterSelect       = hcPrintNumberOfCopies + 1;
  hcPrinterMakeDefault  = hcPrinterSelect + 1;
  hcPrinterName         = hcPrinterMakeDefault + 1;
  hcPrinterBrand        = hcPrinterName + 1;
  hcPrinterPort         = hcPrinterBrand + 1;
  hcPrinterBufferSize   = hcPrinterPort + 1;
  hcPrinterTimeOut      = hcPrinterBufferSize + 1;
  hcPrinterFonts        = hcPrinterTimeOut + 1;
  hcPrinterPause        = hcPrinterFonts + 1;
  hcPrinterPauseAll     = hcPrinterPause + 1;
  hcPrinterResume       = hcPrinterPauseAll + 1;
  hcPrinterResumeAll    = hcPrinterResume + 1;
  hcPrinterInstall      = hcPrinterResumeAll + 1;
  hcPrintersInstall     = hcPrinterInstall + 1;
  hcPrinterPostamble    = hcPrintersInstall + 1;
  hcPrinterPreamble     = hcPrinterPostamble + 1;

    { Resource File Keys }
  reEditorPrintDlg      = 'EditorPrintDlg';
  reInstallPrintersDlg  = 'InstallPrintersDlg';
  rePrintFileDlg        = 'PrintFileDlg';
  rePrintQueueDlg       = 'PrintQueueDlg';
  rePrinterSelectDlg    = 'PrinterSelectDlg';
  rePrinterSettingsDlg  = 'PrinterSettingsDlg';
  rePrinterSetupDlg     = 'PrinterSetupDlg';

    { OutPut Devices }
  odPrinter = 0;
  odFile    = 1;

    { Print Ranges }
  prFullDocument  = $0000;
  prSelectedText  = $0001;


TYPE
  PTVPrinter = ^TTVPrinter;
  TTVPrinter = OBJECT(TPrinter)
    FUNCTION  ClearPrintQueue : Boolean; VIRTUAL;
    PROCEDURE Error (Code, Info : Integer); VIRTUAL;
    FUNCTION  LoadPort (VAR S : TStream) : Boolean; VIRTUAL;
    PROCEDURE PrintingCanceledMessage; VIRTUAL;
    PROCEDURE SendUserMessage (PercentCompleted : Word); VIRTUAL;
    PROCEDURE StorePort (VAR S : TStream); VIRTUAL;
    FUNCTION  UserByPassedPause : Boolean; VIRTUAL;
    FUNCTION  UserCanceledPrintJob : Boolean; VIRTUAL;
  END;  { of TTVPrinter }

  PTVPrinterCollection = ^TTVPrinterCollection;
  TTVPrinterCollection = OBJECT(TPrinterCollection)
    PROCEDURE NoPrinterInstalled; VIRTUAL;
  END;  { of TTVPrinterCollection }

  PPrinterSetupDlg = ^TPrinterSetupDlg;
  TPrinterSetupDlg = OBJECT(TDialog)
    CONSTRUCTOR Init;
    PROCEDURE HandleEvent (VAR Event : TEvent); VIRTUAL;
  END;  { of TPrinterSetupDlg }

  PPrinterSetupRec = ^TPrinterSetupRec;
  TPrinterSetupRec = RECORD
    Name : TPrinterNameStr;
    Brand : TPrinterNameStr;
    BufferSize : Word;
    TimeOut : Word;
    Background : Word;
    PrinterPort : Integer;
    PortList : PCollection;
  END;  { TPrinterSetupRec }

  {$IFNDEF OnePrinter}
  PPrintDlg = ^TPrintDlg;
  TPrintDlg = OBJECT(TDialog)
    SelectedPrinter : PInputLine;
    CONSTRUCTOR Load (VAR S : TStream);
    PROCEDURE GetPrinter; VIRTUAL;
    PROCEDURE HandleEvent (VAR Event : TEvent); VIRTUAL;
    PROCEDURE Store (VAR S : TStream); VIRTUAL;
  END;  { of TPrintDlg }
  {$ENDIF OnePrinter}

  PEditorPrintOut = ^TEditorPrintOut;
  TEditorPrintOut = OBJECT(TPrintOut)
    Editor : PEditor;
    CONSTRUCTOR Init (AnEditor : PEditor);
    PROCEDURE Print; VIRTUAL;
    PROCEDURE SetPrintRange (APrintRange : Word);
      PRIVATE
    PrintRange : Word;
  END;

  PEditorPrintDlg = ^TEditorPrintDlg;
  {$IFDEF OnePrinter}
  TEditorPrintDlg = OBJECT(TDialog)
  {$ELSE}
  TEditorPrintDlg = OBJECT(TPrintDlg)
  {$ENDIF OnePrinter}
    CONSTRUCTOR Init;
    {$IFNDEF OnePrinter}
    CONSTRUCTOR Load (VAR S : TStream);
    PROCEDURE GetPrinter; VIRTUAL;
    PROCEDURE Store (VAR S : TStream); VIRTUAL;
      PRIVATE
    DefaultPrinter : PInputLine;
    {$ENDIF OnePrinter}
  END;  { of TEditorPrintDlg }

  TEditorPrintRec = RECORD
    Copies : Word;
    Range : Word;
    OutPutDevice : Word;
    {$IFNDEF OnePrinter}
    DefaultPrinter : Integer;
    SelectedPrinter : Integer;
    {$ENDIF OnePrinter}
  END;  { of TEditorPrintRec }

  {$IFNDEF OnePrinter}
  PPrintFileDlg = ^TPrintFileDlg;
  TPrintFileDlg = OBJECT(TPrintDlg)
    CONSTRUCTOR Init (AFile : FNameStr);
    FUNCTION  FormatFile (AFile : FNameStr) : TPrinterNameStr;
  END;  { of TPrintFileDlg }

  PPrintFileRec = ^TPrintFileRec;
  TPrintFileRec = RECORD
    FileName : FNameStr;
    PrinterName : Integer;
  END;  { of TPrintFileRec }
  {$ENDIF OnePrinter}

  PPrintJobListBox = ^TPrintJobListBox;
  TPrintJobListBox = OBJECT(TListBox)
    FUNCTION GetText (Item : Integer; MaxLen : Integer) : String; VIRTUAL;
  END;  { of TPrintJobListBox }

  {$IFNDEF OnePrinter}
  PPrinterListBox = ^TPrinterListBox;
  TPrinterListBox = OBJECT(TSortedListBox)
    FUNCTION GetText (Item : Integer; MaxLen : Integer) : String; VIRTUAL;
  END;  { of TPrinterListBox }
  {$ENDIF OnePrinter}

  PPrintQueueDlg = ^TPrintQueueDlg;
  TPrintQueueDlg = OBJECT(TDialog)
    CONSTRUCTOR Init;
    CONSTRUCTOR Load (VAR S : TStream);
    PROCEDURE HandleEvent (VAR Event : TEvent); VIRTUAL;
    PROCEDURE Store (VAR S : TStream); VIRTUAL;
      PRIVATE
    PrintJobs : PPrintJobListBox;
    {$IFNDEF OnePrinter}
    PrinterList : PPrinterListBox;
    {$ENDIF OnePrinter}
  END;  { of TPrintQueueDlg }

  TPrintQueueRec = RECORD
    {$IFNDEF OnePrinter}
    PrinterList : TListBoxRec;
    {$ENDIF OnePrinter}
    Queue : TListBoxRec;
  END;  { of TPrintQueueRec }

  {$IFNDEF OnePrinter}
  PPrinterDriver = ^TPrinterDriver;
  TPrinterDriver = OBJECT(TObject)
    FileName : PString;
    Brand : PString;
    CONSTRUCTOR Init (AFile : FNameStr);
    CONSTRUCTOR Load (VAR S : TStream);
    DESTRUCTOR Done; VIRTUAL;
    PROCEDURE Store (VAR S : TStream); VIRTUAL;
  END;  { of TPrinterDriver }

  PDriverCollection = ^TDriverCollection;
  TDriverCollection = OBJECT(TSortedCollection)
    FUNCTION  Compare (Key1, Key2 : Pointer) : Integer; VIRTUAL;
    FUNCTION  KeyOf (Item : Pointer) : Pointer; VIRTUAL;
  END;  { of TDriverCollection }

  PPrinterDriverListBox = ^TPrinterDriverListBox;
  TPrinterDriverListBox = OBJECT(TSortedListBox)
    CONSTRUCTOR Init (R : TRect; AVScrollBar : PScrollBar;
                      ADirectory : FNameStr; AList : PDriverCollection);
    DESTRUCTOR Done; VIRTUAL;
    FUNCTION  GetText (Item : Integer; MaxLen : Integer) : String; VIRTUAL;
    PROCEDURE LoadData (ADirectory : FNameStr);
  END;  { of TPrinterDriverListBox }

  PInstallPrintersDlg = ^TInstallPrintersDlg;
  TInstallPrintersDlg = OBJECT(TDialog)
    InstalledPrinters : PPrinterListBox;
    AvailablePrinters : PPrinterDriverListBox;
    CONSTRUCTOR Init;
    CONSTRUCTOR Load(var S: TStream);
    PROCEDURE DeletePrinter; VIRTUAL;
    PROCEDURE HandleEvent(var Event: TEvent); virtual;
    PROCEDURE InstallPrinter; VIRTUAL;
    PROCEDURE Store(var S: TStream);
  END; { of TInstallPrintersDlg }

  PInstallPrinterRec = ^TInstallPrinterRec;
  TInstallPrinterRec = RECORD
    InstalledPrinters : TListBoxRec;
    AvailablePrinters : TListBoxRec;
  END;  { TInstallPrinterRec }
  {$ENDIF OnePrinter}

    { Provided for data conversion only.  Allows data transfer as an }
    { integer rather than as a string.  Uses Printer variable.       }
  PPrinterValidator = ^TPrinterValidator;
  TPrinterValidator = OBJECT(TFilterValidator)
    CONSTRUCTOR Init;
    FUNCTION IsValid (CONST S : String) : Boolean; VIRTUAL;
    FUNCTION Transfer (VAR S : String; Buffer : Pointer;
                       Flag : TVTransfer) : Word; VIRTUAL;
  END;  { of TPrinterValidator }


  {$IFNDEF OnePrinter}
  PPrinterSelectDlg = ^TPrinterSelectDlg;
  TPrinterSelectDlg = OBJECT(TDialog)
    AvailablePrinters : PPrinterListBox;
    DefaultPrinter : PInputLine;
    CONSTRUCTOR Init;
    CONSTRUCTOR Load (VAR S : TStream);
    PROCEDURE HandleEvent (VAR Event : TEvent); VIRTUAL;
    PROCEDURE MakeDefault; VIRTUAL;
    PROCEDURE Store (VAR S : TStream); VIRTUAL;
  END;  { of TPrinterSelectDlg }

  PPrinterSelectRec = ^TPrinterSelectRec;
  TPrinterSelectRec = RECORD
    PrinterCollection : PCollection;
    Selection : Integer;
    DefaultPrinter : Integer;
  END;  { of TPrinterSelectRec }
{$ENDIF OnePrinter}


CONST
    { Stream Registration Constants }
    srTVPrinter             = 1;
    srTVPrinterCollection   = srTVPrinter + 1;
    srPrinterSetupDlg       = srTVPrinterCollection + 1;
    srEditorPrintDlg        = srPrinterSetupDlg + 1;
    srPrintJobListBox       = srEditorPrintDlg + 1;
    srPrintQueueDlg         = srPrintJobListBox + 1;
    srPrinterDriverListBox  = srPrintQueueDlg + 1;
    srPrinterValidator      = srPrinterDriverListBox + 1;

    srPrinterListBox        = srPrinterValidator + 1;
    srPrinterDriver         = srPrinterListBox + 1;
    srDriverCollection      = srPrinterDriver + 1;
    srPrintDlg              = srDriverCollection + 1;
    srPrintFileDlg          = srPrintDlg + 1;
    srInstallPrintersDlg    = srPrintFileDlg + 1;
    srPrinterSelectDlg      = srInstallPrintersDlg + 1;


  RTVPrinter : TStreamRec = (
    ObjType : srTVPrinter;
    VmtLink : Ofs(TypeOf(TTVPrinter)^);
    Load    : @TTVPrinter.Load;
    Store   : @TTVPrinter.Store);

  RTVPrinterCollection : TStreamRec = (
    ObjType : srTVPrinterCollection;
    VmtLink : Ofs(TypeOf(TTVPrinterCollection)^);
    Load    : @TTVPrinterCollection.Load;
    Store   : @TTVPrinterCollection.Store);

  RPrinterSetupDlg : TStreamRec = (
    ObjType : srPrinterSetupDlg;
    VmtLink : Ofs(TypeOf(TPrinterSetupDlg)^);
    Load    : @TPrinterSetupDlg.Load;
    Store   : @TPrinterSetupDlg.Store);

  RPrintDlg : TStreamRec = (
    ObjType : srPrintDlg;
    VmtLink : Ofs(TypeOf(TPrintDlg)^);
    Load    : @TPrintDlg.Load;
    Store   : @TPrintDlg.Store);

  REditorPrintDlg : TStreamRec = (
    ObjType : srEditorPrintDlg;
    VmtLink : Ofs(TypeOf(TEditorPrintDlg)^);
    Load    : @TEditorPrintDlg.Load;
    Store   : @TEditorPrintDlg.Store);

  RPrintFileDlg : TStreamRec = (
    ObjType : srPrintFileDlg;
    VmtLink : Ofs(TypeOf(TPrintFileDlg)^);
    Load    : @TPrintFileDlg.Load;
    Store   : @TPrintFileDlg.Store);

  RPrintJobListBox : TStreamRec = (
    ObjType : srPrintJobListBox;
    VmtLink : Ofs(TypeOf(TPrintJobListBox)^);
    Load    : @TPrintJobListBox.Load;
    Store   : @TPrintJobListBox.Store);

  RPrinterListBox : TStreamRec = (
    ObjType : srPrinterListBox;
    VmtLink : Ofs(TypeOf(TPrinterListBox)^);
    Load    : @TPrinterListBox.Load;
    Store   : @TPrinterListBox.Store);

  RPrintQueueDlg : TStreamRec = (
    ObjType : srPrintQueueDlg;
    VmtLink : Ofs(TypeOf(TPrintQueueDlg)^);
    Load    : @TPrintQueueDlg.Load;
    Store   : @TPrintQueueDlg.Store);

  RPrinterDriver : TStreamRec = (
    ObjType : srPrinterDriver;
    VmtLink : Ofs(TypeOf(TPrinterDriver)^);
    Load    : @TPrinterDriver.Load;
    Store   : @TPrinterDriver.Store);

  RDriverCollection : TStreamRec = (
    ObjType : srDriverCollection;
    VmtLink : Ofs(TypeOf(TDriverCollection)^);
    Load    : @TDriverCollection.Load;
    Store   : @TDriverCollection.Store);

  RPrinterDriverListBox : TStreamRec = (
    ObjType : srPrinterDriverListBox;
    VmtLink : Ofs(TypeOf(TPrinterDriverListBox)^);
    Load    : @TPrinterDriverListBox.Load;
    Store   : @TPrinterDriverListBox.Store);

  RInstallPrintersDlg : TStreamRec = (
    ObjType : srInstallPrintersDlg;
    VmtLink : Ofs(TypeOf(TInstallPrintersDlg)^);
    Load    : @TInstallPrintersDlg.Load;
    Store   : @TInstallPrintersDlg.Store);

  RPrinterValidator : TStreamRec = (
    ObjType : srPrinterValidator;
    VmtLink : Ofs(TypeOf(TPrinterValidator)^);
    Load    : @TPrinterValidator.Load;
    Store   : @TPrinterValidator.Store);

  RPrinterSelectDlg : TStreamRec = (
    ObjType : srPrinterSelectDlg;
    VmtLink : Ofs(TypeOf(TPrinterSelectDlg)^);
    Load    : @TPrinterSelectDlg.Load;
    Store   : @TPrinterSelectDlg.Store);



   { Global Procedures and Functions }
PROCEDURE DonePrinter;
PROCEDURE HandlePrintEvents (VAR Event : TEvent);
FUNCTION  InitPrinter (TempDirectory, PrinterDirectory : FNameStr;
                       PrinterName : FNameStr;
                       Background : Boolean) : Boolean;
PROCEDURE InstallPrinter;
FUNCTION  NewPrinter (AFile : FNameStr; Background : Boolean) : PTVPrinter;
PROCEDURE PrintEditor (AName : FNameStr; Editor : PEditor);
PROCEDURE PrintEditWindow (EditWindow : PEditWindow);
PROCEDURE PrintFile (Formatted : Boolean);
PROCEDURE PrintFileEditor (Editor : PFileEditor);
PROCEDURE PrintMemo (ATitle : FNameStr; Memo : PMemo);
PROCEDURE RegisterWvsPrint;
{$IFNDEF OnePrinter}
FUNCTION  SelectPrinter (VAR Index : Integer) : Boolean;
{$ENDIF OnePrinter}
PROCEDURE SetupPrinter (APrinter : PTVPrinter);
FUNCTION  StdPrinterMenuItems (Next : PMenuItem) : PMenuItem;

  { Resource File Procedures and Functions }
PROCEDURE MakeTVPrintResources (AResourceFile : PResourceFile);

   { Global Variables }
VAR
  {$IFDEF OnePrinter}
  Printer : PTVPrinter;
  {$ELSE}
  Printer : PPrinterCollection;
  {$ENDIF OnePrinter}
  DriverDirectory : FNameStr;

{****************************************************************************}
                              IMPLEMENTATION
{****************************************************************************}
USES
  HelpCtx, App, Strings, MsgBox,
  tlObject, tlPorts,
  PrnCodes, tvPrtDlg;
{****************************************************************************}
{                                                                            }
{                     Local Procedures and Functions                         }
{                                                                            }
{****************************************************************************}
PROCEDURE ManagePrintQueue;
VAR Dlg : PDialog;
    Data : TPrintQueueRec;
BEGIN
  {$IFDEF ResourceFile}
  Dlg := PPrintQueueDlg(ResourceFile^.Get(rePrintQueueDlg));
  {$ELSE}
  Dlg := New(PPrintQueueDlg,Init);
  {$ENDIF ResourceFile}
  {$IFDEF OnePrinter}
  Data.Queue.List := Printer;
  Data.Queue.Selection := 0;
  {$ELSE}
  Data.PrinterList.List := Printer;
  Data.PrinterList.Selection := Printer^.GetDefaultPrinter;
  Data.Queue.List := PTVPrinter(Printer^.At(Printer^.GetDefaultPrinter));
  Data.Queue.Selection := 0;
  {$ENDIF OnePrinter}
  Application^.ExecuteDialog(Dlg,@Data);
END;
{****************************************************************************}
FUNCTION NewPrinter (AFile : FNameStr; Background : Boolean) : PTVPrinter;
VAR Prn : PTVPrinter;
    R : TRect;
BEGIN
  Prn := New(PTVPrinter,Init('Untitled',AFile,
                             PPort(PortList^.At(PortList^.Default)),512,1,
                             Background));
  IF (Prn = NIL)
     THEN BEGIN
            R.Assign(10,6,70,18);
            MessageBoxRect(R,
                     ^C + 'Error loading printer driver.  Printer driver'#13+
                     #13 +
                     ^C + AFile + #13 +
                     #13 +
                     ^C + 'may be corrupted.',
                                NIL,mfError OR mfOkButton);
                    END
     ELSE Prn^.SetName(Prn^.GetBrand);
  NewPrinter := Prn;
END;
{****************************************************************************}
{                                                                            }
{          TDriverCollection Constructors, Destructor and Methods            }
{                                                                            }
{****************************************************************************}
FUNCTION TDriverCollection.Compare (Key1, Key2 : Pointer) : Integer;
BEGIN
  IF String(Key1^) < String(Key2^)
     THEN Compare := -1
     ELSE Compare := Ord(String(Key1^) > String(Key2^));
END;
{****************************************************************************}
FUNCTION TDriverCollection.KeyOf (Item : Pointer) : Pointer;
BEGIN
  KeyOf := PPrinterDriver(Item)^.Brand;
END;
{****************************************************************************}
{                                                                            }
{            TEditorPrintDlg Constructors, Destructor and Methods             }
{                                                                            }
{****************************************************************************}
{$IFDEF OnePrinter}
CONSTRUCTOR TEditorPrintDlg.Init;
VAR R : TRect;
    Control : PView;
BEGIN
  R.Assign(14, 7, 65, 15);
  TDialog.Init(R, 'Print Editor');
  Options := Options or ofCenterX or ofCenterY;
  HelpCtx := hcPrintEditorDlg;
    { Insert inputline to get number of copies to be printed }
  R.Assign(42, 3, 49, 4);
  Control := New(PInputLine, Init(R, 5));
  Control^.HelpCtx := hcPrintNumberOfCopies;
  Insert(Control);
  PInputLine(Control)^.SetValidator(New(PWordValidator,Init(1,255,
                                                            voTransfer)));
  R.Assign(23,3,40,4);
  Insert(New(PLabel, Init(R, '~N~umber of Copies', Control)));
    { Insert button to accept print settings }
  Insert(NewButton(4,5,10,2,'O~k~',cmOK,hcOk,bfDefault));
    { Insert button to cancel printing }
  Insert(NewButton(21,5,10,2,'Cancel',cmCancel,hcCancel,bfNormal));
    { Insert button to get help on print settings }
  Insert(NewButton(37,5,10,2,'~H~elp',cmHelp,hcNoContext,bfNormal));
    { Insert radiobuttons to select print range }
  R.Assign(2, 2, 22, 4);
  Control := New(PRadioButtons, Init(R,
    NewSItem('Full ~D~ocument',
    NewSItem('Se~l~ected Text',
    NIL))));
  Control^.HelpCtx := hcPrintRange;
  Insert(Control);
  R.Assign(1, 1, 7, 2);
  Insert(New(PLabel, Init(R, '~R~ange', Control)));
    { Insert radiobuttons to determine where to send printer output }
  R.Assign(24, 2, 49, 3);
  Control := New(PRadioButtons, Init(R,
    NewSItem('~P~rinter',
    NewSItem('~F~ile',
    NIL))));
  Control^.HelpCtx := hcPrinterOutPutDevice;
  Insert(Control);
    { set focus to Ok button on opening }
  SelectNext(False);
END;
{$ELSE}  { multiple printers }
CONSTRUCTOR TEditorPrintDlg.Init;
VAR R : TRect;
    Control : PView;
    Val : PValidator;
BEGIN
  R.Assign(10, 2, 67, 14);
  TPrintDlg.Init(R, 'Print');
  HelpCtx := hcPrint;
    { Insert inputline for number of copies to print - transfer as LongInt }
  R.Assign(47, 7, 54, 8);
  Control := New(PInputLine, Init(R, 5));
  Val := New(PWordValidator,Init(1,65535));
  Val^.Options := Val^.Options OR voTransfer;
  PInputLine(Control)^.SetValidator(Val);
  Insert(Control);
  R.Assign(28, 7, 45, 8);
  Insert(New(PLabel, Init(R, '~N~umber of Copies', Control)));
    { Insert button to accept print settings }
  Insert(NewButton(6,9,10,2,'O~k~',cmOK,hcOk,bfDefault+bfGrabFocus));
    { Insert button to cancel printing }
  Insert(NewButton(23,9,10,2,'Cancel',cmCancel,hcCancel,bfNormal));
    { Insert button to get help on printing }
  Insert(NewButton(40,9,10,2, '~H~elp', cmHelp,hcNoContext,bfNormal));
    { Insert radiobuttons for range of text to print }
  R.Assign(2, 6, 26, 8);
  Control := New(PRadioButtons, Init(R,
    NewSItem('Full ~D~ocument',
    NewSItem('Se~l~ected Text', Nil))));
  Insert(Control);
  R.Assign(1, 5, 7, 6);
  Insert(New(PLabel, Init(R, '~R~ange', Control)));
    { Insert radiobuttons to select output device }
  R.Assign(29, 6, 54, 7);
  Control := New(PRadioButtons, Init(R,
    NewSItem('~P~rinter',
    NewSItem('~F~ile',
    NIL))));
  Insert(Control);
    { Insert button to select a different printer for output }
  Insert(NewButton(44,3,10,2, '~S~elect',cmPrinterSelect,hcPrinterSelect,
                   bfNormal));
    { Display the default printer }
  R.Assign(11, 1, 43, 2);
  DefaultPrinter := New(PInputLine, Init(R, 30));
  DefaultPrinter^.Options := DefaultPrinter^.Options AND (NOT ofSelectable);
  Insert(DefaultPrinter);
  Val := New(PPrinterValidator,Init);
  Val^.Options := Val^.Options OR voTransfer;
  DefaultPrinter^.SetValidator(Val);
  R.Assign(2, 1, 9, 2);
  Control := New(PStaticText, Init(R, 'Default'));
  Insert(Control);
    { Display the selected printer }
  R.Assign(11, 3, 43, 4);
  SelectedPrinter := New(PInputLine, Init(R, 30));
  SelectedPrinter^.Options := SelectedPrinter^.Options AND
                              (NOT ofSelectable);
  Insert(SelectedPrinter);
  SelectedPrinter^.SetValidator(New(PPrinterValidator,Init));
  R.Assign(2, 3, 10, 4);
  Control := New(PStaticText, Init(R, 'Selected'));
  Insert(Control);
    { set focus to print range selection when dialog is opened }
  SelectNext(False);
END;
{****************************************************************************}
CONSTRUCTOR TEditorPrintDlg.Load (VAR S : TStream);
BEGIN
  IF NOT TPrintDlg.Load(S)
     THEN Fail;
  GetSubViewPtr(S,DefaultPrinter);
END;
{****************************************************************************}
{$IFNDEF OnePrinter}
PROCEDURE TEditorPrintDlg.GetPrinter;
VAR i : Integer;
BEGIN
  TPrintDlg.GetPrinter;
  i := Printer^.GetDefaultPrinter;
  DefaultPrinter^.SetData(i);
  DefaultPrinter^.DrawView;
END;
{$ENDIF OnePrinter}
{****************************************************************************}
PROCEDURE TEditorPrintDlg.Store (VAR S : TStream);
BEGIN
  TPrintDlg.Store(S);
  GetSubViewPtr(S,DefaultPrinter);
END;
{$ENDIF OnePrinter}
{****************************************************************************}
{                                                                            }
{             TEditorPrintOut Constructors, Destructor and Methods           }
{                                                                            }
{****************************************************************************}
CONSTRUCTOR TEditorPrintOut.Init (AnEditor : PEditor);
BEGIN
  IF NOT inherited Init
     THEN Fail;
  PrintRange := prFullDocument;
  Editor := AnEditor;
END;
{****************************************************************************}
PROCEDURE TEditorPrintOut.Print;
  { If text is selected then print the selected text else print the entire }
  { buffer.  To print selected text you must call SetPrintRange using      }
  { SelStart and SelEnd.                                                   }
BEGIN
  WITH Editor^ DO
    IF PrintRange = prSelectedText
       THEN Write(Buffer^[SelStart],SelEnd - SelStart)
       ELSE BEGIN
              Write(Buffer^,CurPtr);
              Write(Buffer^[CurPtr + GapLen], BufLen - CurPtr);
            END;
END;
{****************************************************************************}
PROCEDURE TEditorPrintOut.SetPrintRange (APrintRange : Word);
BEGIN
  PrintRange := APrintRange;
END;
{****************************************************************************}
{                                                                            }
{          TInstallPrintersDlg Constructors, Destructor and Methods          }
{                                                                            }
{****************************************************************************}
{$IFNDEF OnePrinter}
CONSTRUCTOR TInstallPrintersDlg.Init;
VAR R : TRect;
    Control : PView;
BEGIN
  R.Assign(16, 1, 64, 22);
  IF NOT inherited Init(R,'Install Printers')
     THEN Fail;
  Options := Options or ofCenterX or ofCenterY;
  HelpCtx := hcPrintersInstall;
    { Insert listbox to display currently installed printers }
  R.Assign(34, 2, 35, 7);
  Control := New(PScrollBar,Init(R));
  Insert(Control);
  R.Assign(2, 2, 34, 7);
  InstalledPrinters := New(PPrinterListBox,Init(R,1,PScrollbar(Control)));
  InstalledPrinters^.HelpCtx := hcPrintersInstall;
  Insert(InstalledPrinters);
  R.Assign(1, 1, 20, 2);
  Insert(New(PLabel, Init(R, '~I~nstalled Printers', InstalledPrinters)));
    { Insert listbox to display available printers from printer driver file }
  R.Assign(34, 9, 35, 19);
  Control := New(PScrollBar, Init(R));
  Insert(Control);
  R.Assign(2, 9, 34, 19);
  AvailablePrinters := New(PPrinterDriverListBox,Init(R,PScrollbar(Control),
                           '',New(PDriverCollection,Init(5,5))));
  AvailablePrinters^.HelpCtx := hcPrintersInstall;
  Insert(AvailablePrinters);
  R.Assign(1, 8, 20, 9);
  Insert(New(PLabel, Init(R, '~A~vailable Printers', AvailablePrinters)));
    { Insert button to install the selected available printer }
  Insert(NewButton(36,2,10,2,'~N~ew',cmNew,hcNew,bfNormal));
    { Insert button to uninstall the selected installed printer }
  Insert(NewButton(36,6,10,2,'~D~elete',cmDelete,hcPrintersInstall,bfNormal));
    { Insert button to accept current installation settings }
  Insert(NewButton(36,10,10,2,'O~k~',cmOk,hcOk,bfDefault));
    { Insert button to get help on installing a printer }
  Insert(NewButton(36,18,10,2,'~H~elp',cmHelp,hcNoContext,bfNormal));
    { Set focus to available printers when the dialog opens }
  SelectNext(False);
END;
{****************************************************************************}
CONSTRUCTOR TInstallPrintersDlg.Load (VAR S : TStream);
BEGIN
  IF NOT inherited Load(S)
     THEN Fail;
  GetSubViewPtr(S,InstalledPrinters);
  GetSubViewPtr(S,AvailablePrinters);
END;
{****************************************************************************}
PROCEDURE TInstallPrintersDlg.DeletePrinter;
VAR Item : PObject;
BEGIN
  IF (InstalledPrinters^.List <> NIL) AND
     (InstalledPrinters^.Range > 0) AND
     (MessageBox(^C + 'Delete ' +
             PTVPrinter(InstalledPrinters^.GetFocusedItem)^.GetBrand + '?',
             NIL,mfConfirmation OR mfYesButton OR mfNoButton) = cmYes)
     THEN InstalledPrinters^.FreeFocusedItem;
END;
{****************************************************************************}
PROCEDURE TInstallPrintersDlg.HandleEvent (VAR Event : TEvent);
BEGIN
  IF (Event.What = evCommand)
     THEN CASE Event.Command OF
            cmNew : BEGIN
                      InstallPrinter;
                      ClearEvent(Event);
                    END;
            cmDelete : BEGIN
                         DeletePrinter;
                         ClearEvent(Event);
                       END;
          END;
  TDialog.HandleEvent(Event);
END;
{****************************************************************************}
PROCEDURE TInstallPrintersDlg.InstallPrinter;
VAR Prn : PTVPrinter;
BEGIN
  Prn := NewPrinter(PPrinterDriver(AvailablePrinters^.GetFocusedItem)^.
                    FileName^,TRUE);
  IF (Prn <> NIL)
     THEN InstalledPrinters^.Insert(Prn);
END;
{****************************************************************************}
PROCEDURE TInstallPrintersDlg.Store (VAR S : TStream);
BEGIN
  TDialog.Store(S);
  PutSubViewPtr(S,InstalledPrinters);
  PutSubViewPtr(S,AvailablePrinters);
END;
{$ENDIF OnePrinter}
{****************************************************************************}
{                                                                            }
{               TPrintDlg Constructors, Destructor and Methods               }
{                                                                            }
{****************************************************************************}
{$IFNDEF OnePrinter}
CONSTRUCTOR TPrintDlg.Load (VAR S : TStream);
BEGIN
  IF NOT TDialog.Load(S)
     THEN Fail;
  GetSubViewPtr(S,SelectedPrinter);
END;
{****************************************************************************}
PROCEDURE TPrintDlg.GetPrinter;
VAR i : Integer;
BEGIN
  SelectedPrinter^.GetData(i);
  IF SelectPrinter(i)
     THEN SelectedPrinter^.SetData(i);
END;
{****************************************************************************}
PROCEDURE TPrintDlg.HandleEvent (VAR Event : TEvent);
BEGIN
  IF (Event.What = evCommand) AND (Event.Command = cmPrinterSelect)
     THEN BEGIN
            GetPrinter;
            ClearEvent(Event);
          END;
  TDialog.HandleEvent(Event);
END;
{****************************************************************************}
PROCEDURE TPrintDlg.Store (VAR S : TStream);
BEGIN
  TDialog.Store(S);
  PutSubViewPtr(S,SelectedPrinter);
END;
{$ENDIF OnePrinter}
{****************************************************************************}
{                                                                            }
{             TPrinterDriver Constructors, Destructor and Methods            }
{                                                                            }
{****************************************************************************}
CONSTRUCTOR TPrinterDriver.Init (AFile : FNameStr);
VAR Codes : PPrinterCodes;
BEGIN
  IF NOT TObject.Init
     THEN Fail;
  Codes := New(PPrinterCodes,Load(AFile));
  Brand := NewStr(Codes^.BasicCode(pbBrand));
  FileName := NewStr(AFile);
  DisposeObject(Codes);
  IF (Brand = NIL) OR (FileName = NIL)
     THEN BEGIN
            Done;
            Fail;
          END;
END;
{****************************************************************************}
CONSTRUCTOR TPrinterDriver.Load (VAR S : TStream);
BEGIN
  IF NOT TObject.Init
     THEN Fail;
  FileName := S.ReadStr;
  Brand := S.ReadStr;
END;
{****************************************************************************}
DESTRUCTOR TPrinterDriver.Done;
BEGIN
  DisposeStr(Brand);
  DisposeStr(FileName);
  TObject.Done;
END;
{****************************************************************************}
PROCEDURE TPrinterDriver.Store (VAR S : TStream);
BEGIN
  S.WriteStr(FileName);
  S.WriteStr(Brand);
END;
{****************************************************************************}
{                                                                            }
{          TPrinterDriverListBox Constructors, Destructor and Methods         }
{                                                                            }
{****************************************************************************}
{$IFNDEF OnePrinter}
CONSTRUCTOR TPrinterDriverListBox.Init (R : TRect; AVScrollBar : PScrollBar;
                                        ADirectory : FNameStr;
                                        AList : PDriverCollection);
BEGIN
  IF NOT TSortedListBox.Init(R,1,AVScrollBar)
     THEN Fail;
  LoadData(ADirectory);
END;
{****************************************************************************}
DESTRUCTOR TPrinterDriverListBox.Done;
BEGIN
  DisposeObject(PObject(List));
  TSortedListBox.Done;
END;
{****************************************************************************}
FUNCTION TPrinterDriverListBox.GetText (Item : Integer;
                                       MaxLen : Integer) : String;
VAR Data : PPrinterDriver;
BEGIN
  IF (List = NIL) OR (List^.Count = 0)
     THEN GetText := ''
     ELSE BEGIN
            Data := PPrinterDriver(List^.At(Item));
            IF Data = NIL
               THEN GetText := ''
               ELSE GetText := Data^.Brand^;
          END;
END;
{****************************************************************************}
PROCEDURE TPrinterDriverListBox.LoadData (ADirectory : FNameStr);
VAR S : SearchRec;
    Driver : PPrinterDriver;
BEGIN
  FreeAll;
  ADirectory := FExpand(ADirectory);
  IF (ADirectory[Length(ADirectory)] <> '\')
     THEN ADirectory := ADirectory + '\';
  FindFirst(ADirectory + DriverMask,AnyFile,S);
  WHILE (DosError = 0) DO
    BEGIN
      Driver := New(PPrinterDriver,Init(ADirectory + S.Name));
      IF Driver <> NIL
         THEN Insert(Driver);
      FindNext(S);
    END;
  DrawView;
END;
{$ENDIF OnePrinter}
{****************************************************************************}
{                                                                            }
{             TPrintFileDlg Constructors, Destructor and Methods             }
{                                                                            }
{****************************************************************************}
{$IFNDEF OnePrinter}
CONSTRUCTOR TPrintFileDlg.Init (AFile : FNameStr);
VAR R : TRect;
    Control : PView;
BEGIN
  R.Assign(0,0,56,8);
  TDialog.Init(R,'Print File');
  Options := Options OR ofCentered;
  HelpCtx := hcPrintFile;
    { insert static text to display the file to print }
  R.Assign(2, 2, 2 + SizeOf(TPrinterNameStr), 3);
  Control := New(PStaticText,Init(R,'File: ' + FormatFile(AFile)));
  Insert(Control);
    { insert inputline to select the printer to use for formatting output }
  R.Assign(10, 3, 42, 4);
  SelectedPrinter := New(PInputLine, Init(R, 30));
  SelectedPrinter^.HelpCtx := hcPrinterSelect;
  Insert(SelectedPrinter);
  SelectedPrinter^.SetValidator(New(PPrinterValidator,Init));
  R.Assign(1, 3, 9, 4);
  Insert(New(PLabel,Init(R,'~P~rinter',SelectedPrinter)));
    { insert button to accept printer }
  Insert(NewButton(6,5,10,2,'O~k~',cmOK,hcOk,bfDefault));
    { insert button to cancel printing }
  Insert(NewButton(23,5,10,2,'Cancel',cmCancel,hcCancel,bfNormal));
    { insert button to get help on printing to a file }
  Insert(NewButton(40,5,10,2,'~H~elp',cmHelp,hcNoContext,bfNormal));
    { insert button to select another printer }
  Insert(NewButton(43,3,10,2,'~S~elect',cmPrinterSelect,hcPrinterSelect,
         bfNormal));
    { set focus to printer inputline when the dialog opens }
  SelectNext(False);
END;
{****************************************************************************}
FUNCTION TPrintFileDlg.FormatFile (AFile : FNameStr) : TPrinterNameStr;
VAR i : Byte;
BEGIN
  IF Length(AFile) > SizeOf(TPrinterNameStr)
     THEN BEGIN
            i := Length(FExpand(AFile));
            WHILE AFile[i] <> '\' DO Dec(i);
            AFile := Copy(AFile,1,2) + '..' + Copy(AFile,i,Length(AFile)+1);
          END;
  FormatFile := AFile;
END;
{$ENDIF OnePrinter}
{****************************************************************************}
{                                                                            }
{          TPrintJobListBox Constructors, Destructor and Methods             }
{                                                                            }
{****************************************************************************}
FUNCTION TPrintJobListBox.GetText (Item : Integer; MaxLen : Integer) : String;
VAR Data : PString;
BEGIN
  IF (List = NIL) OR (List^.Count = 0)
     THEN GetText := ''
     ELSE BEGIN
            Data := PPrintJob(List^.At(Item))^.Title;
            IF Data = NIL
               THEN GetText := 'Untitled'
               ELSE GetText := Data^;
          END;
END;
{****************************************************************************}
{                                                                            }
{            TPrintQueueDlg Constructors, Destructor and Methods             }
{                                                                            }
{****************************************************************************}
{$IFDEF OnePrinter}
CONSTRUCTOR TPrintQueueDlg.Init;
VAR R : TRect;
    P : PView;
    VScrollBar : PScrollBar;
BEGIN
  R.Assign(13,2,60,15);
  inherited Init(R, 'Print Queue');
  Options := Options or (ofCenterX + ofCenterY);
  HelpCtx := hcPrintQueue;
    { Insert listbox to display current printjobs }
  R.Assign(34,2, 35,12);
  VScrollBar := New(PScrollBar, Init(R));
  Insert(VScrollBar);
  R.Assign(2,2, 34,12);
  PrintJobs := New(PPrintJobListBox,Init(R,1,NIL,VScrollBar,Printer));
  Insert(PrintJobs);
  R.Assign(1,1,13,2);
  Insert(New(PLabel,Init(R,'Print ~J~obs',PrintJobs)));
    { insert button to delete the current printjob }
  Insert(NewButton(35,2,10,2,'~D~elete',cmDelete,hcDelete,bfNormal));
    { insert button to close the dialog }
  Insert(NewButton(35,4,10,2,'O~K~',cmOK,hcOk,bfDefault));
    { insert button to get help on managing the print queue }
  Insert(NewButton(35,6,10,2,'~H~elp',cmHelp,hcNoContext,bfNormal));
    { insert button to pause all printing on this printer }
  Insert(NewButton(35,8,10,2,'~P~ause',cmPrinterPause,hcPrinterPause,
                   bfNormal));
    { insert button to resume printing on this printer }
  Insert(NewButton(35,10,10,2,'~R~esume',cmPrinterResume,hcPrinterResume,
                   bfNormal));
    { set focus to the printjob list box when the dialog opens }
  SelectNext(FALSE);
END;
{$ELSE}
CONSTRUCTOR TPrintQueueDlg.Init;
VAR R : TRect;
    P : PView;
    HScrollBar, VScrollBar : PScrollBar;
BEGIN
  R.Assign(13,2, 66,21);
  inherited Init(R,'Print Queue');
  Options := Options or (ofCenterX + ofCenterY);
  HelpCtx := hcPrintQueue;
    { Insert listbox to display printers }
  R.Assign(34,2, 35,7);
  VScrollBar := New(PScrollBar, Init(R));
  Insert(VScrollBar);
  R.Assign(2,2, 34,7);
  PrinterList := New(PPrinterListBox,Init(R,1,VScrollBar));
  Insert(PrinterList);
  R.Assign(1,1, 12,2);
  Insert(New(PLabel,Init(R,'~P~rinters',PrinterList)));
    { Insert listbox of print jobs for the current printer }
  R.Assign(34,9, 35,18);
  VScrollBar := New(PScrollBar,Init(R));
  Insert(VScrollBar);
  R.Assign(2,9, 34,18);
  PrintJobs := New(PPrintJobListBox,Init(R,1,VScrollBar));
  Insert(PrintJobs);
  R.Assign(1,8, 12,9);
  Insert(New(PLabel,Init(R,'Print ~J~obs',PrintJobs)));
    { Insert buttons to control printing }
  R.Assign(35,1, 51,3);
  P := New(PButton, Init(R, '~D~elete', cmDelete, bfNormal));
  P^.HelpCtx := hcDelete;
  Insert(P);
  R.Assign(35,3, 51,5);
  P := New(PButton, Init(R, 'O~K~', cmOK, bfDefault));
  P^.HelpCtx := hcOK;
  Insert(P);
  R.Assign(35,5, 51,7);
  P := New(PButton, Init(R, 'Cancel', cmCancel, bfNormal));
  P^.HelpCtx := hcCancel;
  Insert(P);
  R.Assign(35,7, 51,9);
  P := New(PButton, Init(R, '~H~elp', cmHelp, bfNormal + bfGrabFocus));
  P^.HelpCtx := hcNoContext;
  Insert(P);
  R.Assign(35,10, 51,12);
  P := New(PButton, Init(R, '~P~ause', cmPrinterPause, bfNormal));
  P^.HelpCtx := hcPrinterPause;
  Insert(P);
  R.Assign(35,12, 51,14);
  P := New(PButton, Init(R, '~R~esume', cmPrinterResume, bfNormal));
  P^.HelpCtx := hcPrinterResume;
  Insert(P);
  R.Assign(35,14, 51,16);
  P := New(PButton, Init(R, 'Pause ~A~ll', cmPrinterPauseAll, bfNormal));
  P^.HelpCtx := hcPrinterPauseAll;
  Insert(P);
  R.Assign(35,16, 51,18);
  P := New(PButton, Init(R, '~R~esume All', cmPrinterResumeAll, bfNormal));
  P^.HelpCtx := hcPrinterResumeAll;
  Insert(P);
  SelectNext(FALSE);
END;
{$ENDIF OnePrinter}
{****************************************************************************}
CONSTRUCTOR TPrintQueueDlg.Load (VAR S : TStream);
BEGIN
  inherited Load(S);
  GetSubViewPtr(S,PrintJobs);
  {$IFNDEF OnePrinter}
  GetSubViewPtr(S,PrinterList);
  {$ENDIF OnePrinter}
END;
{****************************************************************************}
PROCEDURE TPrintQueueDlg.HandleEvent (VAR Event : TEvent);
BEGIN
  IF (Event.What = evCommand)
     THEN CASE Event.Command OF
            cmDelete : BEGIN
                         PrintJobs^.FreeFocusedItem;
                         ClearEvent(Event);
                       END;
            cmPrinterPause : BEGIN
                               {$IFDEF OnePrinter}
                               Printer^.SetPauseState(On);
                               {$ELSE}
                               PTVPrinter(Printer^.At(
                                  PrinterList^.Focused))^.SetPauseState(On);
                               {$ENDIF OnePrinter}
                               ClearEvent(Event);
                             END;
            cmPrinterResume : BEGIN
                                {$IFDEF OnePrinter}
                                Printer^.SetPauseState(Off);
                                {$ELSE}
                                PTVPrinter(Printer^.At(
                                   PrinterList^.Focused))^.SetPauseState(Off);
                                {$ENDIF OnePrinter}
                                ClearEvent(Event);
                              END;
            {$IFNDEF OnePrinter}
            cmPrinterPauseAll : BEGIN
                                  Printer^.PauseAll;
                                  ClearEvent(Event);
                                END;
            cmPrinterResumeAll : BEGIN
                                   Printer^.ResumeAll;
                                   ClearEvent(Event);
                                 END;
            {$ENDIF OnePrinter}
          END;
  inherited HandleEvent(Event);
  IF (PrintJobs^.Range <> PrintJobs^.List^.Count)
     THEN BEGIN
            PrintJobs^.SetRange(PrintJobs^.List^.Count);
            PrintJobs^.DrawView;
          END;
END;
{****************************************************************************}
PROCEDURE TPrintQueueDlg.Store (VAR S : TStream);
BEGIN
  inherited Store(S);
  PutSubViewPtr(S,PrintJobs);
  {$IFNDEF OnePrinter}
  PutSubViewPtr(S,PrinterList);
  {$ENDIF OnePrinter}
END;
{****************************************************************************}
{                                                                            }
{           TPrinterListBox Constructors, Destructor and Methods             }
{                                                                            }
{****************************************************************************}
FUNCTION TPrinterListBox.GetText (Item : Integer; MaxLen : Integer) : String;
VAR S : PTVPrinter;
BEGIN
  IF (List = NIL) OR (List^.Count = 0)
     THEN GetText := ''
     ELSE BEGIN
            S := PTVPrinter(List^.At(Item));
            IF S = NIL
               THEN GetText := 'UnNamed'
               ELSE GetText := S^.Name^;
          END;
END;
{****************************************************************************}
{                                                                            }
{         TPrinterSelectDlg Constructors, Destructor and Methods             }
{                                                                            }
{****************************************************************************}
{$IFNDEF OnePrinter}
CONSTRUCTOR TPrinterSelectDlg.Init;
VAR R : TRect;
    Control : PView;
BEGIN
  R.Assign(15, 1, 64, 21);
  inherited Init(R, 'Select Printer');
  Options := Options or ofCenterX or ofCenterY;
  HelpCtx := hcPrinterSelect;
    { insert listbox to display current printers }
  R.Assign(32, 5, 33, 15);
  Control := New(PScrollBar, Init(R));
  Insert(Control);
  R.Assign(2,5,32,15);
  AvailablePrinters := New(PPrinterListBox,Init(R,1,PScrollbar(Control)));
  Insert(AvailablePrinters);
  R.Assign(1, 4, 20, 5);
  Insert(New(PLabel, Init(R, '~A~vailable Printers', AvailablePrinters)));
    { insert button to accept current settings }
  Insert(NewButton(34,2,12,2,'O~k~',cmOK,hcOk,bfDefault));
    { insert button to cancel current settings }
  Insert(NewButton(34,5,12,2,'Cancel',cmCancel,hcCancel,bfNormal));
    { insert button to get help on selecting a printer }
  Insert(NewButton(34,8,12,2,'~H~elp',cmHelp,hcNoContext,bfNormal));
    { insert button to install a new printer }
  Insert(NewButton(34,11,12,2,'~N~ew',cmNew,hcPrinterInstall,bfNormal));
    { insert button to change the setup of the focused available printer }
  Insert(NewButton(34,14,12,2,'~S~etup...',cmPrinterSetup,hcPrinterSetup,
                   bfNormal));
    { insert button to delete the focused available printer }
  Insert(NewButton(34,17,12,2,'~D~elete',cmDelete,hcDelete,bfNormal));
   { insert button to make the focused available printer the default printer }
  Insert(NewButton(8,16,18,2,'~M~ake Default',cmPrinterMakeDefault,
                   hcPrinterMakeDefault,bfNormal));
    { insert inputline to display the default printer }
  R.Assign(2,2,32,3);
  DefaultPrinter := New(PInputLine,Init(R,30));
  DefaultPrinter^.Options := DefaultPrinter^.Options and not ofSelectable;
  DefaultPrinter^.SetValidator(New(PPrinterValidator,Init));
  DefaultPrinter^.Validator^.Options :=
                  DefaultPrinter^.Validator^.Options OR voTransfer;
  Insert(DefaultPrinter);
  R.Assign(2, 1, 9, 2);
  Insert(New(PStaticText, Init(R, 'Default')));
    { set focus to AvailablePrinters when the dialog opens }
  SelectNext(False);
END;
{****************************************************************************}
CONSTRUCTOR TPrinterSelectDlg.Load (VAR S : TStream);
BEGIN
  inherited Load(S);
  GetSubViewPtr(S,AvailablePrinters);
  GetSubViewPtr(S,DefaultPrinter);
END;
{****************************************************************************}
PROCEDURE TPrinterSelectDlg.HandleEvent (VAR Event : TEvent);
VAR i : Integer;
    Prn : PTVPrinter;
BEGIN
  IF (Event.What = evCommand)
     THEN CASE Event.Command OF
            cmPrinterMakeDefault : BEGIN
                                     MakeDefault;
                                     ClearEvent(Event);
                                   END;
            cmNew : BEGIN
                      InstallPrinter;
                      AvailablePrinters^.SetRange(Printer^.Count);
                      AvailablePrinters^.Focused :=
                                         Printer^.GetDefaultPrinter;
                      AvailablePrinters^.DrawView;
                      i := Printer^.GetDefaultPrinter;
                      DefaultPrinter^.SetData(i);
                      ClearEvent(Event);
                    END;
            cmPrinterSetup : BEGIN
                               Prn := PTVPrinter(Printer^.At(
                                            AvailablePrinters^.Focused));
                               Printer^.AtDelete(AvailablePrinters^.Focused);
                               SetupPrinter(Prn);
                               Printer^.Insert(Prn);
                               AvailablePrinters^.DrawView;
                               i := Printer^.GetDefaultPrinter;
                               DefaultPrinter^.SetData(i);
                               ClearEvent(Event);
                             END;
            cmDelete : BEGIN
                         AvailablePrinters^.FreeFocusedItem;
                         i := Printer^.GetDefaultPrinter;
                         DefaultPrinter^.SetData(i);
                         ClearEvent(Event);
                       END;
          END;
  inherited HandleEvent(Event);
END;
{****************************************************************************}
PROCEDURE TPrinterSelectDlg.MakeDefault;
BEGIN
  IF (Printer <> NIL)
     THEN BEGIN
            Printer^.SetDefaultPrinter(AvailablePrinters^.Focused);
            DefaultPrinter^.SetData(AvailablePrinters^.Focused);
          END;
END;
{****************************************************************************}
PROCEDURE TPrinterSelectDlg.Store (VAR S : TStream);
BEGIN
  inherited Store(S);
  PutSubViewPtr(S,AvailablePrinters);
  PutSubViewPtr(S,DefaultPrinter);
END;
{$ENDIF OnePrinter}
{****************************************************************************}
{                                                                            }
{          TPrinterSetupDlg Constructors, Destructor and Methods             }
{                                                                            }
{****************************************************************************}
CONSTRUCTOR TPrinterSetupDlg.Init;
VAR R : TRect;
    Control : PView;
BEGIN
  R.Assign(33, 5, 77, 17);
  inherited Init(R, 'Printer Setup');
  Options := Options or ofCenterY;
  HelpCtx := hcPrinterSetup;
    { Insert inputline to get user defined printer name }
  R.Assign(8, 1, 40, 2);
  Control := New(PInputLine, Init(R,30));
  Control^.HelpCtx := hcPrinterName;
  Insert(Control);
  R.Assign(1, 1, 6, 2);
  Insert(New(PLabel, Init(R, '~N~ame',Control)));
    { Insert input line to get printer brand }
  R.Assign(2, 3, 7, 4);
  Control := New(PStaticText,Init(R,'Brand: '));
  Insert(Control);
  R.Assign(8,3,40,4);
  Control := New(PInputLine,Init(R,30));
  Insert(Control);
    { Insert inputline to get buffer size }
  R.Assign(14, 5, 21, 6);
  Control := New(PInputLine, Init(R, 5));
  Control^.HelpCtx := hcPrinterBufferSize;
  Control^.Options := Control^.Options OR ofValidate;
  Insert(Control);
  PInputLine(Control)^.Validator := New(PWordValidator,Init(
                                        1,65535));
  R.Assign(1, 5, 13, 6);
  Insert(New(PLabel, Init(R, 'Buffer ~S~ize',Control)));
    { Insert inputline to get timeout }
  R.Assign(14, 7, 21, 8);
  Control := New(PInputLine, Init(R, 5));
  Control^.HelpCtx := hcPrinterTimeOut;
  Control^.Options := Control^.Options OR ofValidate;
  Insert(Control);
  PInputLine(Control)^.SetValidator(New(PWordValidator,Init(
                                        0,65535)));
  R.Assign(1, 7, 10, 8);
  Insert(New(PLabel, Init(R, '~T~ime Out',Control)));
    { Get background printing status }
  R.Assign(24,5,40,6);
  Insert(New(PCheckBoxes,Init(R,NewSItem('Back~g~round',NIL))));
    { Insert inputline to get output port with picklist }
  R.Assign(31, 7, 37, 8);
  Control := New(PInputLine, Init(R, 4));
  Control^.HelpCtx := hcPrinterPort;
  Insert(Control);
  PInputLine(Control)^.SetValidator(New(PPortValidator,Init));
  PInputLine(Control)^.Options := PInputLine(Control)^.Options OR ofValidate;
  R.Assign(37, 7, 40, 8);
  Insert(New(PPortComboBox,Init(PInputline(Control),NIL)));
  R.Assign(23, 7, 28, 8);
  Insert(New(PLabel, Init(R, '~P~ort', Control)));
  {$IFDEF OnePrinter}
    { Insert button to accept printer settings }
  Insert(NewButton(2,9,10,2,'O~k~',cmOK,hcOk,bfDefault));
    { Insert button to cancel changes }
  Insert(NewButton(13,9,10,2,'Cancel',cmCancel,hcCancel,bfNormal));
    { Insert button to get help on printer settings }
  Insert(NewButton(24,9,10,2,'~H~elp',cmHelp,hcPrinterSetup,bfNormal));
    { Insert button to change printers }
  Insert(NewButton(35,9,7,2,'~N~ew',cmNew,hcPrinterInstall,bfNormal));
  {$ELSE}
    { Insert button to accept printer settings }
  Insert(NewButton(3,9,10,2,'O~k~',cmOK,hcOk,bfDefault));
    { Insert button to cancel changes }
  Insert(NewButton(17,9,10,2,'Cancel',cmCancel,hcCancel,bfNormal));
    { Insert button to get help on printer settings }
  Insert(NewButton(31,9,10,2,'~H~elp',cmHelp,hcPrinterSetup,bfNormal));
  {$ENDIF OnePrinter}
    { set focus to printer name when dialog opens }
  SelectNext(False);
END;
{****************************************************************************}
PROCEDURE TPrinterSetupDlg.HandleEvent (VAR Event : TEvent);
{$IFDEF OnePrinter}
VAR Data : TPrinterSetupRec;
{$ENDIF OnePrinter}
BEGIN
  IF (Event.What = evCommand) AND (Event.Command = cmNew)
     THEN {$IFDEF OnePrinter}
          BEGIN
            InstallPrinter;
            Data.Name := Printer^.Name^;
            Data.Brand := Printer^.GetBrand;
            Data.BufferSize := Printer^.BufferSize;
            Data.TimeOut := Printer^.TimeOut;
            Data.Background := Ord(Printer^.BackgroundPrinting);
            Data.PrinterPort := PortList^.Default;
            Data.PortList := PortList;
            SetData(Data);
            ClearEvent(Event);
          END;
          {$ELSE}
          BEGIN
            InstallPrinter;
            ClearEvent(Event);
          END;
          {$ENDIF OnePrinter}
  inherited HandleEvent(Event);
END;
{****************************************************************************}
{                                                                            }
{             TPrinterValidator Constructors, Destructor, and Methods           }
{                                                                            }
{****************************************************************************}
CONSTRUCTOR TPrinterValidator.Init;
BEGIN
  inherited Init([#0..#255]);  { any character }
  Options := Options OR voTransfer;
END;
{****************************************************************************}
FUNCTION TPrinterValidator.IsValid (CONST S : String) : Boolean;
BEGIN
  IsValid := TRUE;
END;
{****************************************************************************}
FUNCTION TPrinterValidator.Transfer (VAR S : String; Buffer : Pointer;
                                     Flag : TVTransfer) : Word;
VAR i : Integer;
    Found : Boolean;
    PS : PString;
BEGIN
  IF (Options AND voTransfer) = voTransfer
     THEN BEGIN
            CASE Flag OF
              vtDataSize : Transfer := SizeOf(Integer);
              vtGetData : {$IFDEF OnePrinter}
                          Buffer := @S;
                          {$ELSE}
                          BEGIN
                            IF Printer^.Search(@S,i)
                               THEN Integer(Buffer^) := i
                               ELSE Integer(Buffer^) :=
                                            Printer^.GetDefaultPrinter;
                          END;
                          {$ENDIF OnePrinter}
              vtSetData : {$IFDEF OnePrinter}
                          IF Buffer <> NIL
                             THEN S := PPrinter(Buffer)^.GetBrand
                             ELSE S := '';
                          {$ELSE}
                          IF Printer^.Count = 0
                             THEN S := ''
                             ELSE BEGIN
                                    i := Integer(Buffer^);
                                    IF (i < 0) OR (i >= Printer^.Count)
                                       THEN PS := NIL
                                       ELSE PS := PPrinter(Printer^.At(i))^.
                                                           Name;
                                    IF PS = NIL
                                       THEN S := ''
                                       ELSE S := PS^;
                                  END;
                          {$ENDIF OnePrinter}
            END;
          END
     ELSE Transfer := 0;
END;
{****************************************************************************}
{                                                                            }
{               TTVPrinter Constructors, Destructor, and Methods             }
{                                                                            }
{****************************************************************************}
FUNCTION TTVPrinter.ClearPrintQueue : Boolean;
BEGIN
  ClearPrintQueue := (MessageBox(^C + 'The print queue must be empty.'#13 +
                                 ^C + 'Abort the remaining print jobs?',NIL,
                      mfConfirmation OR mfOkButton OR mfCancelButton) = cmOk);
END;
{****************************************************************************}
FUNCTION TTVPrinter.LoadPort (VAR S : TStream) : Boolean;
VAR i : Integer;
BEGIN
  S.Read(i,SizeOf(i));
  IF PortList <> NIL
     THEN BEGIN
            Stream := PortList^.At(i);
            LoadPort := ((Stream <> NIL) AND (S.Status = stOk));
          END
     ELSE LoadPort := FALSE;
END;
{****************************************************************************}
PROCEDURE TTVPrinter.PrintingCanceledMessage;
BEGIN
  MessageBox(^C + 'Printing has been canceled.',NIL,
             mfOkButton OR mfInformation);
END;
{****************************************************************************}
PROCEDURE TTVPrinter.SendUserMessage (PercentCompleted : Word);
BEGIN
END;
{****************************************************************************}
PROCEDURE TTVPrinter.StorePort (VAR S : TStream);
VAR i : Integer;
BEGIN
  IF PortList <> NIL
     THEN BEGIN
            i := PortList^.IndexOf(Stream);
            IF i = -1
               THEN S.Status := stPutError
               ELSE S.Write(i,SizeOf(i));
          END
     ELSE S.Status := stPutError;
END;
{****************************************************************************}
FUNCTION TTVPrinter.UserByPassedPause : Boolean;
BEGIN
END;
{****************************************************************************}
FUNCTION TTVPrinter.UserCanceledPrintJob : Boolean;
BEGIN
  UserCanceledPrintJob :=
      (MessageBox(^C + 'Cancel print job?',NIL,
                  mfYesButton OR mfNoButton OR mfConfirmation) = cmYes);
END;
{****************************************************************************}
PROCEDURE TTVPrinter.Error (Code, Info : Integer);
VAR S : String;
BEGIN
  CASE Code OF
    peStreamInit   : S := 'Error initializing temporary output stream.';
    peStreamWrite  : S := 'Error writing to printer.';
    pePrintJobInit : S := 'Insufficient memory to print.';
    peFileInit     : S := 'Error intializing file to open for printing.';
    ELSE             S := 'Unknown printer error.';
  END;
  MessageBox(^C + S,NIL,mfError OR mfOkButton);
END;
{****************************************************************************}
{                                                                            }
{         TTVPrinterCollection Constructors, Destructor, and Methods         }
{                                                                            }
{****************************************************************************}
PROCEDURE TTVPrinterCollection.NoPrinterInstalled;
  { Override this to display a user message that a printer must be }
  { installed in order to performing a printing task.              }
BEGIN
  WriteLn('A Printer must be installed before you can print anything.');
  WriteLn('Press any key to continue.');
  ReadLn;
END;
{****************************************************************************}
{                                                                            }
{                    Global Procedures and Functions                         }
{                                                                            }
{****************************************************************************}
PROCEDURE DonePrinter;
BEGIN
  DisposeObject(PObject(Printer))
END;
{****************************************************************************}
PROCEDURE HandlePrintEvents (VAR Event : TEvent);
{$IFNDEF OnePrinter}
VAR i : Integer;
{$ENDIF OnePrinter}
BEGIN
  IF (Printer <> NIL) AND (Event.What = evCommand)
     THEN CASE Event.Command OF
            cmPrint : BEGIN
                        IF TypeOf(Desktop^.Current^) = TypeOf(TEditWindow)
                           THEN PrintEditWindow(PEditWindow(
                                  Desktop^.Current));
                        Application^.ClearEvent(Event);
                      END;
            cmPrinterSelect : BEGIN
                               {$IFDEF OnePrinter}
                               SetupPrinter(Printer);
                               {$ELSE}
                               i := 0;
                               SelectPrinter(i);
                               {$ENDIF OnePrinter}
                               Application^.ClearEvent(Event);
                             END;
            cmPrintQueue   : BEGIN
                               ManagePrintQueue;
                               Application^.ClearEvent(Event);
                             END;
            cmPrintFile    : BEGIN
                               PrintFile(FALSE);
                               Application^.ClearEvent(Event);
                             END;
            cmPrintFormatedFile : BEGIN
                                    PrintFile(TRUE);
                                    Application^.ClearEvent(Event);
                                  END;
          END;
END;
{****************************************************************************}
FUNCTION InitPrinter (TempDirectory, PrinterDirectory : FNameStr;
                      PrinterName : FNameStr;
                      Background : Boolean) : Boolean;
VAR LPT1 : String[4];
    Index : Integer;
    {$IFNDEF OnePrinter}
    ASCIIPrinter : PTVPrinter;
    {$ENDIF OnePrinter}
BEGIN
  InitPrinters(TempDirectory);
  InitPrinter := FALSE;
  PortList^.Search(@LPT1,Index);
  PortList^.SetDefault(Index);
  DriverDirectory := FExpand(PrinterDirectory);
  IF (DriverDirectory[Length(DriverDirectory)] <> '\')
     THEN DriverDirectory := DriverDirectory + '\';
  {$IFDEF OnePrinter}
  Printer := NewPrinter(DriverDirectory + PrinterName,Background);
  {$ELSE}
  Printer := New(PTVPrinterCollection,Init);
  IF (Printer <> NIL)
     THEN BEGIN
            ASCIIPrinter := NewPrinter(DriverDirectory + 'ASCII.DRV',
                                       Background);
            IF (ASCIIPrinter = NIL)
               THEN DisposeObject(PObject(Printer))
               ELSE Printer^.Insert(ASCIIPrinter);
          END;
  {$ENDIF OnePrinter}
  InitPrinter := (Printer <> NIL);
END;
{****************************************************************************}
PROCEDURE InstallPrinter;
VAR {$IFDEF OnePrinter}
    APrinter : PTVPrinter;
    AFile : FNameStr;
    {$ELSE}
    {Dlg : PInstallPrintersDlg;}
    Dlg : PInstallPrintersDlg;
    {$ENDIF OnePrinter}
BEGIN
  {$IFDEF OnePrinter}
  AFile := DriverDirectory + DriverMask;
  IF SelectFile(AFile,AnyFile) AND
     Printer^.SetBackgroundPrinting(Off)
     THEN BEGIN
            APrinter := NewPrinter(AFile,On);
            IF (APrinter <> NIL)
               THEN BEGIN
                      Dispose(Printer,Done);
                      Printer := APrinter;
                    END;
          END;
  {$ELSE}
  {$IFDEF ResourceFile}
  Dlg := PInstallPrintersDlg(ResourceFile^.Get(reInstallPrintersDlg));
  {$ELSE}
  Dlg := New(PInstallPrintersDlg,Init);
  {$ENDIF ResourceFile}
  Application^.ExecuteDialog(Dlg,NIL);
  {$ENDIF OnePrinter}
END;
{****************************************************************************}
PROCEDURE MakeTVPrintResources (AResourceFile : PResourceFile);
BEGIN
  {$IFDEF OnePrinter}
  {$ELSE}
  {$ENDIF OnePrinter}
END;
{****************************************************************************}
PROCEDURE PrintEditor (AName : FNameStr; Editor : PEditor);
VAR Dlg : PDialog;
    Data : TEditorPrintRec;
    PrintOut : PEditorPrintOut;
    Stream : PBufStream;
    StopPrinting : Word;
    AFile : FNameStr;
BEGIN
  IF (Printer = NIL)
     THEN Exit;
  {$IFDEF ResourceFile}
  Dlg := PEditorPrintDlg(ResourceFile^.Get(reEditorPrintDlg));
  {$ELSE}
  Dlg := New(PEditorPrintDlg,Init);
  {$ENDIF ResourceFile}
  WITH Data DO
    BEGIN
      IF Editor^.SelStart = Editor^.SelEnd
         THEN Range := prFullDocument
         ELSE Range := prSelectedText;
      Copies := 1;
      OutPutDevice := odPrinter;
      {$IFNDEF OnePrinter}
      DefaultPrinter := Printer^.GetDefaultPrinter;
      SelectedPrinter := Printer^.GetDefaultPrinter;
      {$ENDIF OnePrinter}
    END;
  IF Application^.ExecuteDialog(Dlg,@Data) = cmOk
     THEN BEGIN
            PrintOut := New(PEditorPrintOut,Init(Editor));
            IF PrintOut = NIL
               THEN Application^.OutOfMemory
               ELSE BEGIN
                      PrintOut^.SetPrintRange(Data.Range);
                      PrintOut^.NumberOfCopies := Data.Copies;
                      IF Data.OutPutDevice = odPrinter
                         THEN {$IFDEF OnePrinter}
                              Printer^.Print(AName,PrintOut)
                              {$ELSE}
                              Printer^.Print(Data.SelectedPrinter,AName,
                                             PrintOut)
                              {$ENDIF OnePrinter}
                         ELSE BEGIN
                                AFile := PrinterFileMask;
                                IF SaveAs(AFile,AnyFile)
                                   THEN {$IFDEF OnePrinter}
                                        Printer^.PrintToFile(AFile,PrintOut)
                                        {$ELSE}
                                        Printer^.PrintToFile(
                                                 Data.SelectedPrinter,
                                                 AFile,PrintOut)
                                        {$ENDIF OnePrinter}
                                   ELSE Dispose(PrintOut,Done);
                              END;
                    END;
          END;
END;
{****************************************************************************}
PROCEDURE PrintFile (Formatted : Boolean);
VAR AFile : FNameStr;
    {$IFNDEF OnePrinter}
    Dlg : PDialog;
    Data : TPrintFileRec;
    {$ENDIF OnePrinter}
BEGIN
  IF Formatted
     THEN AFile := PrinterFileMask
     ELSE AFile := '';
{  IF FileSelected(AFile,AnyFile)
     THEN { $IFDEF OnePrinter}
{          Printer^.PrintFile(AFile,Formatted);
          { $ELSE}
{          BEGIN
            { $IFDEF ResourceFile}
{            Dlg := PPrintFileDlg(ResourceFile^.Get(rePrintFileDlg));
            { $ELSE}
{            Dlg := New(PPrintFileDlg,Init(AFile));
            { $ENDIF ResourceFile}
{            Data.FileName := AFile;
            Data.PrinterName := Printer^.GetDefaultPrinter;
            IF (Application^.ExecuteDialog(Dlg,@Data) = cmOk)
               THEN Printer^.PrintFile(Data.PrinterName,AFile,Formatted);
          END;
          { $ENDIF OnePrinter}
END;
{****************************************************************************}
PROCEDURE PrintFileEditor (Editor : PFileEditor);
BEGIN
  PrintEditor(Editor^.FileName,Editor);
END;
{****************************************************************************}
PROCEDURE PrintEditWindow (EditWindow : PEditWindow);
BEGIN
  PrintEditor(EditWindow^.Editor^.FileName,EditWindow^.Editor);
END;
{****************************************************************************}
PROCEDURE PrintMemo (ATitle : FNameStr; Memo : PMemo);
BEGIN
  PrintEditor(ATitle,Memo);
END;
{****************************************************************************}
PROCEDURE RegisterWvsPrint;
BEGIN
  RegisterType(RTVPrinter);
  {$IFNDEF OnePrinter}
  RegisterType(RTVPrinterCollection);
  {$ENDIF OnePrinter}
  RegisterPorts;
  RegisterTvPrtDlg;
END;
{****************************************************************************}
{$IFNDEF OnePrinter}
FUNCTION SelectPrinter (VAR Index : Integer) : Boolean;
VAR Dlg : PPrinterSelectDlg;
    Data : TPrinterSelectRec;
BEGIN
  SelectPrinter := FALSE;
  {$IFDEF ResourceFile}
  Dlg := PPrinterSelectDlg(ResourceFile^.Get(rePrinterSelectDlg));
  {$ELSE}
  Dlg := New(PPrinterSelectDlg,Init);
  {$ENDIF ResourceFile}
  Data.PrinterCollection := Printer;
  Data.Selection := Index;
  Data.DefaultPrinter := Printer^.GetDefaultPrinter;
  IF Application^.ExecuteDialog(Dlg,@Data) = cmOk
     THEN BEGIN
            SelectPrinter := TRUE;
            Index := Data.Selection;
          END;
END;
{$ENDIF OnePrinter}
{****************************************************************************}
PROCEDURE SetupPrinter (APrinter : PTVPrinter);
VAR Dlg : PPrinterSetupDlg;
    Data : TPrinterSetupRec;
  S: string;
BEGIN
  {$IFDEF ResourceFile}
  Dlg := PPrinterSetupDlg(ResourceFile^.Get(rePrinterSetupDlg));
  {$ELSE}
  Dlg := New(PPrinterSetupDlg,Init);
  {$ENDIF ResourceFile}
  WITH Data DO
    BEGIN
      Name := APrinter^.Name^;
      Brand := APrinter^.GetBrand;
      BufferSize := APrinter^.BufferSize;
      TimeOut := APrinter^.TimeOut;
      Background := Ord(APrinter^.BackgroundPrinting);
    END;
  S := PPort(APrinter^.Stream)^.Title;
  IF NOT PortList^.Search(@S,Data.PrinterPort)
     THEN Data.PrinterPort := 0;
  Data.PortList := PortList;
  IF Application^.ExecuteDialog(Dlg,@Data) = cmOk
     THEN WITH Data DO
            BEGIN
              {$IFDEF OnePrinter}
              Printer^.SetName(Name);
              Printer^.BufferSize := BufferSize;
              Printer^.SetTimeOut(TimeOut);
              Printer^.Stream := PortList^.At(PrinterPort);
              IF Background = 1
                 THEN Printer^.SetBackgroundPrinting(On)
                 ELSE Printer^.SetBackgroundPrinting(Off);
              {$ELSE}
              APrinter^.SetName(Name);
              APrinter^.BufferSize := BufferSize;
              APrinter^.SetTimeOut(TimeOut);
              APrinter^.Stream := PortList^.At(PrinterPort);
              IF Background = 1
                 THEN APrinter^.SetBackgroundPrinting(On)
                 ELSE APrinter^.SetBackgroundPrinting(Off);
              {$ENDIF OnePrinter}
            END;
END;
{****************************************************************************}
FUNCTION StdPrinterMenuItems (Next : PMenuItem) : PMenuItem;
BEGIN
  StdPrinterMenuItems :=
     NewItem('~P~rint','',kbNoKey,cmPrint,hcPrint,
     NewItem('Print ~F~ile','',kbNoKey,cmPrintFile,hcPrintFile,
     NewItem('Print For~m~atted File','',kbNoKey,cmPrintFormatedFile,
             hcPrintFormatedFile,
     NewItem('Printer Se~t~up', '', kbNoKey, cmPrinterSelect, hcPrinterSetup,
     NewItem('Print ~Q~ueue', '', kbNoKey, cmPrintQueue, hcPrintQueue,
     Next)))));
END;
{****************************************************************************}
{                                                                            }
{               Initialization of Global and Local Variables                 }
{                                                                            }
{****************************************************************************}
BEGIN
  DriverDirectory := '';
END.
