
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias K"oppe              }
{                                                       }
{*******************************************************}

(* This example shows:
   - Loading Graphics Vision's special Windows dialog controls
     from a resource.

   IMPORTANT:  The dialog controls used in this example are not
               standard Windows controls. We have developped a
   new Resource Workshop DLL which provides visual design of
   'GvTable' and 'LevelZero' objects. Run the Resource Workshop
   on the `exam.dll' file, and use Options|Install Library
   to install the `gvrws.dll' file.
*)

uses
  { Turbo Vision units }
  Objects, Drivers, Memory,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox, WinRes, KeyNames, GvWinDlg, GvBWCC,
  GvDialog, GvValid, GvTexts, GvBitmap,
  { Graphics Vision table unit }
  GvTable;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

function LoadWinDialog(Name: PChar): PWinDialog;
var
  Dlg: PWinDialog;
begin
  Dlg := PWinDialog(Application^.ValidView(LoadDialog(Res^, Name)));
  If Dlg <> nil
  then Dlg^.Options := Dlg^.Options or ofCentered;
  LoadWinDialog := Dlg
end;

type
{ The application
}
  TDemoApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  InitClasses;
  RegisterGvWinDlg;
  { Install the 'GvTable' control class
  }
  RegisterGvTable;
  InitBWCC;
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  inherited Done;
  DoneClasses;
  DoneBWCC;
  Dispose(Res, Done);
end;

var
  App: TDemoApp;

Begin
  App.Init;
  App.ExecuteDialog(LoadWinDialog('special'), nil);
  App.Done
End.
