
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias K"oppe              }
{                                                       }
{*******************************************************}

{ $Id: exam0209.pas 1.3 1999/02/13 14:31:59 mkoeppe Exp $ }

(* This example shows:
   - how to load a Windows dialog with automatically validated input lines

   The text given to the input line in Resource Workshop
   is parsed (interpreted) by the GvWinDlg unit:

   - If the text begins with "@50", the input line is made 50 characters
     long (rather than the default 255).
   - If the text contains "Filter(ABC123)", a TFilterValidator object
     with character mask "ABC123" is created and added to the input line.
   - If the text contains "Range(-10,10)", a TRangeValidator object
     with lower bound -10 and upper bound 10 is created and added to the
     input line.
   - If the text contains "Picture(###.##)", a TPXPictureValidator object
     with picture "###.##" and no auto-fill is created and added to the
     input line.
     Auto-fill can be requested by using "Picture(###.##,AutoFill)".
   - If the text contains "Real(3)", a TRealValidator object with
     3 decimals is created and added to the input line.

   You can register your own validator classes. See the GvWinDlg source
   for details.

   We get our Windows resource from the `exam.dll'.
*)

uses
  { Turbo Vision units }
  Objects, Drivers, Memory,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox, WinRes, KeyNames, GvWinDlg, GvBWCC,
  GvDialog, GvValid, GvTexts, GvBitmap;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

function LoadWinDialog(Name: PChar): PWinDialog;
var
  Dlg: PWinDialog;
begin
  Dlg := PWinDialog(Application^.ValidView(LoadDialog(Res^, Name)));
  If Dlg <> nil
  then Dlg^.Options := Dlg^.Options or ofCentered;
  LoadWinDialog := Dlg
end;

type
{ The application
}
  TDemoApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitStatusLine; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  InitClasses;
  RegisterGvWinDlg;
  BWCC := Res;
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  inherited Done;
  DoneClasses;
  Dispose(Res, Done);
end;

procedure TDemoApp.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  If Event.What = evCommand
  then begin
    case Event.Command of
      100:
	ExecuteDialog(LoadWinDialog('VALINPUT'), nil);
      else Exit;
    end;
    ClearEvent(Event)
  end
end;

procedure TDemoApp.InitStatusLine;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKeyKN('Exit', kbAltX, cmQuit,
      NewStatusKeyKN('Validated input lines', kbF1, 100,
      nil)),
    nil)));
End;

var
  App: TDemoApp;

Begin
  App.Init;
  App.Run;
  App.Done
End.
