#if !defined(_DEBUG_H_)
#define _DEBUG_H_

void init_debug();

/* print tracepoint values */
void printd();

/* print last entry/exit tracepoints */
void printp(); 

/* print interrupt state */
void printi();

/* verzoegert den Reboot beim Systemcrash */
void crash_reboot();

#define DEBUG(point) debug_string[point*2]++; debug_last_entry=debug_entry; debug_entry=point; debug_state=1;
#define ENDDEBUG(point) debug_string[point*2]--; debug_last_exit=debug_exit; debug_exit=point; debug_state=0;
#define DEBUGENTER(point) debug_enter_proc = point; debug_enter = 1;
#define DEBUGLEAVE(point) debug_leave_proc = point; debug_enter = 0;

#define D_sys_create_process 1
#define D_sys_kill_process   2
#define D_sys_exit_process   3
#define D_sys_resume         4
#define D_sys_memalloc       5
#define D_sys_memfree        6
#define D_sys_memfreesize    7
#define D_sys_memmaxsize     8
#define D_sys_memclean       9
#define D_sys_exit_IdleLoop 10
#define D_resume            11
#define D_remove_myself     12
#define D_lifter            13
#define D_create_process    14
#define D_kill_process      15
#define D_exit_process      16
#define D_relay             17
#define D_enter             18
#define D_enter_BLOCK       19
#define D_leave             20
#define D_relay_BLOCKED     21
#define D_relay_UNBLOCKED   22
#define D_timer_prologue    23
#define D_timer_epilogue    24
#define D_keybd_prologue    25
#define D_keybd_epilogue    26
#define D_enter_spinlock    27
#define D_sys_getchar       28

extern char debug_string[160]; 
extern unsigned debug_last_entry;
extern unsigned debug_last_exit;
extern unsigned debug_entry;
extern unsigned debug_exit;
extern unsigned debug_int;
extern unsigned debug_state;
extern unsigned debug_enter_proc;
extern unsigned debug_leave_proc;
extern unsigned debug_enter;

#endif /* _DEBUG_H_ */

