"Esso: Documentation"
"Written by Matthias Koeppe <mkoeppe@csmd.cs.uni-magdeburg.de>"

(define info-alist '())
(define info-file-alist '())
(define info-file-list '())
(define (define-info symbol docu)
  (set! info-alist (cons (cons symbol docu)
			 info-alist))
  #t)
(define (read-info-aux port pred?)
  (let ((entry (read port)))
    (if (not (eof-object? entry))
	(if (not (pred? entry))
	    (read-info-aux port pred?)
	    entry)
	#f)))
(define (info-from-info-file-aux name symbol)
  (let* ((port (open-input-file name))
	 (entry (read-info-aux port
			       (lambda (entry)
				 (eq? (car entry) symbol)))))
    (if entry
	(cdr entry)
	#f)))
(define (index-info-file-aux name)
  (let ((port (open-input-file name)))
    (read-info-aux port
		   (lambda (entry)
		     (begin
		       (set! info-file-alist
			     (cons (cons (car entry) name)
				   info-file-alist))
		       #f))))
  #t)
(define (info-aux symbol)
  (let ((entry (assq symbol info-file-alist)))
	  (if entry
	      (info-from-info-file-aux (cdr entry) symbol)
	      (if (not (null? info-file-list))
		  (begin
		    (index-info-file-aux (car info-file-list))
		    (set! info-file-list (cdr info-file-list))
		    (info-aux symbol))
		  #f))))
(define (get-info symbol)
  (let ((entry (assq symbol info-alist)))
    (if entry
	(cdr entry)
	(info-aux symbol))))	  
  
(define (info . symbol-l)
  (pretty (get-info (if (null? symbol-l) 'info (car symbol-l)))))

"info"
