// This is a -*- C++ -*- header file.

// Abstract interface for access to `streams', `mailboxes', or `pipes'.
// <mkoeppe@cs.uni-magdeburg.de>

#if !defined(_PIPEBASE_H)
#define _PIPEBASE_H

template <class T>
class TPipeBase {
public:
  virtual ~TPipeBase() {}
  // Get and put block the process if needed.
  virtual void Put(const T *Item) = 0;
  virtual T *Get() = 0;
  // Read and write will do nothing in this case.
  virtual void Write(const T* Item) = 0;
  virtual T *Read() = 0;
  // Maybe with some pipes a `closed' state makes sense, so:
  virtual void Close(int=0) {}
  virtual bool Closed() { return false; }
};

#endif
