// This is a -*- C++ -*- header file.

#if !defined(_CMAILBOX_H_)
#define _CMAILBOX_H_

extern "C" {
#include "system/mailbox.h"
#include "library/syslib.h"
}

class TMailBox {
  mailbox *mb;
  bool shoulddelete;
public:
  TMailBox(int size) {
    mb = new mailbox;
    shoulddelete = 1;
    void *buffer = new char[size];
    sys_mailbox_init(mb, buffer, size);
  }
  TMailBox(mailbox *m) : mb(m), shoulddelete(0) {}
  ~TMailBox() { if (shoulddelete) delete mb; }
  operator mailbox*() { return mb; }
};

#endif
