{
  System independent mouse interface for go32v2

  $Id: mouse.inc,v 1.2 1998/12/11 00:13:19 peter Exp $
}

uses
  go32;

var
  RealSeg : Word;                                    { Real mode segment }
  RealOfs : Word;                                    { Real mode offset }
  MouseCallback : Pointer;                           { Mouse call back ptr }
  ActionRegs    : TRealRegs;                         { Real mode registers }

{$ASMMODE ATT}
procedure MouseInt;assembler;
asm
        movb    %bl,mousebuttons
        movw    %cx,mousewherex
        movw    %dx,mousewherey
        cmpb    MouseEventBufSize,PendingMouseEvents
        je      .Lmouse_exit
        movl    PendingMouseTail,%edi
        shrw    $3,%cx
        shrw    $3,%dx
        movw    %bx,(%edi)
        movw    %cx,2(%edi)
        movw    %dx,4(%edi)
        movw    $0,6(%edi)
        addl    $8,%edi
        leal    PendingMouseEvent,%eax
        addl    MouseEventBufSize*8,%eax
        cmpl    %eax,%edi
        jne     .Lmouse_nowrap
        leal    PendingMouseEvent,%edi
.Lmouse_nowrap:
        movl    %edi,PendingMouseTail
        incb    PendingMouseEvents
.Lmouse_exit:
end;



PROCEDURE Mouse_Trap; ASSEMBLER;
ASM
   PUSH %ES;                                          { Save ES register }
   PUSH %DS;                                          { Save DS register }
   PUSHL %EDI;                                        { Save register }
   PUSHL %ESI;                                        { Save register }
   ;{ caution : ds is not the selector for our data !! }
   PUSH %ES;                                          { Push data seg }
   POP %DS;                                           { Load data seg }
   PUSHL %EDI;                                        { Actionregs address }
   MOVL MOUSECALLBACK, %EAX;                         { Fetch callback addr }
   CMPL $0, %EAX;                                     { Check for nil ptr }
   JS .L_NoCallBack;                                  { Ignore if nil }
   POPL %EAX;                                         { %EAX = @actionregs }
   MOVL (%EAX), %EDI;                                 { EDI from actionregs }
   MOVL 4(%EAX), %ESI;                                { ESI from actionregs }
   MOVL 16(%EAX), %EBX;                               { EBX from actionregs }
   MOVL 20(%EAX), %EDX;                               { EDX from actionregs }
   MOVL 24(%EAX), %ECX;                               { ECX from actionregs }
   MOVL 28(%EAX), %EAX;                               { EAX from actionregs }
   CALL *MOUSECALLBACK;                              { Call callback proc }
.L_NoCallBack:
   POPL %ESI;                                         { Recover register }
   POPL %EDI;                                         { Recover register }
   POP %DS;                                           { Restore DS register }
   POP %ES;                                           { Restore ES register }
   MOVL (%ESI), %EAX;
   MOVL %EAX, %ES:42(%EDI);                           { Set as return addr }
   ADDW $4, %ES:46(%EDI);                             { adjust stack }
   IRET;                                              { Interrupt return }
END;


PROCEDURE Mouse_Action (Mask : Integer; P : Pointer);
VAR
  Error : Word;
  Rg    : TRealRegs;
BEGIN
  Error := 0;                                         { Preset no error }
  If (P <> MouseCallBack) Then                        { Check func different }
   Begin
   { Remove old calback }
     If (RealSeg <> 0) Then
      Begin
        Rg.AX := 12;                                   { Function id }
        Rg.CX := 0;                                    { Zero mask register }
        Rg.ES := 0;                                    { Zero proc seg }
        Rg.DX := 0;                                    { Zero proc ofs }
        RealIntr($33, Rg);                             { Stop INT 33 callback }
        ASM
         MOVW $0x304, %AX;                            { Set function id }
         MOVW REALSEG, %CX;                           { Bridged real seg }
         MOVW REALOFS, %DX;                           { Bridged real ofs }
         INT $0x31;                                   { Release bridge }
       END;
     End;
    MouseCallback := P;                              { Set call back addr }
    If (P <> Nil) Then
     Begin
       ASM
         LEAL ACTIONREGS, %EDI;                      { Addr of actionregs }
         LEAL MOUSE_TRAP, %ESI;            { Procedure address }
         PUSH %DS;                                    { Save DS segment }
         PUSH %ES;                                    { Save ES segment }
         PUSH %DS;
         POP  %ES;                                    { ES now has dataseg }
         PUSH %CS;
         POP  %DS;                                    { DS now has codeseg }
         MOVW $0x303, %AX;                            { Function id }
         INT  $0x31;                                  { Call DPMI bridge }
         POP  %ES;                                    { Restore ES segment }
         POP  %DS;                                    { Restore DS segment }
         MOVW %CX,REALSEG;                            { Transfer real seg }
         MOVW %DX,REALOFS;                            { Transfer real ofs }
         MOVW $0, %AX;                                { Preset zero error }
         JNC .L_call_ok;                              { Branch if ok }
         MOVW $0xFFFF, %AX;                           { Force a -1 error }
       .L_call_ok:
         MOVW %AX, ERROR;                             { Return error state }
       END;
       Rg.CX := Mask;                                 { Set mask register }
     End
    Else
     Begin
       Rg.EDI := 0;                                   { Zero proc register }
       Rg.CX := 0;                                    { Zero mask register }
     End;
    If (Error = 0) Then
     Begin
       Rg.AX := 12;                                   { Set function id }
       Rg.ES := RealSeg;                              { Real mode segment }
       Rg.DX := RealOfs;                              { Real mode offset }
       RealIntr($33, Rg);                             { Set interrupt 33 }
     End;
   End;
  If (Error <> 0) Then
   Begin
     Writeln('GO32V2 mouse handler set failed !!');
     ReadLn;                                          { Wait for user to see }
     RealSeg := 0;                                    { Zero real mode seg }
     RealOfs := 0;                                    { Zero real mode ofs }
   End;
END;


procedure InitMouse;
begin
  PendingMouseHead:=@PendingMouseEvent;
  PendingMouseTail:=@PendingMouseEvent;
  PendingMouseEvents:=0;
  FillChar(LastMouseEvent,sizeof(TMouseEvent),0);

  Lock_Code(Pointer(@Mouse_Trap), 400);              { Lock trap code }
  Lock_Data(ActionRegs, SizeOf(TRealRegs));          { Lock registers }
  MouseCallBack := Nil;                              { Clear call back }
  RealSeg := 0;                                      { Zero segment }
  RealOfs := 0;                                      { Zero offset }
  Mouse_Action(-1, @MouseInt);                       { Set masks/interrupt }

  ShowMouse;
end;


procedure DoneMouse;
begin
  HideMouse;
  If (MouseCallBack <> Nil) Then
    Mouse_Action(0, Nil);                            { Clear mask/interrupt }
  Unlock_Code(Pointer(@Mouse_Trap), 400);            { Release trap code }
  Unlock_Data(ActionRegs, SizeOf(TRealRegs));        { Release registers }
  MouseCallBack := Nil;                              { Clear call back ptr }
end;


function DetectMouse:byte;assembler;
asm
        movl    $0x200,%eax
        movl    $0x33,%ebx
        int     $0x31
        movw    %cx,%ax
        orw     %ax,%dx
        jz      .Lno_mouse
        xorl    %eax,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        orw     %ax,%ax
        jz      .Lno_mouse
        movl    %ebx,%eax
.Lno_mouse:
end;


procedure ShowMouse;assembler;
asm
        movl    $1,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
end;


procedure HideMouse;assembler;
asm
        movl    $2,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
end;


function GetMouseX:word;assembler;
asm
        movl    $3,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        movzwl  %cx,%eax
        shrl    $3,%eax
        incl    %eax
end;


function GetMouseY:word;assembler;
asm
        movl    $3,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        movzwl  %dx,%eax
        shrl    $3,%eax
        incl    %eax
end;


function GetMouseButtons:word;assembler;
asm
        movl    $3,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        movw    %bx,%ax
end;


procedure SetMouseXY(x,y:word);assembler;
asm
        movw    x,%cx
        movw    y,%dx
        movl    $4,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
end;


procedure GetMouseEvent(var MouseEvent: TMouseEvent);
begin
  repeat until PendingMouseEvents>0;
  MouseEvent:=PendingMouseHead^;
  inc(PendingMouseHead);
  if longint(PendingMouseHead)=longint(@PendingMouseEvent)+sizeof(PendingMouseEvent) then
   PendingMouseHead:=@PendingMouseEvent;
  dec(PendingMouseEvents);
  if (LastMouseEvent.x<>MouseEvent.x) or (LastMouseEvent.y<>MouseEvent.y) then
   MouseEvent.Action:=MouseActionMove;
  if (LastMouseEvent.Buttons<>MouseEvent.Buttons) then
   begin
     if (LastMouseEvent.Buttons=0) then
      MouseEvent.Action:=MouseActionDown
     else
      MouseEvent.Action:=MouseActionUp;
   end;
  LastMouseEvent:=MouseEvent;
end;


function PollMouseEvent(var MouseEvent: TMouseEvent):boolean;
begin
  if PendingMouseEvents>0 then
   begin
     MouseEvent:=PendingMouseHead^;
     PollMouseEvent:=true;
   end
  else
   PollMouseEvent:=false;
end;

{
  $Log: mouse.inc,v $
  Revision 1.2  1998/12/11 00:13:19  peter
    + SetMouseXY
    * use far for exitproc procedure

  Revision 1.1  1998/12/04 12:48:27  peter
    * moved some dirs

  Revision 1.2  1998/10/28 21:18:25  peter
    * more fixes

  Revision 1.1  1998/10/28 00:02:08  peter
    + mouse
    + video.clearscreen, video.videobufsize

}
