{
   *********************************************************************
   Version: 1998.06.09
   Copyright (C) 1997, 1998 Gertjan Schouten

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   *********************************************************************
}

unit targa;

interface

uses objects, bitmaps;

type
   {$PACKRECORDS 1}
   TTGAHeader = record
      idlen : byte;
      cmtype : byte;
      imgtype : byte;
      cmorg : word;
      cmlen : word;
      cmes : byte;
      xorg : integer;
      yorg : integer;
      width : integer;
      height : integer;
      pixsize : byte;
      desc : byte;
   end ;
   TTGAExtra = record
      extsize : integer;
      authorname : array[0..40] of char;
      comments : array[0..323] of char;
      td_month : integer;
      td_day : integer;
      td_year : integer;
      td_hour : integer;
      td_minute : integer;
      td_second : integer;
      jobname : array[0..40] of char;
      jt_hours : integer;
      jt_minutes : integer;
      jt_seconds : integer;
      softwareID : array[0..40] of char;
      sw_version : integer;
      version_letter : char;
      key_a,key_r,key_g,key_b : byte;
      aspect_w : integer;
      aspect_h : integer;
      gamma_numerator : integer;
      gamma_denominator : integer;
      color_corr_table : longint;
      postage_stamp : longint;
      scan_line : longint;
      alpha_attributes : byte;
   end ;
   {$PACKRECORDS normal}

   TBitmapIO_Targa = object(TBitmapIO)
      hdr:TTGAHeader;
      id:pointer;
      Function LoadPalette(stream:pstream):boolean;
      Function Load32bittga(stream:pstream):boolean;
      Function load24bittga(stream:pstream):boolean;
      Function load16bittga(stream:pstream):boolean;
      Function load8bitgraytga(stream:pstream):boolean;
      Function Load8bitpaltga(stream:pstream):boolean;
   public
      constructor Create;
      function LoadHeader(stream:pstream):boolean; virtual;
      function LoadImage(stream:pstream):boolean; virtual;
      destructor Destroy; virtual;
   end ;

var
   BitmapIO_Targa: TBitmapIO_Targa;

implementation


Function TBitmapIO_Targa.LoadPalette(stream: pstream):boolean;
var palet:pointer;
begin
if (hdr.cmLen > 0) then begin
   GetMem(Palet, hdr.cmLen * 4);
      case hdr.cmes of
         15,16: begin
            stream^.read(Palet^, hdr.cmLen * 2);
            fBitmap^.setPalette(Palet, hdr.cmLen, ptBGR5, 2);
            end ;
         24: begin
            stream^.read(Palet^, hdr.cmlen * 3);
            fBitmap^.setPalette(Palet, hdr.cmLen, ptBGR8 ,3);
            end ;
         32: begin
            stream^.read(Palet^, hdr.cmLen * 4);
            fBitmap^.setPalette(Palet, hdr.cmLen, ptBGR8, 4);
            end ;
      end ;
   FreeMem(Palet, hdr.cmLen * 4);
   end ;
result := true;
end ;

Function TBitmapIO_Targa.Load8bitpaltga(stream:pstream):boolean;
var pixel,rle:byte;i,ix,x,y:integer;b,buffer:pointer;
begin
if not(hdr.cmes in [15,16,24,32]) then exit(false);
Getmem(buffer,hdr.width);
Result := true;
if hdr.imgtype = 1 then begin
   for y := hdr.height-1 downto 0 do begin
      stream^.read(buffer^, hdr.width);
      fBitmap^.putpixels(0, y, hdr.width, buffer, 8);
      end ;
	end
else if hdr.imgtype = 9 then begin
   x := 0;
   y := hdr.height - 1;
   while not(y < 0) do begin
	   stream^.read(rle, 1);
      if (rle > 127) then begin
         rle := rle - 128;
         stream^.read(pixel, 1);
         for ix := 0 to rle do begin
            byte(pointer(buffer + x)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               fBitmap^.putpixels(0, y, hdr.width, buffer, 8);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end
      else begin
         for ix := 0 to rle do begin
            stream^.read(pixel, 1);
            byte(pointer(buffer + x)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               fBitmap^.putpixels(0, y, hdr.width, buffer, 8);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end ;
      end ;
   end
else result := false;
Freemem(buffer, hdr.width);
end ;

Function TBitmapIO_Targa.load8bitgraytga(stream:pstream):boolean;
begin
result := false;
end ;

Function TBitmapIO_Targa.load16bittga(stream:pstream):boolean;
var rle:byte;pixel:word;ix,x,y:integer;buffer:pointer;
begin
result := true;
getmem(buffer, hdr.width * 2);
if hdr.imgtype = 2 then begin
   for y := hdr.height-1 downto 0 do begin
      stream^.read(buffer^, hdr.width * 2);
      FBitmap^.putpixels(0, y, hdr.width, buffer, 16);
      end ;
   end
else if hdr.imgtype = 10 then begin
   x := 0;
   y := hdr.height - 1;
   while not(y < 0) do begin
	   stream^.read(rle, 1);
      if (rle > 127) then begin
         rle := rle - 128;
         stream^.read(pixel, 2);
         for ix := 0 to rle do begin
            word(pointer(buffer + x * 2)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               FBitmap^.putpixels(0, y, hdr.width, buffer, 16);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end
      else begin
         for ix := 0 to rle do begin
            stream^.read(pixel, 2);
            word(pointer(buffer + x * 2)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               FBitmap^.putpixels(0, y, hdr.width, buffer, 16);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end ;
      end ;
   end
else result := false;
Freemem(buffer, hdr.width * 2);
end ;

Function TBitmapIO_Targa.load24bittga(stream:pstream):boolean;
var rle:byte;pixel:longint;ix,x,y:integer;buffer:pointer;
begin
result := true;
getmem(buffer, hdr.width * 3);
if hdr.imgtype = 2 then begin
	for y := hdr.height-1 downto 0 do begin
   	stream^.read(buffer^, hdr.width * 3);
      FBitmap^.putpixels(0, y, hdr.width, buffer, 24);
      end ;
   end
else if hdr.imgtype = 10 then begin
   x := 0;
   y := hdr.height - 1;
   while not(y < 0) do begin
	   stream^.read(rle, 1);
      if (rle > 127) then begin
         rle := rle - 128;
         stream^.read(pixel, 3);
         for ix := 0 to rle do begin
            longint(pointer(buffer + x * 3)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               FBitmap^.putpixels(0, y, hdr.width, buffer, 24);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end
      else begin
         for ix := 0 to rle do begin
            stream^.read(pixel, 3);
            longint(pointer(buffer + x * 3)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               FBitmap^.putpixels(0, y, hdr.width, buffer, 24);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end ;
      end ;
   end
else result := false;
Freemem(buffer, hdr.width * 3);
end ;

Function TBitmapIO_Targa.Load32bittga(stream:pstream):boolean;
var rle:byte;pixel:longint;ix,x,y:integer;buffer:pointer;
begin
result := true;
getmem(buffer, hdr.width * 4);
if hdr.imgtype = 2 then begin
   for y := hdr.height-1 downto 0 do begin
      stream^.read(buffer^, hdr.width * 4);
      FBitmap^.putpixels(0, y, hdr.width, buffer, 32);
      end ;
   end
else if hdr.imgtype = 10 then begin
   x := 0;
   y := hdr.height - 1;
   while not(y < 0) do begin
	   stream^.read(rle, 1);
      if (rle > 127) then begin
         rle := rle - 128;
         stream^.read(pixel, 4);
         for ix := 0 to rle do begin
            longint(pointer(buffer + x * 4)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               FBitmap^.putpixels(0, y, hdr.width, buffer, 32);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end
      else begin
         for ix := 0 to rle do begin
            stream^.read(pixel, 4);
            longint(pointer(buffer + x * 4)^) := pixel;
            x := x + 1;
            if (x >= hdr.width) then begin
               FBitmap^.putpixels(0, y, hdr.width, buffer, 32);
               dec(y);
               x := 0;
               if (y < 0) then break;
               end ;
            end ;
         end ;
      end ;
   end
else result := false;
freemem(buffer, hdr.width * 4);
end ;

constructor TBitmapIO_Targa.Create;
begin
inherited create;
FFileExt := '.TGA';
FFrameCount := 10;
end ;

function TBitmapIO_Targa.LoadHeader(stream:pstream):boolean;
begin
if id <> Nil then freemem(id, hdr.idlen);
id := Nil;
stream^.seek(0);
stream^.read(hdr, sizeof(TTGAHeader));
if FBitmap^.getBytesPerPixel = 0 then begin
      case hdr.PixSize of
         8: FBitmap^.setBytesPerPixel(1);
         16: FBitmap^.setBytesPerPixel(2);
         24, 32: FBitmap^.setBytesPerPixel(4);
      end ;
   end ;
FBitmap^.setWidth(hdr.Width);
FBitmap^.setHeight(hdr.Height);
if hdr.idlen <> 0 then begin
   getmem(id, hdr.idlen);
   stream^.read(id^, hdr.idlen);
   end ;
LoadPalette(stream);
result := true;
end ;

function TBitmapIO_Targa.LoadImage(stream:pstream):boolean;
begin
result := true;
   case hdr.pixsize of
      8: begin
            case hdr.imgtype of
               1,9: load8bitpaltga(stream);
               3,11: load8bitgraytga(stream);
            end ;
         end ;
      16: load16bittga(stream);
      24: load24bittga(stream);
      32: load32bittga(stream);
      else result := false;
   end ;
end ;

destructor TBitmapIO_Targa.Destroy;
begin
if id <> nil then Freemem(id, hdr.idlen);
end ;

begin
BitmapIO_Targa.create;
end .

