{ Known Bugs

- colors and video options are not restored when a config object is loaded
  from a stream }

{#Z+}
{ App.pas
  FreeVision Application Configuration Unit
  BitSoft Development, L.L.C.
  Version: 1.1

Revision History
-----------------

1.1   (98/01/07)
  - moved from BitSoft TurboVision library to part of FreeVision library

1.0
  - original release }
{#Z-}

unit Config;

{
  The Config unit declares the #TConfig# object for managing all standard
  program configuration tasks including setting the system date and time,
  program colors, mouse configuration, and various video settings.

  All settings may be changed at run-time giving the end-user control over the
  look and feel of the application.  Individual applications can add
  application specific functionality, such as storing a data directory, by
  creating a TConfig descendant.  #TApplication# has built-in support for
  all configuration options when the #StdOptionsMenuItems# is used.
}

{$i platform.inc}

{$ifdef PPC_FPC}
  {$H-}
{$else}
  {$F+,O+,E+,N+}
{$endif}
{$X+,R-,I-,Q-,V-}
{$ifndef OS_LINUX}
  {$S-}
{$endif}

interface

uses
  Dos,
  Commands, ObjTypes, Objects, Drivers, Views, Dialogs, Menus, ColorSel;

const
    { Resource File constants }
  reColorsDlg = 'ColorsDlg';
  reDateDlg   = 'DateDlg';
  reMouseDlg  = 'MouseDlg';
  reTimedlg   = 'TimeDlg';
  reVideoDlg  = 'VideoDlg';

    { String constants }
  sAbout                  = 100;
  sDesktop                = sAbout + 1;
  sMenus                  = sDesktop + 1;
  sDialogs                = sMenus + 1;
  sWindows                = sDialogs + 1;
  sSystemDate             = sWindows + 1;
  slDisplay               = sSystemDate + 1;
  slDate                  = slDisplay + 1;
  sFormat                 = slDate + 1;
  slOrder                 = sFormat + 1;
  slMonth                 = slOrder + 1;
  slDay                   = slMonth + 1;
  slYear                  = slDay + 1;
  slFill                  = slYear + 1;
  slParts                 = slFill + 1;
  slSeparator             = slParts + 1;
  sMouseOptions           = slSeparator + 1;
  slMouseDoubleClick      = sMouseOptions + 1;
  sFastMediumSlow         = slMouseDoubleClick + 1;
  slReverseMouseButtons   = sFastMediumSlow + 1;
  seClockNotDisplayed     = slReverseMouseButtons + 1;
  sVideoOptions           = seClockNotDisplayed + 1;
  slColor                 = sVideoOptions + 1;
  slColors                = slColor + 1;
  slShowMarkers           = slColors + 1;
  sl25Lines               = slShowMarkers + 1;
  sl43or50Lines           = sl25Lines + 1;
  slLinesPerScreen        = sl43or50Lines + 1;
  slCheckSnow             = slLinesPerScreen + 1;
  seOptionsLoad           = slCheckSnow + 1;
  slOptions               = seOptionsLoad + 1;
  slEnvironment           = slOptions + 1;
  slMouse                 = slEnvironment + 1;
  slTime                  = slMouse + 1;
  slVideo                 = slTime + 1;
  slF1Help                = slVideo + 1;


    { TClickerTester Palette }
    { 0 = Unclicked }
    { 1 = Clicked }
  CClickTester = #7#8;


  ConfigExt: ExtStr = '.CFG';
    { ConfigExt is the default configuration file extension. }

  ConfigFile: PString = nil;
    { ConfigFile is the path and  file of the current configuration being
      used. }
    {#X Config TConfig }


type
  {#Z+}
  PClickTester = ^TClickTester;
  {#Z-}
  TClickTester = Object(TStaticText)
    Clicked: Boolean;
    constructor Init (var Bounds: TRect; AText: String);
    function  GetPalette: PPalette; virtual;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure Draw; virtual;
  end;  { of TClickTester }


  {#Z+}
  PDesktopDlg = ^TDesktopDlg;
  {#Z-}
  TDesktopDlg = Object(TDialog)
    constructor Init;
  end;  { of TDesktopDlg }


  {#Z+}
  PMouseDlg = ^TMouseDlg;
  {#Z-}
  TMouseDlg = Object(TDialog)
    { A TMouseDlg provides views for setting all configurable mouse options
      within the Turbo Vision framework - double click speed, repeat delay,
      and reversing mouse buttons. }
    DoubleDelayScrollBar: PScrollBar;
      { DoubleDelayScrollBar is used to set the value of DoubleDelay. }
      {#X RepeatDelayScrollBar HandleEvent }
    RepeatDelayScrollBar: PScrollBar;
      { RepeatDelayScrollBar is used to set the value of RepeatDelay. }
      {#X DoubleDelayScrollBar HandleEvent }
    constructor Init;
      { Init creates and inserts the dialogs subviews, then assigns the
        current values of DoubleDelay, RepeatDelay and MouseReverse to their
        corresponding OldXXXX variables for later restoration. }
      {#X OldDoubleDelay OldRepeatDelay OldReverse Done }
    constructor Load (var S: TStream);
      { Loads reads the view from the current position in stream S then
        assigns the current values of DoubleDelay, RepeatDelay and
        MouseReverse to their corresponding OldXXXX variables for later
        restoration. }
      {#X OldDoubleDelay OldRepeatDelay OldReverse Done }
    destructor Done; virtual;
      { Done restores the values of DoubleDelay, RepeatDelay, and
        MouseReverse to their state on creation of the dialog. }
      {#X Init Load OldDoubleDelay OldReverse }
    procedure HandleEvent (var Event: TEvent); virtual;
      { HandleEvent captures the mouse parameter scrollbar movements and
        updates their corresponding values appropriately. }
      {#X DoubleDelayScrollBar RepeatDelayScrollBar }
    procedure Store (var S: TStream);
      { Store writes the dialog to the current position in stream S, then
        saves it variables using PutSubViewPtr. }
      {#X Load DoubleDelayScrollBar RepeatDelayScrollBar }
      private
    OldDoubleDelay: Word;
      { OldDoubleDelay holds the value of the DoubleDelay variable when the
        dialog was created.  #Done# resets DoubleDelay to its original
        value. }
      {#X OldRepeatDelay OldReverse }
    OldRepeatDelay: Word;
      { OldRepeatDelay holds the value of the RepeatDelay variable when the
        dialog was created.  #Done# resets RepeatDelay to its original
        value. }
      {#X OldDoubleDelay OldReverse }
    OldReverse: Boolean;
      { OldReverse holds the state of the MouseReverse variable when the
        dialog was created.  #Done# resets MouseReverse to its original
        value. }
      {#X OldDoubleDelay OldRepeatDelay }
  end;  { of TMouseDlg }


  {#Z+}
  PMouseRec = ^TMouseRec;
  {#Z-}
  TMouseRec = record
    { A TMouseRec is used to set the subview values of a TMouseDlg. }
    DoubleDelay: Word;
      { DoubleDelay holds the value of the Drivers.DoubleDelay variable. }
      {#X RepeatDelay ReverseButtons }
    RepeatDelay: Word;
      { RepeatDelay holds the value of the Drivers.RepeatDelay variable. }
      {#X DoubleDelay ReverseButtons }
    ReverseButtons: LongInt;
      { ReverseButtons holds the value of the Drivers.MouseReverse variable. }
      {#X DoubleDelay RepeatDelay }
  end;  { of TMouseRec }


  {#Z+}
  PVideoDlg = ^TVideoDlg;
  {#Z-}
  TVideoDlg = Object(TDialog)
    LinesPerScreen: PRadioButtons;
    Markers: PCheckBoxes;
    Mode: PCommandRadioButtons;
    constructor Init;
    constructor Load (var S: TStream);
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure Store (var S: TStream); virtual;
  end;  { of TVideoDlg }


  {#Z+}
  PVideoRec = ^TVideoRec;
  {#Z-}
  TVideoRec = record
    LinesPerScreen: Word;
    Markers: Word; { if true puts markers around focused view }
    Mode: Word;
  end;  { oF TVideorec }

  PConfig = ^TConfig;
  TConfig = Object(TObject)
    { TConfig is the base application configuration for all TurboVision
      applications.  All settings are completely end user configurable
      through the methods of TConfig.  Descendant objects can be created to
      add new configuration file properties, such as a data directory.

      TConfig stores the system colors, mouse and video settings. }
    {#X TClockConfig TAlarmClockConfig }
    Modified: Boolean;
      { Modified signifies the status of the configuration settings.  If
        Modified is True the config file should be saved before it is
        destructed.  All descendant methods should change Modified to True
        whenever the user makes changes to the configuration which should be
        saved.  The application should check the status of Modified before
        disposing of the configuration object. }
    SaveDesktop: Boolean;
      { The file path and name for the desktop file. }
    constructor Init;
      { Init creates an instance of a TConfig with the default settings for
        all its variables.

        Init is normally used within installation applications. }
      {#X Load }
    constructor Load(var S: TStream);
      { Load reads all the configurations variables from the currentposition
        in the stream S.

        Load may be used in the application's #Init# constructor or by the
        #Open# method. }
      {#X Store }
    destructor Done; virtual;
    procedure Refresh; virtual;
      { Refresh is called by TApplication.ConfigOpen whenever a new
        configuration object is successfully loaded.  Refresh should update
        the application as needed to the new configuration parameters. }
    procedure SetColors;
      { SetColors prompts the user to edit the application's colors, then
        updates the application with the changes. }
    procedure SetMouse;
      { SetMouse prompts the user to change the current mouse speed,
        reversing button functions, and double click speed. }
    procedure SetVideo;
      { SetVideo prompts the user to change the current video settings for
        lines per screen, whether markers are shown, and the screen mode. }
    procedure Store(var S: TStream);
      { Store writes all the user defineable program variables to the current
        position in the stream S. }
      {#X Load }
  end;  { of TConfig }


function MakeColorsDlg: PColorDialog;
  { MakeColorsDlg returns a pointer to a dialog for setting the program's
    colors using the standard Turbo Vision terminology - dialogs, menu bars,
    buttons, status line, etc.

    When compiled using the cdResource conditional define MakeColorsDlg uses
    the Strings and Labels string lists to create the dialogs text. }
  {#X MaketvConfigResources TConfig.SetColors }

procedure MakeHints;
  { MakeHints creates an English version of status line hints for all the
    standard Free Vision library help contexts by calling each unit's
    MakeHints procedure.  The hints are placed in the Resource.Hints
    string list. }
  {#X MakeLabels MakeStrings TApplication.InitResources }

procedure MakeLabels;
  { MakeLabels creates an English version of all labels used in the App unit
    and places them in the Resource.Labels string list. }
  {#X MakeHints MakeStrings TApplication.InitResources }

procedure MakeResources;
  { MakeResources places all dialogs used by the Config unit on the specified
    resource file. }
  {#X MakeColorsDlg }

procedure MakeStrings;
  { MakeStrings creates an English version of all error and message strings
    used in the App unit.The strings are placed in the Resource.Strings
    string list. }
  {#X MakeHints MakeLabels TApplication.InitResources }

procedure RegisterConfig;
  { RegisterConfig registers all objects declared in the Configs unit
    for stream usage. }

function StdOptionsMenu (Next: PMenuItem): PMenuItem;
  { Returns a pointer to a menu for a standard application configuration
    opens.

    The standard options menu items are colors, Clock, Formats, Date and Time,
    Mouse, Video, Open, Save, and Save As. }
  {#X StdOptionsMenuItems StdOptionsStatusDef StdOptionsStatusKeys }

function StdOptionsMenuItems (Next: PMenuItem): PMenuItem;
  { Returns a pointer to a list of menu items for a standard options menu.
    It can use the list either as the entire menu, or as part of a larger
    list of items.

    The standard options menu items are Colors, Clock, Formats, Date and Time,
    Mouse, Video, Open, Save, and Save As. }
  {#X StdOptionsMenuItems StdOptionsStatusDef StdOptionsStatusKeys }

function StdOptionsStatusDef (Next: PStatusDef): PStatusDef;
  { Returns a pointer to a status line definition which uses the
    #StdOptionsStatusKeys# to define the status line items.  The help
    constants for all InterMind Turbo Vision Library help contexts are
    included. }

function StdOptionsStatusKeys (Next: PStatusItem): PStatusItem;
  { Returns a pointer to a linked list of status line keys which.

    You can append StdOptionsStatusKeys to your user-defined status line
    definitions to ensure that all your status lines maintain the standard
    command and key bindings.

    The statusline definition only displays a 'F1 Help' text for use with
    status line hints. }
  {#X StdOptionsStatusDef }


const
  MouseCommands: TCommandSet = [cmConfigMouse];
    { MouseCommands is a global variable which is used to disable all mouse
      setting menu commands when a mouse is not installed. }


const
  RConfig: TStreamRec = (
    ObjType: idConfig;
    VmtLink: Ofs(TypeOf(TConfig)^);
    Load: @TConfig.Load;
    Store: @TConfig.Store);

  RMouseDlg: TStreamRec = (
    Objtype: idMouseDlg;
    VmtLink: Ofs(TypeOf(TMouseDlg)^);
    Load   : @TMouseDlg.Load;
    Store  : @TMouseDlg.Store);

  RVideoDlg: TStreamRec = (
    Objtype: idVideoDlg;
    VmtLink: Ofs(TypeOf(TVideoDlg)^);
    Load   : @TVideoDlg.Load;
    Store  : @TVideoDlg.Store);

  RClickTester: TStreamRec = (
    Objtype: idClickTester;
    VmtLink: Ofs(typeOf(TClickTester)^);
    Load   : @TClickTester.Load;
    Store  : @TClickTester.Store);


implementation

uses
  HelpCtx, Memory, Resource, App;
  { Resource, MsgBox, StdDlg, Strings,
  tlString; }

{****************************************************************************}
{ TClickTester Object                                                        }
{****************************************************************************}
{****************************************************************************}
{ TClickTester.Init                                                          }
{****************************************************************************}
constructor TClickTester.Init (var Bounds: TRect; AText: String);
begin
  TStaticText.Init(Bounds,AText);
  Clicked := False;
end;

{****************************************************************************}
{ TClickTester.GetPalette                                                    }
{****************************************************************************}
function TClickTester.GetPalette: PPalette;
const
  P: String[Length(CClickTester)] = CClickTester;
begin
  GetPalette := PPalette(@P);
end;

{****************************************************************************}
{ TClickTester.HandleEvent                                                   }
{****************************************************************************}
procedure TClickTester.HandleEvent (var Event: TEvent);
begin
  TStaticText.HandleEvent(Event);
  if (Event.What = evMouseDown)
     then begin
            if Event.Double
               then begin
                      Clicked := NOT Clicked;
                      DrawView;
                    end;
            ClearEvent(Event);
          end;
end;

{****************************************************************************}
{ TClickTester.Draw                                                          }
{****************************************************************************}
procedure TClickTester.Draw;
var
  B: TDrawBuffer;
  C: Byte;
begin
  if Clicked
     then C := GetColor(2)
     else C := GetColor(1);
  MoveChar(B,' ',C,Size.X);
  MoveStr(B,Text^,C);
  WriteLine(0,0,Size.X,1,B);
end;

{****************************************************************************}
{ TConfig Object                                                             }
{****************************************************************************}
{****************************************************************************}
{ TConfig.Init                                                               }
{****************************************************************************}
constructor TConfig.Init;
begin
  if not inherited Init then
    Fail;
  Modified := True;
  SaveDesktop := True;
end;

{****************************************************************************}
{ TConfig.Load                                                               }
{****************************************************************************}
constructor TConfig.Load(var S: TStream);
var
  Pal: PPalette;
begin
  if (not TObject.Init) then
    Fail;
  S.Read(DoubleDelay,SizeOf(DoubleDelay));
  S.Read(RepeatDelay,SizeOf(RepeatDelay));
  S.Read(MouseReverse,SizeOf(MouseReverse));
  S.Read(CheckSnow,SizeOf(CheckSnow));
  S.Read(ShowMarkers,SizeOf(ShowMarkers));
  Pal := PPalette(S.ReadStr);
  S.Read(SaveDesktop,SizeOf(SaveDesktop));
  if (Pal = nil) or (S.Status <> stOk) then
  begin
    DisposeStr(Pal);
    TObject.Done;
    Fail;
  end;
  Application^.GetPalette^ := Pal^;
  DisposeStr(PString(Pal));
  DoneMemory;
  Application^.ReDraw;
  Modified := False;
end;

{****************************************************************************}
{ TConfig.Done                                                               }
{****************************************************************************}
destructor TConfig.Done;
begin
  inherited Done;
end;

{****************************************************************************}
{ TConfig.Refresh                                                            }
{****************************************************************************}
procedure TConfig.Refresh;
begin
  if SaveDesktop then
    Message(Application,evCommand,cmDesktopLoad,nil);
end;

{****************************************************************************}
{ TConfig.SetColors                                                          }
{****************************************************************************}
procedure TConfig.SetColors;
var
  Dlg: PColorDialog;
  Pal: TPalette;
begin
  {$ifdef cdResource}
  Dlg := PColorDialog(RezFile^.Get(reColorsDlg));
  {$else}
  Dlg := MakeColorsDlg;
  {$endif cdResource}
  Pal := Application^.GetPalette^;
  if (Application^.ExecuteDialog(Dlg,@Pal) = cmOk) then
  begin
    Application^.GetPalette^ := Pal;
    DoneMemory;
    Application^.ReDraw;
    Modified := True;
  end;
  if (ColorIndexes <> nil) then
  begin
    FreeMem(ColorIndexes,SizeOf(ColorIndexes));
    ColorIndexes := nil;
  end;
end;

{****************************************************************************}
{ TConfig.SetMouse                                                           }
{****************************************************************************}
procedure TConfig.SetMouse;
var
  Dlg: PMouseDlg;
  Rec: TMouseRec;
begin
  {$ifdef cdResource}
  Dlg := PMouseDlg(RezFile^.Get(reMouseDlg));
  {$else}
  Dlg := New(PMouseDlg,Init);
  {$endif cdResource}
  Rec.DoubleDelay := DoubleDelay;
  Rec.RepeatDelay := RepeatDelay;
  Rec.ReverseButtons := Byte(MouseReverse);
  if (Application^.ExecuteDialog(Dlg,@Rec) = cmOk) then
  begin
    DoubleDelay := Rec.DoubleDelay;
    RepeatDelay := Rec.RepeatDelay;
    MouseReverse := (Rec.ReverseButtons > 0);
    Modified := True;
  end;
end;

{****************************************************************************}
{ TConfig.SetVideo                                                           }
{****************************************************************************}
procedure TConfig.SetVideo;
var
  Dlg: PVideoDlg;
  Rec: TVideorec;
  LocalStartMode: Word;
begin
  {$ifdef cdResource}
  Dlg := PVideoDlg(RezFile^.Get(reVideoDlg));
  {$else}
  Dlg := New(PVideoDlg,Init);
  {$endif cdResource}
  LocalStartMode := ScreenMode;
  Rec.LinesPerScreen := Ord((ScreenMode and smFont8x8) = smFont8x8);
  Rec.Markers := Ord(ShowMarkers);
  if CheckSnow then
     Rec.Markers := Rec.Markers or $02;
  case ScreenMode and (not smFont8x8) of
    smCO80: Rec.Mode := 0;
    smBW80: Rec.Mode := 1;
    smMono: Rec.Mode := 2;
  end;
  if (Application^.ExecuteDialog(Dlg,@Rec) = cmOk) then
    Modified := True
  else begin  { reset to starting parameters }
    Application^.SetScreenMode(LocalStartMode);
    Application^.Redraw;
    CheckSnow := (Rec.Markers and $02 > 0);
    ShowMarkers := (Rec.Markers and $01 > 0);
  end;
end;

{****************************************************************************}
{ TConfig.Store                                                              }
{****************************************************************************}
procedure TConfig.Store(var S: TStream);
var
  Pal: PString;
begin
  S.Write(DoubleDelay,SizeOf(DoubleDelay));
  S.Write(RepeatDelay,SizeOf(RepeatDelay));
  S.Write(MouseReverse,SizeOf(MouseReverse));
  S.Write(CheckSnow,SizeOf(CheckSnow));
  S.Write(ShowMarkers,SizeOf(ShowMarkers));
  Pal := @Application^.GetPalette^;
  S.WriteStr(Pal);
  S.Write(SaveDesktop,SizeOf(SaveDesktop));
end;

{****************************************************************************}
{ TDesktopDlg Object                                                         }
{****************************************************************************}
{****************************************************************************}
{ TDesktopDlg.Init                                                           }
{****************************************************************************}
constructor TDesktopDlg.Init;
var R: TRect;
    Control: PView;
begin
  R.Assign(0,0,30,9);
  if not TDialog.Init(R,'Desktop Options') then
    Fail;
  Options := Options or ofCentered;
  HelpCtx := hcConfigDesktopDlg;

  R.Assign(2, 3, 15, 6);
  Control := New(PRadioButtons, Init(R,
    NewSItem('~A~lways',
    NewSItem('~N~ever',
    NewSItem('~P~rompt',
    NIL)))));
  Insert(Control);
  R.Assign(1, 2, 14, 3);
  Insert(New(PLabel, Init(R, '~S~ave Desktop', Control)));

  NewButton(16,2,10,2,'O~k~',cmOK,hcOk,bfDefault);
  NewButton(16,4,10,2,'Cancel',cmCancel,hcCancel,bfNormal);
  NewButton(16,6,10,2,'~H~elp',cmHelp,hcNoContext,bfNormal);

  SelectNext(False);
end;

{****************************************************************************}
{ TMouseDlg Object                                                           }
{****************************************************************************}
{****************************************************************************}
{ TMouseDlg.Init                                                             }
{****************************************************************************}
constructor TMouseDlg.Init;
var
  R: TRect;
begin
  R.Assign(0,0,34,12);
  {$ifdef cdResource}
  if not TDialog.Init(R,Strings^.Get(sMouseOptions)) then
  {$else}
  if not TDialog.Init(R,'Mouse Options') then
  {$endif cdResource}
    Fail;
  Options := Options or ofCentered;
  HelpCtx := hcConfigMouseDlg;
  OldDoubleDelay := DoubleDelay;
  OldRepeatDelay := RepeatDelay;
  OldReverse := MouseReverse;
    { Insert scrollbar to adjust DoubleDelay click rate }
  R.Assign(3,2,30,3);
  DoubleDelayScrollBar := New(PScrollBar,Init(R));
  DoubleDelayScrollBar^.SetParams(DoubleDelay,1,20,1,1);
  DoubleDelayScrollBar^.Options := DoubleDelayScrollBar^.Options or ofSelectable;
  DoubleDelayScrollBar^.SetValue(DoubleDelay);
  Insert(DoubleDelayScrollBar);
  R.Assign(2,1,21,2);
  {$ifdef cdResource}
  Insert(New(PLabel,Init(R,Strings^.Get(slMouseDoubleClick),DoubleDelayScrollBar)));
  {$else}
  Insert(New(PLabel,Init(R,'~D~ouble Click',DoubleDelayScrollBar)));
  {$endif cdResource}

    { Insert scrollbar to adjust RepeatDelay rate }
  R.Assign(3,5,30,6);
  RepeatDelayScrollBar := New(PScrollBar,Init(R));
  RepeatDelayScrollBar^.SetParams(RepeatDelay,1,20,1,1);
  RepeatDelayScrollBar^.Options := RepeatDelayScrollBar^.Options or ofSelectable;
  RepeatDelayScrollBar^.SetValue(DoubleDelay);
  Insert(RepeatDelayScrollBar);
  R.Assign(2,4,21,5);
  {$ifdef cdResource}
  Insert(New(PLabel,Init(R,Strings^.Get(slMouseRepeatClick),RepeatDelayScrollBar)));
  {$else}
  Insert(New(PLabel,Init(R,'~R~epeat Delay',RepeatDelayScrollBar)));
  {$endif cdResource}

    { Insert check box for reversing effect of mouse buttons }
  R.Assign(3,7,30,8);
  {$ifdef cdResource}
  Insert(New(PCheckBoxes,Init(R,
             NewSItem(Strings^.Get(slReverseButtons),nil))));
  {$else}
  Insert(New(PCheckBoxes,Init(R,NewSItem('Reverse ~B~uttons',nil))));
  {$endif cdResource}

  {$ifdef cdResource}
  NewButton(2,9,10,2,Labels^.Get(slOk),cmOk,hcOk,bfDefault);
  NewButton(12,9,10,2,Labels^.Get(slCancel),cmCancel,hcCancel,bfNormal);
  NewButton(22,9,10,2,Labels^.Get(slHelp),cmHelp,hcNoContext,bfNormal);
  {$else}
  NewButton(2,9,10,2,'O~k~',cmOk,hcOk,bfDefault);
  NewButton(12,9,10,2,'Cancel',cmCancel,hcCancel,bfNormal);
  NewButton(22,9,10,2,'~H~elp',cmHelp,hcNoContext,bfNormal);
  {$endif cdResource}
  SelectNext(False);
end;

{****************************************************************************}
{ TMouseDlg.Load                                                             }
{****************************************************************************}
constructor TMouseDlg.Load (var S: TStream);
begin
  TDialog.Load(S);
  OldDoubleDelay := DoubleDelay;
  OldRepeatDelay := RepeatDelay;
  OldReverse := MouseReverse;
  GetSubViewPtr(S,DoubleDelayScrollBar);
  GetSubViewPtr(S,RepeatDelayScrollBar);
  if (S.Status <> stOk) or (DoubleDelayScrollBar = nil) or
     (RepeatDelayScrollBar = nil) then
  begin
    TDialog.Done;
    Fail;
  end;
  DoubleDelayScrollBar^.SetValue(DoubleDelay);
  RepeatDelayScrollBar^.SetValue(RepeatDelay);
end;

{****************************************************************************}
{ TMouseDlg.Done                                                             }
{****************************************************************************}
destructor TMouseDlg.Done;
begin
  DoubleDelay := OldDoubleDelay;
  RepeatDelay := OldRepeatDelay;
  MouseReverse := OldReverse;
  TDialog.Done;
end;

{****************************************************************************}
{ TMouseDlg.HandleEvent                                                      }
{****************************************************************************}
procedure TMouseDlg.HandleEvent (var Event: TEvent);
begin
  if (Event.What and evBroadcast > 0) and
     (Event.Command = cmScrollBarChanged) then
     if (Event.InfoPtr = DoubleDelayScrollBar) then
        begin
          DoubleDelay := DoubleDelayScrollBar^.Value;
          ClearEvent(Event);
        end
     else if (Event.InfoPtr = RepeatDelayScrollBar) then
             begin
               RepeatDelay := RepeatDelayScrollBar^.Value;
               ClearEvent(Event);
             end;
  TDialog.HandleEvent(Event);
end;

{****************************************************************************}
{ TMouseDlg.Store                                                            }
{****************************************************************************}
procedure TMouseDlg.Store (var S: TStream);
begin
  TDialog.Store(S);
  PutSubViewPtr(S,DoubleDelayScrollBar);
  PutSubViewPtr(S,RepeatDelayScrollBar);
end;

{****************************************************************************}
{ TVideoDlg Object                                                           }
{****************************************************************************}
{****************************************************************************}
{ TVideoDlg.Init                                                             }
{****************************************************************************}
constructor TVideoDlg.Init;
var
  R: TRect;
begin
  R.Assign(0,0,40,13);
  {$ifdef cdResource}
  if not TDialog.Init(R,Strings^.Get(sVideoOptions)) then
  {$else}
  if not TDialog.Init(R,'Video Options') then
  {$endif cdResource}
    Fail;
  Options := Options or ofCentered;
  HelpCtx := hcConfigVideo;
     { Create Screen Sizes Radio Buttons }
  R.Assign(2,2,25,4);
  LinesPerScreen := New(PRadioButtons,Init(R,
                 {$ifdef cdResource}
                 NewSItem(Strings^.Get(sl25Lines),
                 NewSItem(Strings^.Get(sl43or50Lines),
                 {$else}
                 NewSItem('~2~5 Lines',
                 NewSItem('~4~3/50 Lines',
                 {$endif cdResource}
                 nil))));
  Insert(LinesPerScreen);
  R.Assign(1,1,20,2);
  {$ifdef cdResource}
  Insert(New(PLabel,Init(R,Strings^.Get(slLinesPerScreen),LinesPerScreen)));
  {$else}
  Insert(New(PLabel,Init(R,'~L~ines Per Screen',LinesPerScreen)));
  {$endif cdResource}
    { insert toggle for using markers around focused field }
  R.Assign(2,5,25,7);
  Markers := New(PCheckBoxes,Init(R,
                 {$ifdef cdResource}
                 NewSItem(Strings^.Get(slShowMarkers),
                 NewSItem(Strings^.Get(slCheckSnow),
                 {$else}
                 NewSItem('~S~how Markers',
                 NewSItem('~C~heck Snow',
                 {$endif cdResource}
                 nil))));
  Insert(Markers);

  R.Assign(2,9,25,12);
  Mode := New(PCommandRadioButtons,Init(R,
              NewCommandSItem('Co~l~or',cmConfigCO80,
              NewCommandSItem('~B~W 80',cmConfigBW80,
              NewCommandSItem('Mo~n~ochrome',cmConfigMono,
              nil)))));
  Insert(Mode);
  R.Assign(1,8,6,9);
  Insert(New(PLabel,Init(R,'~M~ode',Mode)));

  {$ifdef cdResource}
  NewButton(27,2,10,2,Strings^.Get(slOk),cmOk,hcOk,bfDefault);
  NewButton(27,6,10,2,Strings^.Get(slCancel),cmCancel,hcCancel,bfNormal);
  NewButton(27,10,10,2,Strings^.Get(slHelp),cmHelp,hcNoContext,bfNormal);
  {$else}
  NewButton(27,2,10,2,'O~k~',cmOk,hcOk,bfDefault);
  NewButton(27,6,10,2,'Cancel',cmCancel,hcCancel,bfNormal);
  NewButton(27,10,10,2,'~H~elp',cmHelp,hcNoContext,bfNormal);
  {$endif cdResource}

  if HiResScreen then
    Markers^.EnableMask := 1  { ega or higher; don't need to check snow }
  else begin
    LinesPerScreen^.EnableMask := $0001;
    LinesPerScreen^.SetState(sfDisabled,True);
  end;
  if (ScreenMode and smMono <> 0) then
  begin
    Markers^.EnableMask := 1;  { monochrome; don't need to check snow }
    Mode^.EnableMask := $0003;
  end
  else Mode^.EnableMask := $0004;
  SelectNext(False);
end;

{****************************************************************************}
{ TVideoDlg.Load                                                             }
{****************************************************************************}
constructor TVideoDlg.Load (var S: TStream);
begin
  if not TDialog.Load(S) then
    Fail;
  GetSubViewPtr(S,LinesPerScreen);
  GetSubViewPtr(S,Markers);
  GetSubViewPtr(S,Mode);
  if HiResScreen then
    Markers^.EnableMask := 1  { ega or higher; don't need to check snow }
  else begin
    LinesPerScreen^.EnableMask := $0001;
    LinesPerScreen^.SetState(sfDisabled,True);
  end;
  if (ScreenMode and smMono <> 0) then
  begin
    Markers^.EnableMask := 1;  { monochrome; don't need to check snow }
    Mode^.EnableMask := $0003;
  end
  else Mode^.EnableMask := $0004;
end;

{****************************************************************************}
{ TVideoDlg.HandleEvent                                                      }
{****************************************************************************}
procedure TVideoDlg.HandleEvent (var Event: TEvent);
begin
  if (Event.What and evCommand > 0) then
    case Event.Command of
      cmConfigCO80:
        begin
          Application^.SetScreenMode((ScreenMode and smFont8x8) or smCO80);
          ClearEvent(Event);
          Application^.Redraw;
        end;
      cmConfigBW80:
        begin
          Application^.SetScreenMode((ScreenMode and smFont8x8) or smBW80);
          ClearEvent(Event);
          Application^.Redraw;
        end;
      cmConfigMono:
        begin
          Application^.SetScreenMode((ScreenMode and smFont8x8) or smMono);
          ClearEvent(Event);
          Application^.Redraw;
        end;
    end;
  TDialog.HandleEvent(Event);
  CheckSnow := (Markers^.Value and $02 > 0);
  if LinesPerScreen^.Value <> Ord((ScreenMode and smFont8x8) = smFont8x8)
     then if LinesPerScreen^.Value = 0
             then Application^.SetScreenMode(ScreenMode and (not smFont8x8))
             else Application^.SetScreenMode(ScreenMode or smFont8x8);
  if Boolean(Markers^.Value and $01) <> ShowMarkers
     then begin
            ShowMarkers := not ShowMarkers;
            ReDraw;
          end;
end;

{****************************************************************************}
{ TVideoDlg.Store                                                            }
{****************************************************************************}
procedure TVideoDlg.Store (var S: TStream);
begin
  TDialog.Store(S);
  PutSubViewPtr(S,LinesPerScreen);
  PutSubViewPtr(S,Markers);
  PutSubViewPtr(S,Mode);
end;

{****************************************************************************}
{                          Public Declarations                               }
{****************************************************************************}
{****************************************************************************}
{ MakeColorsDlg                                                              }
{****************************************************************************}
function MakeColorsDlg: PColorDialog;
begin
  MakeColorsDlg := New(PColorDialog,Init(Application^.GetPalette^,
    {$ifdef cdResource}
    ColorGroup(Strings^.Get(sBackground),DesktopColorItems(nil),
    ColorGroup(Strings^.Get(sMenus),MenuColorItems(nil),
    ColorGroup(Strings^.Get(sDialogs),DialogColorItems(dpGrayDialog,nil),
    ColorGroup(Strings^.Get(sWindows),WindowColorItems(wpBlueWindow,nil),
    {$else}
    ColorGroup('Background',DesktopColorItems(nil),
    ColorGroup('Menus',MenuColorItems(nil),
    ColorGroup('Dialogs',DialogColorItems(dpGrayDialog,nil),
    ColorGroup('Windows',WindowColorItems(wpBlueWindow,nil),
    {$endif cdResource}
    nil))))));
end;

{****************************************************************************}
{ MakeHints                                                                  }
{****************************************************************************}
procedure MakeHints;
begin
  with Resource.Hints^ do
  begin
  end;
end;

{****************************************************************************}
{ MakeLabels                                                                 }
{****************************************************************************}
procedure MakeLabels;
begin
  with Resource.Labels^ do
  begin
  end;
end;

{****************************************************************************}
{ MakeResources                                                              }
{****************************************************************************}
procedure MakeResources;
var
  Dlg: PDialog;
  {**************************************}
  procedure Stop (ExitString: String);
  begin
    if RezFile <> nil then
      Dispose(RezFile,Done);
    WriteLn;
    WriteLn(ExitString);
    Halt;
  end;
  {**************************************}
begin
    { Put Colors setting dialog on the screen }
  {$ifndef cdNoColors}
  Dlg := MakeColorsDlg;
  if Dlg <> nil
     then begin
            RezFile^.Put(Dlg,reColorsDlg);
            Dispose(Dlg,Done);
          end
     else Stop(reColorsDlg);
  {$endif cdNoColors}
    { Put Mouse setting dialog on the screen }
  Dlg := New(PMouseDlg,Init);
  if Dlg <> nil
     then begin
            RezFile^.Put(Dlg,reMouseDlg);
            Dispose(Dlg,Done);
          end
     else Stop(reMouseDlg);
    { Put Video setting dialog on the screen }
  Dlg := New(PVideoDlg,Init);
  if Dlg <> nil
     then begin
            RezFile^.Put(Dlg,reVideoDlg);
            Dispose(Dlg,Done);
          end
     else Stop(reVideoDlg);
end;

{****************************************************************************}
{ MakeStrings                                                                }
{****************************************************************************}
procedure MakeStrings;
begin
  with Resource.Strings^ do
  begin
  end;
end;

{****************************************************************************}
{ RegisterConfig                                                             }
{****************************************************************************}
procedure RegisterConfig;
begin
  RegisterColorSel;
  RegisterType(RMouseDlg);
  RegisterType(RVideoDlg);
  RegisterType(RClickTester);
  RegisterType(RConfig);
end;

{****************************************************************************}
{ StdOptionsMenu                                                             }
{****************************************************************************}
function StdOptionsMenu (Next: PMenuItem): PMenuItem;
begin
  StdOptionsMenu :=
     {$ifdef cdResource}
     NewSubMenu(Strings^.Get(slOptions),hcConfigMenu,NewMenu(
     {$else}
     NewSubMenu('~O~ptions',hcConfigMenu,NewMenu(
     {$endif cdResource}
        StdOptionsMenuItems(nil)),
        Next);
end;

{****************************************************************************}
{ StdOptionsMenuItems                                                        }
{****************************************************************************}
function StdOptionsMenuItems (Next: PMenuItem): PMenuItem;
begin
  StdOptionsMenuItems :=
     {$ifdef cdResource}
     NewSubMenu(Strings^.Get(slEnvironment),hcConfigEnvironment,NewMenu(
        NewItem(Strings^.Get(slColors),'',kbNoKey,cmConfigColors,
                hcConfigColors,
        NewItem(Strings^.Get(slMouse),'',kbNoKey,cmConfigMouse,
                hcConfigMouse,
        NewItem(Strings^.Get(slVideo),'',kbNoKey,cmConfigVideo,
                hcConfigVideo,
        nil))))),
     NewLine(
     NewItem(Strings^.Get(slOpen),'',kbNoKey,cmConfigOpen,hcConfigOpen,
     NewItem(Strings^.Get(slSave),'',kbNoKey,cmConfigSave,hcConfigSave,
     NewItem(Strings^.Get(slSaveAs),'',kbNoKey,cmConfigSaveAs,
             hcConfigSaveAs,
     {$else}
     NewSubMenu('~E~nvironment',hcConfigEnvironment,NewMenu(
        NewItem('~C~olors','',kbNoKey,cmConfigColors,hcConfigColors,
        NewItem('~M~ouse','',kbNoKey,cmConfigMouse,hcConfigMouse,
        NewItem('~V~ideo','',kbNoKey,cmConfigVideo,hcConfigVideo,
        nil)))),
     NewLine(
     NewItem('~O~pen','',kbNoKey,cmConfigOpen,hcConfigOpen,
     NewItem('~S~ave','',kbNoKey,cmConfigSave,hcConfigSave,
     NewItem('Save ~A~s...','',kbNoKey,cmConfigSaveAs,hcConfigSaveAs,
     {$endif cdResource}
     Next)))));
end;

{****************************************************************************}
{ StdOptionsStatusDef                                                        }
{****************************************************************************}
function StdOptionsStatusDef (Next: PStatusDef): PStatusDef;
begin
  StdOptionsStatusDef :=
     NewStatusDef(hcConfigMenu,1099,StdOptionsStatusKeys(nil),Next);
end;

{****************************************************************************}
{ StdOptionsStatusKeys                                                       }
{****************************************************************************}
function StdOptionsStatusKeys (Next: PStatusItem): PStatusItem;
begin
  StdOptionsStatusKeys :=
     {$ifdef cdResource}
     NewStatusKey('~F1~ ' + Strings^.Get(sHelp),kbF1,cmHelp,Next);
     {$else}
     NewStatusKey('~F1~ Help',kbF1,cmHelp,Next);
     {$endif cdResource}
end;

{****************************************************************************}
{                            Unit Initialization                             }
{****************************************************************************}
begin
end.
