{ To Do:
1. Determine values for constants - cmXXXX, idXXXX
2. Check all objects to be sure they work }
{#Z+}
{ Tools Library Dialogs Unit
  BitSoft Development, L.L.C.
  Copyright 1994, 1998
  http://www.bitsoft.com
  Version: 1.1

Revision History

1.1   (97/12/28)
   - updated to be part of the Tools Library

1.0   (1994)
  - original implementation }
{#Z-}

unit fvList;

{$i platform.inc}

{$ifdef PPC_FPC}
  {$H-}
{$else}
  {$F+,O+,E+,N+}
{$endif}
{$X+,R-,I-,Q-,V-}
{$ifndef OS_LINUX}
  {$S-}
{$endif}

interface

uses
  Objects, Validate, Drivers, Views, Dialogs, StdDlg,
  bvTypes, bvDlgs;

const
    { ldXXXX constants  }
  ldNone        = $0000;
  ldNew         = $0001;
  ldEdit        = $0002;
  ldDelete      = $0004;
  ldNewEditDelete = ldNew or ldEdit or ldDelete;
  ldHelp        = $0008;
  ldAllButtons  = ldNew or ldEdit or ldDelete or ldHelp;
  ldNewIcon     = $0010;
  ldEditIcon    = $0020;
  ldDeleteIcon  = $0040;
  ldAllIcons    = ldNewIcon or ldEditIcon or ldDeleteIcon;
  ldAll         = ldAllIcons or ldAllButtons;
  ldNoFrame     = $0080;
  ldNoScrollBar = $0100;


type
  PListDlg = ^TListDlg;
  TListDlg = object(TbvDialog)
    { TListDlg displays a listbox of items, with optional New, Edit, and
      Delete buttons displayed according to the options bit set in the
      dialog.  Use the ofXXXX flags declared in this unit OR'd with the
      standard ofXXXX flags to set the appropriate bits in Options.

      If enabled, when the New or Edit buttons are pressed, an evCommand
      message is sent to the application with a Command value of NewCommand
      or EditCommand, respectively.  Using this mechanism in combination with
      the declared Init parameters, a standard TListDlg can be used with any
      type of list displayable in a TListBox or its descendant. }
    NewCommand: Word;
    EditCommand: Word;
    ListBox: PbvListBox;
    ldOptions: Word;
    constructor Init (ATitle: TTitleStr; Items: string; AButtons: Word;
      AListBox: PbvListBox; AEditCommand, ANewCommand: Word);
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream); virtual;
  end;  { of TListDlg }


  PEditListBox = ^TEditListBox;
  TEditListBox = Object(TbvListBox)
    CurrentField : Integer;
    constructor Init (Bounds : TRect; ANumCols: Word;
      AVScrollBar : PScrollBar);
    constructor Load (var S : TStream);
    function  FieldValidator : PValidator; virtual;
    function  FieldWidth : Integer; virtual;
    procedure GetField (InputLine : PInputLine); virtual;
    function  GetPalette : PPalette; virtual;
    procedure HandleEvent (var Event : TEvent); virtual;
    procedure SetField (InputLine : PInputLine); virtual;
    function  StartColumn : Integer; virtual;
      PRIVATE
    procedure EditField (var Event : TEvent);
  end;  { of TEditListBox }


  PModalInputLine = ^TModalInputLine;
  TModalInputLine = Object(TbvInputLine)
    function  Execute : Word; virtual;
    procedure HandleEvent (var Event : TEvent); virtual;
    procedure SetState (AState : Word; Enable : Boolean); virtual;
      private
    EndState : Word;
  end;  { of TModalInputLine }


  PCommandIcon = ^TCommandIcon;
  TCommandIcon = Object(TStaticText)
    { A TCommandIcon is used to display text that can be clicked on with the
      mouse and generate a command.  It is used internally in this unit for
      creating Ins and Del icons in TPick dialogs, but can be used in any
      dialog. }
    Command: Word;
    {$ifdef Ver60}
    constructor Init (var Bounds: TRect; AText: string; ACommand: Word);
    {$else}
    constructor Init (var Bounds: TRect; const AText: string; ACommand:
      Word);
    {$endif Ver60}
    constructor Load(var S: TStream);
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure Store(var S: TStream); virtual;
  end;  { of TCommandIcon }

  TCommandIconRec = record
    Text: string;
    Command: Word;
  end;


const
  REditListBox : TStreamRec = (
    ObjType : idEditListBox;
    VmtLink : Ofs(TypeOf(TEditListBox)^);
    Load    : @TEditListBox.Load;
    Store   : @TEditListBox.Store);

  RListDlg : TStreamRec = (
    ObjType : idListDlg;
    VmtLink : Ofs(TypeOf(TListDlg)^);
    Load    : @TListDlg.Load;
    Store   : @TListDlg.Store);

  RModalInputLine : TStreamRec = (
    ObjType : idModalInputLine;
    VmtLink : Ofs(TypeOf(TModalInputLine)^);
    Load    : @TModalInputLine.Load;
    Store   : @TModalInputLine.Store);

  RCommandIcon : TStreamRec = (
    ObjType : idCommandIcon;
    VmtLink : Ofs(TypeOf(TCommandIcon)^);
    Load    : @TCommandIcon.Load;
    Store   : @TCommandIcon.Store);


    { Global Procedures and Functions }
procedure Register;

implementation

uses
  App,
  bvHlpCtx, bvCmds, bvViews;

{****************************************************************************}
{ TCommandIcon Object                                                        }
{****************************************************************************}
{****************************************************************************}
{ TCommandIcon.Init                                                          }
{****************************************************************************}
{$ifdef Ver60}
constructor TCommandIcon.Init (var Bounds: TRect; AText: string; ACommand:
  Word);
{$else}
constructor TCommandIcon.Init (var Bounds: TRect; const AText: string;
  ACommand: Word);
{$endif Ver60}
begin
  TStaticText.Init(Bounds,AText);
  Options := Options or ofPostProcess;
  Command := ACommand;
end;

{****************************************************************************}
{ TCommandIcon.Load                                                          }
{****************************************************************************}
constructor TCommandIcon.Load(var S: TStream);
begin
  if not TStaticText.Load(S) then
    Fail;
  S.Read(Command,SizeOf(Command));
end;

{****************************************************************************}
{ TCommandIcon.HandleEvent                                                   }
{****************************************************************************}
procedure TCommandIcon.HandleEvent (var Event: TEvent);
begin
  if ((Event.What = evKeyDown) and (CtrlToArrow(Event.KeyCode) = kbIns)) or
     ((Event.What = evMouseDown) and MouseInView(MouseWhere)) then
  begin
    ClearEvent(Event);
    Message(Owner,evCommand,Command,@Self);
  end;
  TStaticText.HandleEvent(Event);
end;

{****************************************************************************}
{ TCommandIcon.Store                                                         }
{****************************************************************************}
procedure TCommandIcon.Store(var S: TStream);
begin
  TStaticText.Store(S);
  S.Write(Command,SizeOf(Command));
end;

{****************************************************************************}
{ TEditListBox Object                                                        }
{****************************************************************************}
{****************************************************************************}
{ TEditListBox.Init                                                          }
{****************************************************************************}
constructor TEditListBox.Init (Bounds : TRect; ANumCols: Word;
                               AVScrollBar : PScrollBar);

begin
  if not inherited Init(Bounds,ANumCols,AVScrollBar)
     then Fail;
  CurrentField := 1;
end;

{****************************************************************************}
{ TEditListBox.Load                                                          }
{****************************************************************************}
constructor TEditListBox.Load (var S : TStream);
begin
  if not inherited Load(S)
     then Fail;
  CurrentField := 1;
end;

{****************************************************************************}
{ TEditListBox.EditField                                                     }
{****************************************************************************}
procedure TEditListBox.EditField (var Event : TEvent);
var R : TRect;
    InputLine : PModalInputLine;
    Data : String;
begin
  R.Assign(StartColumn,(Origin.Y + Focused - TopItem),
           (StartColumn + FieldWidth + 2),(Origin.Y + Focused - TopItem + 1));
  Owner^.MakeGlobal(R.A,R.A);
  Owner^.MakeGlobal(R.B,R.B);
  InputLine := New(PModalInputLine,Init(R,FieldWidth));
  InputLine^.SetValidator(FieldValidator);
  if InputLine <> nil
     then begin
              { Use TInputLine^.SetData so that data validation occurs }
              { because TInputLine.Data is allocated memory large enough  }
              { to hold a string of MaxLen.  It is also faster.           }
            GetField(InputLine);
            if (Application^.ExecView(InputLine) = cmOk)
               then SetField(InputLine);
            Dispose(InputLine,done);
          end;
end;

{****************************************************************************}
{ TEditListBox.FieldValidator                                                }
{****************************************************************************}
function TEditListBox.FieldValidator : PValidator;
  { In a multiple field listbox FieldWidth should return the width  }
  { appropriate for Field.  The default is an inputline for editing }
  { a string of length large enough to fill the listbox field.      }
begin
  FieldValidator := nil;
end;

{****************************************************************************}
{ TEditListBox.FieldWidth                                                    }
{****************************************************************************}
function TEditListBox.FieldWidth : Integer;
  { In a multiple field listbox FieldWidth should return the width }
  { appropriate for CurrentField.                                  }
begin
  FieldWidth := Size.X - 2;
end;

{****************************************************************************}
{ TEditListBox.GetField                                                      }
{****************************************************************************}
procedure TEditListBox.GetField (InputLine : PInputLine);
  { Places a string appropriate to Field and Focused into InputLine that }
  { will be edited.   Override this method for complex data types.       }
begin
  InputLine^.SetData(PString(List^.At(Focused))^);
end;

{****************************************************************************}
{ TEditListBox.GetPalette                                                    }
{****************************************************************************}
function TEditListBox.GetPalette : PPalette;
begin
  GetPalette := inherited GetPalette;
end;

{****************************************************************************}
{ TEditListBox.HandleEvent                                                   }
{****************************************************************************}
procedure TEditListBox.HandleEvent (var Event : TEvent);
begin
  if (Event.What = evKeyboard) and (Event.KeyCode = kbAltE)
     then begin  { edit field }
            EditField(Event);
            DrawView;
            ClearEvent(Event);
          end;
  inherited HandleEvent(Event);
end;

{****************************************************************************}
{ TEditListBox.SetField                                                      }
{****************************************************************************}
procedure TEditListBox.SetField (InputLine : PInputLine);
  { Override this method for field types other than PStrings. }
var Item : PString;
begin
  Item := NewStr(InputLine^.Data^);
  if Item <> nil
     then begin
            List^.AtFree(Focused);
            List^.Insert(Item);
            SetFocusedItem(Item);
          end;
end;

{****************************************************************************}
{ TEditListBox.StartColumn                                                   }
{****************************************************************************}
function TEditListBox.StartColumn : Integer;
begin
  StartColumn := Origin.X;
end;

{****************************************************************************}
{ TListDlg Object                                                            }
{****************************************************************************}
{****************************************************************************}
{ TListDlg.Init                                                              }
{****************************************************************************}
constructor TListDlg.Init (ATitle : TTitleStr; Items:
  String; AButtons: Word; AListBox: PbvListBox; AEditCommand, ANewCommand :
  Word);
var
  Bounds: TRect;
  b: Byte;
  ButtonCount: Byte;
  i, j, Gap, Line: Integer;
  Scrollbar: PScrollbar;
  HasFrame: Boolean;
  HasButtons: Boolean;
  HasScrollBar: Boolean;
  HasItems: Boolean;
begin
  if AListBox = nil then
    Fail
  else
    ListBox := AListBox;
  HasFrame := ((AButtons and ldNoFrame) = 0);
  HasButtons := ((AButtons and ldAllButtons) <> 0);
  HasScrollBar := ((AButtons and ldNoScrollBar) = 0);
  HasItems := (Items <> '');
  ButtonCount := 2;
  for b := 0 to 3 do
    if (AButtons and ($0001 shl 1)) <> 0 then
      Inc(ButtonCount);
    { Make sure dialog is large enough for buttons }
  ListBox^.GetExtent(Bounds);
  Bounds.Move(ListBox^.Origin.X,ListBox^.Origin.Y);
  if HasFrame then
  begin
    Inc(Bounds.B.X,2);
    Inc(Bounds.B.Y,2);
  end;
  if HasButtons then
  begin
    Inc(Bounds.B.X,14);
    if Bounds.B.Y < (ButtonCount * 2) + 4 then
      Bounds.B.Y := (ButtonCount * 2) + 5;
  end;
  if HasItems then
    Inc(Bounds.B.Y,1);
  if not TDialog.Init(Bounds,ATitle) then
    Fail;
  NewCommand := ANewCommand;
  EditCommand := AEditCommand;
  Options := Options or ofNewEditDelete;
  if (not HasFrame) and (Frame <> nil) then
  begin
    Delete(Frame);
    Dispose(Frame,Done);
    Frame := nil;
    Options := Options and not ofFramed;
  end;
  HelpCtx := hcListDlg;
    { position and insert ListBox }
  ListBox := AListBox;
  Insert(ListBox);
  if HasItems then
    if HasFrame then
      ListBox^.MoveTo(2,2)
    else ListBox^.MoveTo(0,2)
  else
    if HasFrame then
      ListBox^.MoveTo(1,1)
    else ListBox^.MoveTo(0,0);
  if HasButtons then
    if ListBox^.Size.Y < (ButtonCount * 2) then
      ListBox^.GrowTo(ListBox^.Size.X,ButtonCount * 2);
    { do Items }
  if HasItems then
  begin
    Bounds.Assign(1,1,CStrLen(Items)+2,2);
    Insert(New(PLabel,Init(Bounds,Items,ListBox)));
  end;
    { do scrollbar }
  if HasScrollBar then
  begin
    Bounds.Assign(ListBox^.Size.X+ListBox^.Origin.X,ListBox^.Origin.Y,
      ListBox^.Size.X + ListBox^.Origin.X + 1,
      ListBox^.Size.Y + ListBox^.Origin.Y { origin });
    ScrollBar := New(PScrollBar,Init(Bounds));
    Bounds.Assign(Origin.X,Origin.Y,Origin.X + Size.X + 1, Origin.Y + Size.Y);
    ChangeBounds(Bounds);
    Insert(Scrollbar);
  end;
  if HasButtons then
  begin  { do buttons }
    j := $0001;
    Gap := 0;
    for i := 0 to 3 do
      if ((j shl i) and AButtons) <> 0 then
        Inc(Gap);
    Gap := ((Size.Y - 2) div (Gap + 2));
    if Gap < 2 then
      Gap := 2;
      { Insert Buttons }
    Line := 2;
    if (AButtons and ldNew) = ldNew then
    begin
      Insert(NewButton(Size.X - 12,Line,10,2,'~N~ew',cmNew,hcInsert,bfNormal));
      Inc(Line,Gap);
    end;
    if (AButtons and ldEdit) = ldEdit then
    begin
      Insert(NewButton(Size.X - 12,Line,10,2,'~E~dit',cmEdit,hcEdit,
        bfNormal));
      Inc(Line,Gap);
    end;
    if (AButtons and ldDelete) = ldDelete then
    begin
      Insert(NewButton(Size.X - 12,Line,10,2,'~D~elete',cmDelete,hcDelete,
        bfNormal));
      Inc(Line,Gap);
    end;
    Insert(NewButton(Size.X - 12,Line,10,2,'O~k~',cmOK,hcOk,bfDefault or
      bfNormal));
    Inc(Line,Gap);
    Insert(NewButton(Size.X - 12,Line,10,2,'Cancel',cmCancel,hcCancel,
      bfNormal));
    if (AButtons and ldHelp) = ldHelp then
    begin
      Inc(Line,Gap);
      Insert(NewButton(Size.X - 12,Line,10,2,'~H~elp',cmHelp,hcNoContext,
        bfNormal));
    end;
  end;
  if HasFrame and ((AButtons and ldAllIcons) <> 0) then
  begin
    Line := 2;
    if (AButtons and ldNewIcon) = ldNewIcon then
    begin
      Bounds.Assign(Line,Size.Y-1,Line+5,Size.Y);
      Insert(New(PCommandIcon,Init(Bounds,' Ins ',cmNew)));
      Inc(Line,5);
      if (AButtons and (ldEditIcon or ldDeleteIcon)) <> 0 then
      begin
        Bounds.Assign(Line,Size.Y-1,Line+1,Size.Y);
        Insert(New(PStaticText,Init(Bounds,'/')));
        Inc(Line,1);
      end;
    end;
    if (AButtons and ldEditIcon) = ldEditIcon then
    begin
      Bounds.Assign(Line,Size.Y-1,Line+6,Size.Y);
      Insert(New(PCommandIcon,Init(Bounds,' Edit ',cmEdit)));
      Inc(Line,6);
      if (AButtons and ldDeleteIcon) <> 0 then
      begin
        Bounds.Assign(Line,Size.Y-1,Line+1,Size.Y);
        Insert(New(PStaticText,Init(Bounds,'/')));
        Inc(Line,1);
      end;
    end;
    if (AButtons and ldNewIcon) = ldNewIcon then
    begin
      Bounds.Assign(Line,Size.Y-1,Line+5,Size.Y);
      Insert(New(PCommandIcon,Init(Bounds,' Del ',cmDelete)));
    end;
  end;
    { Set focus to list boLine when dialog opens }
  SelectNext(False);
end;

{****************************************************************************}
{ TListDlg.Load                                                              }
{****************************************************************************}
constructor TListDlg.Load (var S : TStream);
begin
  if not TDialog.Load(S) then
    Fail;
  S.Read(NewCommand,SizeOf(NewCommand) + SizeOf(EditCommand));
  GetSubViewPtr(S,ListBox);
end;

{****************************************************************************}
{ TListDlg.HandleEvent                                                       }
{****************************************************************************}
procedure TListDlg.HandleEvent (var Event : TEvent);
const
  TargetCommands: TCommandSet = [cmNew, cmEdit, cmDelete];
begin
  if ((Event.What and evCommand) <> 0) and
     (Event.Command in TargetCommands) then
  case Event.Command of
    cmDelete:
      if Options and ofDelete = ofDelete then
      begin
        ListBox^.FreeFocusedItem;
        ListBox^.DrawView;
        ClearEvent(Event);
      end;
    cmNew:
      if Options and ofNew = ofNew then
      begin
        Message(Application,evCommand,NewCommand,nil);
        ListBox^.SetRange(ListBox^.List^.Count);
        ListBox^.DrawView;
        ClearEvent(Event);
      end;
    cmEdit:
      if Options and ofEdit = ofEdit then
      begin
        Message(Application,evCommand,EditCommand,ListBox^.GetFocusedItem);
        ListBox^.DrawView;
        ClearEvent(Event);
      end;
  end;
  if (Event.What and evBroadcast > 0) and
     (Event.Command = cmListItemSelected) then
  begin  { use PutEvent instead of Message so that a window list box works }
    Event.What := evCommand;
    Event.Command := cmOk;
    Event.InfoPtr := nil;
    PutEvent(Event);
  end;
  TDialog.HandleEvent(Event);
end;

{****************************************************************************}
{ TListDlg.Store                                                             }
{****************************************************************************}
procedure TListDlg.Store (var S : TStream);
begin
  TDialog.Store(S);
  S.Write(NewCommand,SizeOf(NewCommand) + SizeOf(EditCommand));
  PutSubViewPtr(S,ListBox);
end;

{****************************************************************************}
{ TModalInputLine Object                                                     }
{****************************************************************************}
{****************************************************************************}
{ TModalInputLine.Execute                                                    }
{****************************************************************************}
function TModalInputLine.Execute : Word;
var Event : TEvent;
begin
  repeat
    EndState := 0;
    repeat
      GetEvent(Event);
      HandleEvent(Event);
      if Event.What <> evNothing
         then Owner^.EventError(Event);  { may change this to ClearEvent }
    until (EndState <> 0);
  until Valid(EndState);
  Execute := EndState;
end;

{****************************************************************************}
{ TModalInputLine.HandleEvent                                                }
{****************************************************************************}
procedure TModalInputLine.HandleEvent (var Event : TEvent);
begin
  case Event.What of
    evKeyboard : case Event.KeyCode of
                   kbUp, kbDown : EndModal(cmCancel);
                   kbEnter : EndModal(cmOk);
                   else inherited HandleEvent(Event);
                 end;
    evMouse : if MouseInView(Event.Where)
                 then inherited HandleEvent(Event)
                 else EndModal(cmCancel);
    else inherited HandleEvent(Event);
  end;
end;

{****************************************************************************}
{ TModalInputLine.SetState                                                   }
{****************************************************************************}
procedure TModalInputLine.SetState (AState : Word; Enable : Boolean);
var Pos : Integer;
begin
  if (AState = sfSelected)
     then begin
            Pos := CurPos;
            inherited SetState(AState,Enable);
            CurPos := Pos;
            SelStart := CurPos;
            SelEnd := CurPos;
            BlockCursor;
            DrawView;
          end
     else inherited SetState(AState,Enable);
end;

{****************************************************************************}
{                     Global Procedures and Functions                        }
{****************************************************************************}
{****************************************************************************}
{ Register                                                                   }
{****************************************************************************}
procedure Register;
begin
  RegisterType(REditListBox);
  RegisterType(RModalInputLine);
  RegisterType(RListDlg);
end;

{****************************************************************************}
{                             Unit Initialization                            }
{****************************************************************************}
begin
end.
