{
  System independent mouse interface for linux with svgalib
  There is no mouse cursor support in this mode.
  Maintainer: Matthias Koeppe <mkoeppe@moose.boerde.de>
 
  $Id: mouse.inc,v 1.2 1999/02/03 20:42:53 mkoeppe Exp $
}

uses
  Linux, VgaMouse;

procedure InitMouse;
begin
  PendingMouseHead:=@PendingMouseEvent;
  PendingMouseTail:=@PendingMouseEvent;
  PendingMouseEvents:=0;
  FillChar(LastMouseEvent,sizeof(TMouseEvent),0);
  ShowMouse;
end;

procedure DoneMouse;
begin
  HideMouse;
end;

function DetectMouse:byte;
begin
  DetectMouse:=2;
end;

procedure ShowMouse;
begin
end;

procedure HideMouse;
begin
end;

function GetMouseX:word;
begin
  mouse_update;
  GetMouseX := mouse_getx;
end;


function GetMouseY:word;
begin
  mouse_update;
  GetMouseY := mouse_gety;
end;


function GetMouseButtons:word;
var
  c: Word;
begin
  mouse_update;
  c := mouse_getbutton;
  GetMouseButtons := ((c and 1) shl 1) or ((c and 2) shl 1) or ((c and 4) shr 2);
end;

procedure SetMouseXY(x,y:word);
begin
end;

const
  LastEvent: TMouseEvent = ();

procedure makemouseevent(var MouseEvent: TMouseEvent);
begin		      
  MouseEvent.x := GetMouseX; 
  MouseEvent.y := GetMouseY; 
  MouseEvent.buttons := GetMouseButtons;
  MouseEvent.Action := 0;
  if (MouseEvent.x<>LastEvent.x) or (MouseEvent.y<>LastEvent.y)
    then MouseEvent.Action := MouseActionMove;
  if MouseEvent.buttons and not LastEvent.buttons and 7 <> 0 then
    MouseEvent.Action := MouseActionDown
  else if LastEvent.buttons and not MouseEvent.buttons and 7 <> 0 then
    MouseEvent.Action := MouseActionUp;
end;

procedure GetMouseEvent(var MouseEvent: TMouseEvent);
begin
  makemouseevent(MouseEvent);
  LastEvent := MouseEvent;
end;

function PollMouseEvent(var MouseEvent: TMouseEvent):boolean;
begin
  makemouseevent(MouseEvent);
  PollMouseEvent := MouseEvent.Action <> 0;
end;

{
  $Log: mouse.inc,v $
  Revision 1.2  1999/02/03 20:42:53  mkoeppe
  Working.

  Revision 1.1  1999/02/03 17:56:49  mkoeppe
  Initial revision


}
