unit GvCombo;

{ Graphics Vision Combo Boxes,
  Copr. 1995,1999 Matthias K"oppe
}

{$ifdef FPK}
{$i fpkdef.pp}
{$else}
{$A+,B-,F+,G+,I-,O+,P-,Q-,R-,S-,T-,V+,X+}
{$endif}

interface

uses Objects, Drivers, Validate, GvViews, GvDialog, GvStdDlg, GvValid;

type
  PDoubleValidator = ^TDoubleValidator;
  TDoubleValidator = object(TValidator)
    Val1, Val2: PValidator;
    constructor Init(AVal1, AVal2: PValidator);
    destructor Done; virtual;
    function IsValid(const S: string): Boolean; virtual;
    function IsValidInput(var S: string;
      NoAutoFill: Boolean): Boolean; virtual;
    function Transfer(var S: String; Buffer: Pointer;
      Flag: TVTransfer): Word; virtual;
  end;

  PLinkedStringLookUpValidator = ^TLinkedStringLookUpValidator;
  TLinkedStringLookUpValidator = object(TGStringLookUpValidator)
    ListBox: PSortedListBox;
    Strict: Boolean;
    constructor Init(AListBox: PSortedListBox; IsStrict: Boolean);
    destructor Done; virtual;
    function IsValid(const S: string): Boolean; virtual;
    function IsValidInput(var S: string; NoAutoFill: Boolean): Boolean; virtual;
    function Lookup(const S: string): Boolean; virtual;
    function LookupItem(const S: string; var Index: Integer): Boolean; virtual;
  end;

  PStringLookUpListBox = ^TStringLookUpListBox;
  TStringLookUpListBox = object(TSortedListBox)
    InputLine: PInputLine;
    Validator: PLinkedStringLookUpValidator;
    constructor Init(var Bounds: TRect; AScrollBar: PScrollBar;
      AnInputLine: PInputLine);
    procedure FocusItem(Item: Integer); virtual;
    procedure NewList(AList: PCollection); virtual;
  end;

  PComboViewer = ^TComboViewer;
  TComboViewer = object(TStringLookUpListBox)
    constructor Init(AnInputLine: PInputLine);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  PComboWindow = ^TComboWindow;
  TComboWindow = object(THistoryWindow)
    constructor Init(var Bounds: TRect; ALookUpListBox: PStringLookUpListBox);
    destructor Done; virtual;
    procedure DeleteViewer; virtual;
    procedure InsertViewer; virtual;
  end;

  PCombo = ^TCombo;
  TCombo = object(THistory)
    LookUpListBox: PStringLookUpListBox;
    constructor Init(var Bounds: TRect; ALookUpListBox: PStringLookUpListBox);
    destructor Done; virtual;
    function InitHistoryWindow(var Bounds: TRect): PHistoryWindow; virtual;
    procedure RecordHistory(S: String); virtual;
  end;

implementation

{ TDoubleValidator object 
}

constructor TDoubleValidator.Init(AVal1, AVal2: PValidator);
begin
  inherited Init;
  Val1 := AVal1;
  Val2 := AVal2;
  Options := Val1^.Options or Val2^.Options
end;

destructor TDoubleValidator.Done;
begin
  Dispose(Val1, Done);
  Dispose(Val2, Done);
  inherited Done
end;

function TDoubleValidator.IsValid(const S: string): Boolean;
begin
  IsValid := Val1^.IsValid(S) and Val2^.IsValid(S)
end;

function TDoubleValidator.IsValidInput(var S: string;
      NoAutoFill: Boolean): Boolean;
begin
  IsValidInput :=
    Val1^.IsValidInput(S, NoAutoFill) and
    Val2^.IsValidInput(S, NoAutoFill)
end;

function TDoubleValidator.Transfer(var S: String; Buffer: Pointer;
      Flag: TVTransfer): Word;
var
  Size1: Word;
begin
  Transfer := 0;
  Size1 := Val1^.Transfer(S, Buffer, Flag);
  If Buffer <> nil
  then Inc(PtrRec(Buffer).Ofs, Size1);
  Transfer := Size1 + Val2^.Transfer(S, Buffer, Flag)
end;

{ TLinkedStringLookUpValidator 
}

constructor TLinkedStringLookUpValidator.Init(AListBox: PSortedListBox; IsStrict: Boolean);
begin
  inherited Init(PStringCollection(AListBox^.List));
  ListBox := AListBox;
  Strict := IsStrict
end;

destructor TLinkedStringLookUpValidator.Done;
begin
  Strings := nil;
  inherited Done
end;

function TLinkedStringLookUpValidator.IsValid(const S: string): Boolean;
begin
  IsValid := not Strict or inherited IsValid(S)
end;

function TLinkedStringLookUpValidator.IsValidInput(var S: string; NoAutoFill: Boolean): Boolean;
var
  Index: Integer;
begin
  IsValidInput := true;
  if Strings <> nil then
  begin
    LookUpItem(S, Index);
    ListBox^.FocusItem(Index)
  end
end;

function TLinkedStringLookupValidator.Lookup(const S: string): Boolean;
var
  Index: Integer;
begin
  LookUp := LookUpItem(S, Index)
end;

function TLinkedStringLookUpValidator.LookupItem(const S: string;
  var Index: Integer): Boolean;
var
  Str: PString;
  I: Sw_Integer;
begin
{$ifdef NOIASM}
  Str := @S;
{$else}
  asm
	LES     DI,S
	MOV     Str.Word[0], DI
	MOV     Str.Word[2], ES
  end;
{$endif}
  LookupItem := false;
  if Strings <> nil then begin
    LookupItem := Strings^.Search(Str, I);
    Index := I
  end;
end;

{ TStringLookUpListBox object 
}

constructor TStringLookUpListBox.Init(var Bounds: TRect; AScrollBar: PScrollBar;
      AnInputLine: PInputLine);
var
  OldValid: PValidator;
begin
  inherited Init(Bounds, AScrollBar);
  InputLine := AnInputLine;
  Validator := New(PLinkedStringLookUpValidator, Init(@Self, false));
  If InputLine^.Validator = nil
  then InputLine^.SetValidator(Validator)
  else begin
    OldValid := InputLine^.Validator;
    InputLine^.Validator := nil;
    InputLine^.SetValidator(New(PDoubleValidator, Init(OldValid, Validator)))
  end;
end;

procedure TStringLookUpListBox.FocusItem(Item: Integer);
var
  Save: PValidator;
  S: string;
begin
  inherited FocusItem(Item);
  If not InputLine^.GetState(sfSelected) then
  if (Item >= 0) and (Item < List^.Count) 	{ gvbwah }
  then
    with InputLine^ do
    begin
      S := GetText(Item, MaxLen);
      Save := Validator;
      Validator := nil;
      SetData(S);
      Validator := Save
    end
end;

procedure TStringLookUpListBox.NewList(AList: PCollection);
begin
  inherited NewList(AList);
  with Validator^ do
  begin
    Strings := nil;
    NewStringList(PStringCollection(AList));
  end
end;

{ TComboViewer object 
}

constructor TComboViewer.Init(AnInputLine: PInputLine);
var
  R: TRect;
begin
  R.Assign(0, 0, 0, 0);
  inherited Init(R, nil, AnInputLine)
end;

procedure TComboViewer.HandleEvent(var Event: TEvent);
begin
  If ((Event.What = evMouseDown) and (Event.Double)) or
     ((Event.What = evKeyDown) and (Event.KeyCode = kbEnter)) then
  Begin
    GOwner^.EndModal(cmOk);
    ClearEvent(Event);
  End
  Else If ((Event.What = evKeyDown) and (Event.KeyCode = kbEsc)) or
	  ((Event.What = evCommand) and (Event.Command = cmCancel)) then
       Begin
	 GOwner^.EndModal(cmCancel);
	 ClearEvent(Event);
       End
       Else inherited HandleEvent(Event);
end;

{ TComboWindow object 
}

constructor TComboWindow.Init(var Bounds: TRect; ALookUpListBox: PStringLookUpListBox);
begin
  TWindow.Init(Bounds, '', wnNoNumber);
  Flags := wfClose;
  Viewer := ALookUpListBox;
  Viewer^.GrowMode := gfGrowHiX + gfGrowHiY;
  InsertViewer
end;

destructor TComboWindow.Done;
begin
  DeleteViewer;
  inherited Done
end;

procedure TComboWindow.DeleteViewer;
begin
  Delete(Viewer);
  Viewer^.Scrollbar := nil;
end;

procedure TComboWindow.InsertViewer;
var
  R: TRect;
  S: PScrollBar;
begin
  GetClientRect(R);
  R.Grow(0,1); Inc(R.B.X);
  R.A.X := R.B.X - 18;
  S := New(PScrollBar, Init(R));
  S^.Flags := S^.Flags or sbHandleKeyBoard;
  S^.Options := S^.Options or ofPostProcess;
  Insert(S);
  GetClientRect(R);
  Dec(R.B.X, 17);
  R.Grow(1,1);
  Viewer^.Locate(R);
  Viewer^.Scrollbar := S;
  S^.SetRange(0, Viewer^.Range - 1);
  S^.SetStep(Viewer^.GetPageSize + 1, 1);
  Insert(Viewer);
end;

{ TCombo object 
}

constructor TCombo.Init(var Bounds: TRect; ALookUpListBox: PStringLookUpListBox);
begin
  inherited Init(Bounds, ALookUpListBox^.InputLine, 0);
  LookUpListBox := ALookUpListBox
end;

destructor TCombo.Done;
begin
  Dispose(LookUpListBox, Done);
  inherited Done
end;

function TCombo.InitHistoryWindow(var Bounds: TRect): PHistoryWindow;
var
  P: PHistoryWindow;
begin
  P := New(PComboWindow, Init(Bounds, LookUpListBox));
  P^.HelpCtx := Link^.HelpCtx;
  InitHistoryWindow := P
end;

procedure TCombo.RecordHistory(S: String);
begin
end;

end.
