{************************************************}
{                                                }
{   Graphics Vision Editor Demo                  }
{   Copyright (c) 1994 by Stefan Milius          }
{                                                }
{************************************************}

Program EditDemo;

{$ifdef Windows}
uses Dos, Objects, Drivers, Memory, WinGr, ExtGraph, Views,
{$else}
uses Dos, MyMouse, MyFonts, Objects, Drivers, Memory, ExtGraph, MetaGr, Views,
{$endif}
     GVViews, GVDialog, GVMenus, GVGadget, GVStdDlg, GVMsgBox, GVColor,
     GVEdit, GVWList, GVApp, GVValid, GVWinNum, WinRes, GvClip;

const
  HeapSize = 32 * (1024 div 16);

  OptFile: PathStr = 'EDITDEMO.OPT';

{$I EditCom.INC}

type
  PCountDown = ^TCountDown;
  TCountDown = object(TStaticText)
                 Time: LongInt;
                 constructor Init(var Bounds: TRect; AText: String;
                   ATime: LongInt);
                 procedure GetText(var S: String); virtual;
                 procedure HandleEvent(var Event: TEvent); virtual;
               end;

  PEditStat = ^TEditStat;
  TEditStat = object(TStatusLine)
                function Hint(AHelpCtx: Word): String; virtual;
              end;

  TEditApp = object(TApplication)
               constructor Init;
               procedure Idle; virtual;
	       procedure InitMenuBar; virtual;
               procedure InitStatusLine; virtual;
	       procedure HandleEvent(var Event: TEvent); virtual;
               function OpenEditor(FileName: FNameStr; Visible: Boolean): PEditWindow;
               procedure OutOfMemory; virtual;
               procedure WriteShellMsg; virtual;
               function Valid(Command: Word): Boolean; virtual;
             private
               Heap: PHeapView;
               Clock: PClockView;
               Opt: Array [1..3] of LongInt;
               procedure LoadOptions(var S: TStream);
               procedure SaveOptions(var S: TStream);
               procedure LoadDesktop(var S: TStream);
               procedure SaveDesktop(var S: TStream);
               procedure LoadEnvironment;
               function SaveEnvironment: Boolean;
             end;

var
  App: TEditApp;
  ClipWindow: PEditWindow;

{ TCountDown object }

constructor TCountDown.Init;
Begin
  TStaticText.Init(Bounds, AText);
  Time := ATime;
  EventMask := evTimer;
End;

procedure TCountDown.GetText;
Begin
  If Time = 0 then Begin S := ''; Exit End;
  If Text <> nil then FormatStr(S, Text^ + ' %d s', Time)
                 else FormatStr(S, '%d s', Time);
End;

procedure TCountDown.HandleEvent;
var X: Word;
Begin
  If Event.What = evTimer then Begin
    While Time > 0 do Begin
      GetTimerEvent(Event);
      If (Event.What = evTimer) and (Event.InfoWord mod 18 = 0) then Begin
        Dec(Time);
        SetViewPort;
        HideMouse;
        SetTextParams(ftSansSerif, 0, 0, true);
        If Text <> nil then X := TextWidth(Text^)
                       else X := 0;
        SetFillStyle(SolidFill, GOwner^.GetColor(1));
        Bar(X, 0, Size.X - 1, Size.Y - 1);
        ShowMouse;
        RestoreViewPort;
        DrawView;
      End;
    End;
    SetViewPort;
    HideMouse;
    SetFillStyle(SolidFill, GOwner^.GetColor(1));
    Bar(0,0,Size.X - 1, Size.Y - 1);
    ShowMouse;
    RestoreViewPort;
    GOwner^.Delete(@Self);
    Free;
  End;
End;

procedure ShowInfo;
var D: PDialog;
    R: TRect;
Begin
  R.Assign(0, 0, 300, 200);
  D := New(PDialog, Init(R, 'Shareware-Info'));
  With D^ do Begin
    Options := Options or ofCentered;
    R.Assign(20, 35, 280, 135);
    Insert(New(PStaticText, Init(R,
      'Hier wrde ein Shareware-Hinweis stehen, wenn dieses Demo Shareware wr''')));
    R.Assign(20, 135, 280, 155);
    Insert(New(PCountDown, Init(R, 'Schikane dauert noch:', 8)));
    R.Assign(100, 165, 200, 190);
    Insert(New(PButton, Init(R, 'O~K~', cmOK, bfNormal)));
  End;
  Application^.ExecuteDialog(D, nil);
End;

{ TEditStat object }

function TEditStat.Hint;
Begin
  Hint := ''
End;

{ TEditApp object }

function TEditApp.OpenEditor(FileName: FNameStr; Visible: Boolean): PEditWindow;
var
  P: PEditWindow;
  R: TRect;
Begin
  DeskTop^.GetExtent(R);
  P := New(PEditWindow, Init(R, FileName, wnJustANumber));
  If not Visible then P^.Hide;
  If Opt[3] and oInsert = 0 then Message(P, evCommand, cmInsMode, nil);
  If Opt[3] and oAutoIndent <> 0 then Message(P, evCommand, cmIndentMode, nil);
  OpenEditor := PEditWindow(Application^.InsertWindow(P));
End;

constructor TEditApp.Init;
var R: TRect;
Begin
  { Setting language }

  {$IFDEF english }
  Language := lfEnglish;
  {$ENDIF}

  MaxHeapSize := HeapSize;
  WindowCmds := WindowCmds + [cmCloseAll];
  DisableCommands(WindowCmds);

  TApplication.Init;

  DisableCommands([cmSave, cmSaveAs, cmCut, cmCopy, cmPaste, cmClear,
    cmUndo, cmFind, cmReplace, cmSearchAgain, cmGotoLine]);

  EditorDialog := StdEditorDialog;

  R.Assign(Main^.Size.X-81, Main^.Size.Y-21, Main^.Size.X+1, Main^.Size.Y+1);
  Heap := New (PHeapView, Init(R));
  If Heap <> nil 
  then begin
    Heap^.GrowMode := gfGrowHiX + gfGrowHiY + gfGrowLoX + gfGrowLoY;
    Main^.Insert(Heap);
  end;
  R.Assign(Main^.Size.X-81, -1, Main^.Size.X+1, 21);
  Clock := New(PClockView, Init(R));
  If Clock <> nil then Main^.Insert(Clock);

  LoadEnvironment;

  {ClipWindow := OpenEditor('', False);}

  Desktop^.GetExtent(R);
  ClipWindow := New(PClipWindow, Init(R, wnJustANumber));
  ClipWindow^.Hide;
  InsertWindow(ClipWindow);

  If ClipWindow <> nil then Begin
    Clipboard := ClipWindow^.Editor;
    Clipboard^.CanUndo := false;
  End;
End;

procedure TEditApp.Idle;
Begin
  TApplication.Idle;
  If Heap <> nil then Heap^.UpDate;
  If Clock <> nil then Clock^.UpDate;
End;

procedure TEditApp.InitMenuBar;
var R: TRect;
Begin
  R.Assign(0,0,Main^.Size.X-71,21);
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~D~atei', hcFile, NewMenu(
      NewItem('~I~nfo...', 'F1', kbF1, cmInfo, hcInfo,
      NewLine(
      StdFileMenuItems(nil)))),
    NewSubMenu('~B~earbeiten', hcWork, NewMenu(
      StdEditMenuItems(
      NewLine(
      NewItem('~Z~wischenablage anzeigen', '', kbNoKey, cmShowClipboard, hcShowClipboard,
        nil)))),
    NewSubMenu('~S~uchen', hcSearch, NewMenu(
      NewItem('~S~uchen nach...', '', kbNoKey, cmFind, hcFind,
      NewItem('~E~rsetzen...', '', kbNoKey, cmReplace, hcReplace,
      NewItem('~W~eitersuchen', '', kbNoKey, cmSearchAgain, hcSearchAgain,
      NewLine(
      NewItem('~G~ehe zu Zeile...', '', kbNoKey, cmGotoLine, hcGotoLine,
	nil)))))),
    NewSubMenu('~O~ptionen', hcOption, NewMenu(
      NewItem('~V~orgaben...', '', kbNoKey, cmBasicOpt, hcBasicOpt,
      NewItem('~E~ditor...', '', kbNoKey, cmEditOpt, hcEditOpt,
      NewItem('~F~arben...', '', kbNoKey, cmColor, hcColor,
      NewLine(
      NewItem('~L~aden...', '', kbNoKey, cmLoadOpt, hcLoadOpt,
      NewItem('~S~peichern', '', kbNoKey, cmSaveOpt, hcSaveOpt,
      NewItem('Speichern ~u~nter...', '', kbNoKey, cmSaveOptAs, hcSaveOptAs,
        nil)))))))),
    NewSubMenu('~F~enster', hcWindow, NewMenu(
      StdWindowMenuItems(
      NewLine(
      NewItem('~L~iste...', 'Alt+0', kbAlt0, cmList, hcList, nil)))),
     nil))))))));
End;

procedure TEditApp.InitStatusLine;
var R: TRect;
Begin
  R.Assign (0,Main^.Size.Y-21, Main^.Size.X-71, Main^.Size.Y);
  StatusLine := New(PEditStat, Init(R,
    NewStatusDef(0, 0,
      NewStatusKey('~F1~ Info', kbF1, cmInfo,
      NewStatusKey('~F2~ Speichern', kbF2, cmSave,
      NewStatusKey('~F3~ ffnen', kbF3, cmOpen,
      NewStatusKey('~F10~ Men', kbF10, cmMenu,
      NewStatusKey('~Alt+X~ Beenden', kbAltX, cmQuit, nil))))),
    NewStatusDef(1, 1,
      NewStatusKey(#2'~'#27#26#25#24+'~ Verschieben', kbNoKey, cmValid,
      NewStatusKey(#2'~Umschalt-'#27#26#25#24'~ Gre', kbNoKey, cmValid, 
      NewStatusKey(#2'~'#17'~ Beenden', kbNoKey, cmValid,
      NewStatusKey(#2'~Esc~ Abbruch', kbNoKey, cmValid, nil)))),
    NewStatusDef (2, 9999,
      NewStatusKey ('~Alt+F3~ Schlieen', kbAltF3, cmClose, nil),
    NewStatusDef (10000, $FFFF,
      NewStatusKey ('~F1~ Info', kbF1, cmInfo, nil),nil))))));
End;

procedure TEditApp.HandleEvent;

 procedure Info;
 Begin
   MessageBox('Graphics Vision, Version '+Version+
              #13'Editor Demoprogramm'#13'Copyright (c) 1994 by Stefan Milius',
              nil, mfInformation+mfOkButton);
 End;

 procedure NewEditor;
 Begin
   OpenEditor('', true);
 End;

 procedure Open;
 var Data: PathStr;
 Begin
   Data := '*.PAS';
   If ExecuteDialog(New(PFileDialog, Init('*.PAS','ffnen einer Datei',
          '~N~ame', fdOpenButton + fdHelpButton, 30)), @Data) = cmFileOpen
     Then OpenEditor(Data, true);
 End;

 procedure ChDir;
 Begin
   ExecuteDialog(New(PChDirDialog, Init(cdHelpButton, 31)), nil);
 End;

 procedure SaveAll;

  procedure SaveWindow(P: PGView); {$ifndef FPK}far;{$endif}
  Begin
    If (P <> Desktop^.Last) and (PEditWindow(P) <> ClipWindow) then
      PEditWindow(P)^.Editor^.Save;
  End;

 Begin
   Desktop^.ForEach(@SaveWindow);
 End;

 procedure ShowClip;
 Begin
   ClipWindow^.Select;
   ClipWindow^.Show;
 End;

 procedure Color;
 Begin
   If ExecuteDialog(New (PColorDialog, Init ('',
     ColorGroup('Desktop',
       ColorItem('Hintergrund', 1, nil),
     ColorGroup('Men',
       ColorItem('Text normal ', 2,
       ColorItem('Text deaktiviert', 3,
       ColorItem('Text shortcut', 4,
       ColorItem('Selektiert normal', 5,
       ColorItem('Selektiert deaktiviert', 6,
       ColorItem('Selektiert shortcut', 7,
       ColorItem('Normaler Hintergrund', 8,
       ColorItem('Selekt. Hintergrund', 9, nil)))))))),
     ColorGroup('Editor',
       ColorItem('Text normal', 50,
       ColorItem('Text selektiert', 51,
       ColorItem('Hintergrund normal', 52,
       ColorItem('Hintergrund selektiert', 53, nil)))), nil))))),

       Application^.GetPalette) = cmOK then ReDraw;

 End;

 procedure CloseAll;
 var P, NewP: PGView;
 Begin
   With Desktop^ do Begin
     P := First;
     While P <> Last do Begin
       NewP := P^.NextView;
       PEditWindow(P)^.Close;
       P := NewP;
     End;
   End;
 End;

 procedure BasicOpt;
 var R: TRect;
     D: PDialog;
     P: PGView;
     Data: Array [1..2] of LongInt;
 Begin
   R.Assign(0, 0, 260, 240);
   D := New(PDialog, Init(R, 'Vorgaben'));
   With D^ do Begin
     Options := Options or ofCentered;
     R.Assign(50, 60, 210, 96);
     P := New(PRadioButtons, Init(R,
       NewSItem('~A~ktuelles Verzeichnis',
       NewSItem('~V~erz. der Konfig.Datei', nil))));
     Insert(P);
     R.Assign (50, 38, 150, 58);
     Insert(New(PLabel, Init(R, 'Desktop-Datei', P)));

     R.Assign(50, 135, 210, 187);
     P := New(PCheckBoxes, Init(R,
       NewSItem('~D~ateien im Editor',
       NewSItem('~U~mgebung',
       NewSItem('D~e~sktop', nil)))));
     Insert(P);
     R.Assign(50, 113, 160, 133);
     Insert(New(PLabel, Init(R, 'Autom. Speichern', P)));

     R.Assign(Size.X div 4 - 40, 200, Size.X div 4 + 60, 225);
     Insert(New(PButton, Init(R, '~O~K', cmOK, bfDefault)));
     R.Move(Size.X div 2 - 20, 0);
     Insert(New(PButton, Init(R, 'Abbruch', cmCancel, bfNormal)));

     SelectNext(false)
   End;
   ExecuteDialog(D, @Opt);
 End;

 procedure ToggleInsMode;

  procedure Toggle(P: PGView); {$ifndef FPK}far;{$endif}
  Begin
    If P <> Desktop^.Last then Message(PEditWindow(P)^.Editor, evCommand,
                                 cmInsMode, nil);
  End;

 Begin
   Desktop^.Foreach(@Toggle);
 End;

 procedure ToggleIndentMode;

  procedure Toggle(P: PGView); {$ifndef FPK}far;{$endif}
  Begin
    If P <> Desktop^.Last then Message(PEditWindow(P)^.Editor, evCommand,
                                 cmIndentMode, nil);
  End;

 Begin
   Desktop^.Foreach(@Toggle);
 End;

 procedure EditOpt;
 var R: TRect;
     D: PDialog;
     Temp: LongInt;
 Begin
   R.Assign(0, 0, 260, 145);
   D := New(PDialog, Init(R, 'Editor-Einstellungen'));
   With D^ do Begin
     Options := Options or ofCentered;

     R.Assign(50, 40, 210, 90);
     Insert(New(PCheckBoxes, Init(R,
       NewSItem('~B~AK-Dateien anlegen',
       NewSItem('~E~infgemodus',
       NewSItem('~A~utom. Zeileneinzug', nil))))));

     R.Assign(Size.X div 4 - 40, 105, Size.X div 4 + 60, 130);
     Insert(New(PButton, Init(R, '~O~K', cmOK, bfDefault)));
     R.Move(Size.X div 2 - 20, 0);
     Insert(New(PButton, Init(R, 'Abbruch', cmCancel, bfNormal)));

     SelectNext(false)
   End;
   Temp := Opt[3];
   If ExecuteDialog(D, @Opt[3]) = cmOK then Begin
     If Opt[3] and oBackupFiles <> 0 then
       EditorFlags := EditorFlags or efBackupFiles
     Else EditorFlags := EditorFlags and not efBackupFiles;
     If ((Opt[3] and oInsert <> 0) and (Temp and oInsert = 0)) or
        ((Opt[3] and oInsert = 0) and (Temp and oInsert <> 0)) then
       ToggleInsMode;
     If ((Opt[3] and oAutoIndent <> 0) and (Temp and oAutoIndent = 0)) or
        ((Opt[3] and oAutoIndent = 0) and (Temp and oAutoIndent <> 0)) then
       ToggleIndentMode;
   End;
 End;

 procedure List;
 Begin
   ExecuteWindowList(New(PWListDialog, Init(wlHelpButton)));
 End;

 procedure SaveOpt;
 var Temp: LongInt;
 Begin
   Temp := Opt[2];
   Opt[2] := Opt[2] and not oFiles;
   SaveEnvironment;
   Opt[2] := Temp;
 End;

 procedure LoadOpt;
 var Data: PathStr;
 Begin
   Data := '*.OPT';
   If ExecuteDialog(New(PFileDialog, Init('*.OPT', 'Konfigurationsdatei laden',
       'Datei~n~ame', fdHelpButton + fdOKButton, 32)), @Data) = cmFileOpen
     Then Begin
       CloseAll;
       OptFile := Data;
       LoadEnvironment;
     End;
 End;

 procedure SaveOptAs;
 var Data: PathStr;
     D: PFileDialog;
 Begin
   Data := OptFile;
   If ExecuteDialog(New(PFileDialog, Init(OptFile,
       'Konfiguartionsdatei speichern unter', 'Datei~n~ame',
       fdHelpButton + fdOKButton, 32)), @Data) = cmFileOpen
     Then Begin
       OptFile := Data;
       SaveOpt;
     End;
 End;

var Num: Integer;

Begin
  If (Event.What = evKeyBoard) and (Event.KeyCode = kbIns) then Begin
    ToggleInsMode;
    If Opt[3] and oInsert <> 0 then Opt[3] := Opt[3] and not oInsert
                               else Opt[3] := Opt[3] or oInsert;
  End
  Else Begin
    TApplication.HandleEvent(Event);

    Num := GetNumberFromEvent(Event, etAltNumKeys);
    If Num <> wnNoNumber then
      Message(@Self, evBroadCast, cmSelectWindowNum, Ptr(0, Num));

    If Event.What = evCommand then
      Case Event.Command of
        cmInfo: Info;
        cmNew: NewEditor;
        cmOpen: Open;
        cmChangeDir: ChDir;
        cmSaveAll: SaveAll;
        cmShowClipboard: ShowClip;
        cmBasicOpt: BasicOpt;
        cmEditOpt: EditOpt;
        cmColor: Color;
        cmLoadOpt: LoadOpt;
        cmSaveOpt: SaveOpt;
        cmSaveoptAs: SaveOptAs;
        cmCloseAll: CloseAll;
        cmList: List;
       else Exit;
      End;
  End;
  ClearEvent(Event);
End;

procedure TEditApp.OutOfMemory;
Begin
  MessageBox('Nicht genug freier Speicher fr diese Operation', nil,
    mfError + mfOkButton);
End;

procedure TEditApp.WriteShellMsg;
Begin
  PrintStr('Graphics Vision '+Version+#13#10+
           'Editordemoprogramm'#13#10+
           'Copyright (c) 1994 Stefan Milius'#13#10#13#10+
           'Tippen Sie Exit, um zum Program zurckzukehren!');
End;


function TEditApp.Valid;
Begin
  Valid := true;
  If TApplication.Valid(Command) then Begin
    If Command = cmQuit then Valid := SaveEnvironment;
  End
  Else Valid := false;
End;

procedure TEditApp.LoadOptions;
Begin
  S.Read(Opt, SizeOf(Opt));
  S.Read(GetPalette^, Length(CColor) + 1);
End;

procedure TEditApp.SaveOptions;
Begin
  S.Write(Opt, SizeOf(Opt));
  S.Write(GetPalette^, Length(CColor) + 1);
End;

procedure TEditApp.LoadDesktop;
var Count: Integer;
    R: TRect;
    N: PathStr;
    P: PEditWindow;
Begin
  S.Read(Count, SizeOf(Count));
  While Count > 0 do Begin
    Dec(Count);
    S.Read(R, SizeOf(R));
    S.Read(N[0], 1);
    S.Read(N[1], Length(N));
    P := New(PEditWindow, Init(R, N, wnJustANumber));
    If Opt[3] and oInsert = 0 then Message(P, evCommand, cmInsMode, nil);
    If Opt[3] and oAutoIndent <> 0 then Message(P, evCommand, cmIndentMode, nil);
    InsertWindow(P);
  End;
End;

procedure TEditApp.SaveDesktop;
var Count: Integer;

 procedure DoCount(P: PGView); {$ifndef FPK}far;{$endif}
 Begin
   If (P <> Desktop^.Last) and (PEditWindow(P) <> ClipWindow) then Inc(Count);
 End;

 procedure WriteWindows(P: PGView); {$ifndef FPK}far;{$endif}
 var R: TRect;
     N: PathStr;
 Begin
   If (P <> Desktop^.Last) and (PEditWindow(P) <> ClipWindow) and (Count > 0) then Begin
     Dec(Count);
     N := PEditWindow(P)^.GetTitle($FF);
     P^.GetBounds(R);
     S.Write(R, SizeOf(R));
     S.Write(N[0], Length(N) + 1);
   End;
 End;

Begin
  Count := 0;
  Desktop^.Foreach(@DoCount);
  S.Write(Count, SizeOf(Count));
  Desktop^.Foreach(@WriteWindows);
End;

procedure TEditApp.LoadEnvironment;
var S: TDosStream;
    N: NameStr;
    D: DirStr;
    E: ExtStr;
    Desk: PathStr;
    Kenn: LongInt;

 procedure SetOptions;
 Begin
   Opt[1] := 1; Opt[2] := 6; Opt[3] := 7;
 End;

Begin
  S.Init(OptFile, stOpenRead);
  If S.Status <> stOK then Begin
    FSplit(ParamStr(0), D, N, E);
    OptFile := D + N + '.OPT';
    S.Init(OptFile, stOpenRead);
    If S.Status <> stOK then Begin
      SetOptions;
      S.Done;
      Exit;
    End;
  End;
  S.Read(Kenn, SizeOf(Kenn));
  If Kenn <> $534D4B4D then Begin
    SetOptions;
    S.Done;
    Exit;
  End;
  LoadOptions(S);
  S.Done;
  FSplit(OptFile, D, N, E);
  If Opt[1] = oConfigDir then Desk := D + N + '.DSK'
                         else Desk := FExpand(N + '.DSK');
  S.Init(Desk, stOpenRead);
  If S.Status = stOK then LoadDesktop(S);
  S.Done;
  ReDraw;
End;

function TEditApp.SaveEnvironment;
var S: TDosStream;
    Dir: DirStr;
    Name: NameStr;
    Ext: ExtStr;
    Desk: PathStr;
    Kenn: LongInt;

 procedure SaveWindow(P: PGView); {$ifndef FPK}far;{$endif}
 Begin
   If (P <> Desktop^.Last) and (PEditWindow(P) <> ClipWindow) then
     If not PEditWindow(P)^.Editor^.Save then
       SaveEnvironment := false;
 End;

Begin
  SaveEnvironment := true;
  If Opt[2] and oFiles <> 0 then
    Desktop^.Foreach(@SaveWindow);
  If Opt[2] and oSaveOpt <> 0 then Begin
    S.Init(OptFile, stCreate);
    Kenn := $534D4B4D;
    S.Write(Kenn, SizeOf(Kenn));
    SaveOptions(S);
    S.Done;
  End;
  If Opt[2] and oDesktop <> 0 then Begin
    FSplit(OptFile, Dir, Name, Ext);
    If Opt[1] = oConfigDir then Desk := Dir + Name + '.DSK'
    Else Begin
      Desk := Name + '.DSK';
      Desk := FExpand(Desk);
    End;
    S.Init(Desk, stCreate);
    SaveDesktop(S);
    S.Done;
  End;
End;

Begin
  SetAnsiCode(false);
  App.Init;
  App.Run;
  ShowInfo;
  App.Done;
End.
