
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

{ $Id: exam0012.pas 1.2 1999/02/11 18:24:43 mkoeppe Exp $ }

(* To run this program you'll have to build exam.gvl by:

   GVLC exam.gvl english.gvs exam.gvs

   Hint: If you want another than the English language just translate all
   the texts in the GVS files into this language and then rebuild exam.gvl!
   (Germans only have to translate exam.gvs)


This application shows:

   - how to use gauges

*)

Uses Dos, Objects, Drivers, KeyNames, Views, GVViews, GVMenus, GVApp,
     GVTexts, GVDialog, GVGauges;

const

{ Commands }

  cmNew = 100;  cmAdd = 101; cmReset = 102;

type

{ TDemoApp object }

  TDemoApp = object(TApplication)
               procedure HandleEvent(var Event: TEvent); virtual;
               procedure InitStatusLine; virtual;
               function LanguageResource: String; virtual;
             end;

(******************************** TDemoApp object ***************************)

procedure TDemoApp.HandleEvent(var Event: TEvent);

  procedure NewWindow;
  var R: TRect;
      D: PDialog;
  Begin
    R.Assign(0, 0, 400, 140);
    D := New(PDialog, Init(R, GetStr(741)));
    With D^ do Begin
      Options := Options or ofCentered;
      GetClientRect(R); R.Grow(-30, -20);
      Dec(R.B.Y, 50);
      Insert(New(PBarGauge, Init(R, 100)));
      R.Grow(-148, -5);
      Insert(New(PPercentGauge, Init(R, 100)));

      { Buttons }
      R.Assign(100, Size.Y - 55, 200, Size.Y - 25);
      Insert(New(PButton, Init(R, GetStr(742), cmAdd, bfDefault + bfBroadcast)));
      R.Move(120, 0);
      Insert(New(PButton, Init(R, GetStr(743), cmReset, bfBroadcast)));
      SelectNext(false);
    End;
    ExecuteDialog(D, nil)
  End;

Begin
  inherited HandleEvent(Event);
  If (Event.What = evCommand) and (Event.Command = cmNew) then
    NewWindow;
  If Event.What = evBroadCast then
    Case Event.Command Of
      cmAdd: Message(@Self, evBroadCast, cmAddGauge, Ptr(0, 10));
      cmReset: Message(@Self, evBroadCast, cmUpDateGauge, Ptr(0, 0));
    End
End;

procedure TDemoApp.InitStatusLine;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    StdDraggingStatusDef(
    NewStatusDef(0, $FFFF,
      NewStatusKeyKN(GetStr(600), kbAltX, cmQuit,
      NewStatusKeyKN(GetStr(613), kbF3, cmNew,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbCtrlF5, cmResize, nil)))),
    nil))));
End;

function TDemoApp.LanguageResource: String;
Begin
  LanguageResource := 'exam.gvl';
End;

var App: TDemoApp;

Begin
  Language := lfEnglish;
  App.Init;
  App.Run;
  App.Done;
End.
