
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1992,1997 Stefan Milius           }
{       Copyright (c) 1997,1999 Matthias K"oppe         }
{                                                       }
{*******************************************************}

{ $Id: extgraph.pas 1.7 1999/02/14 12:17:41 mkoeppe Exp $ }

Unit ExtGraph;

{$ifndef FPK}
{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}
{$endif}

interface

{$ifdef FPK}
uses Objects, BGI, GvFPK;
{$i fpkdef.pp}
{$else}
{$ifdef Windows}
uses WinTypes, WinProcs, Objects, WinGr, VgaMem;
{$else}
uses Objects, VGAMem;
{$endif}
{$endif}

{ System Font Handles
}
const
  ftSystem    = 0;
  ftSansSerif = 1;
  ftMonoSpace = 2;

{ Graphics Vision standard mouse cursors
}
const
  mcStd        = 0;
  mcCross      = 1;
  mcHourGlass  = 2;
  mcLargeCross = 3;
  mcInput      = 50;
  mcMove       = 51;
  mcResizeDnRi = 52;
  mcResizeDnLe = 53;
  mcResizeVert = 54;
  mcResizeHori = 55;
  mcNoCursor   = -1;

{ Icon Functions.
  Low-level, don't care about DrawOrigin.
}
procedure KillAllIcons;
procedure KillIcon(Icon: pointer);
procedure PutIconAnd(x1, y1: Integer; MapMask: Byte; Icon: pointer);
procedure PutIconOr(x1, y1: Integer; MapMask: Byte; Icon: pointer);
procedure PutIcon(x, y: Integer; IconBits: pointer; Color: Byte; Mode: Byte);

{ High-level, respect DrawOrigin
}
function DrawIcon(x1, y1, n: Integer; Mode: Word): Word;
procedure DrawColIcon(x1, y1, n: Integer; Color: Byte);
procedure ColorFill(x1, y1, x2, y2: Integer;
  Fore, Back: Word; FillIcon: pointer);
procedure SetExactBkColor(R, G, B: Integer);

{ 3-D Utility Functions
}
type
  PPoint = ^TPoint;

procedure DrawButton(var R: TRect;
  Down, Small: Boolean; BkCol, FrameCol, NormCol, ShadowCol: Byte);
function EdgeColor(Vector: TPoint; Color: Word): Word;
procedure Edge(A, B: TPoint; Color: Word);
{$ifndef FPK}
procedure EdgePolygon(var Polygon: array of TPoint; Color: Word);
{$endif}
procedure EdgeRect(A, B: TPoint; Down: Boolean; Color: Word);
procedure EdgeR(x1, y1, x2, y2: Integer; Down: Boolean; Color: Word);
procedure EdgeArc(Center: TPoint; StAngle, EndAngle, Radius: Integer;
  StPoint, EndPoint: PPoint; Color: Word);

{ Old-style Graphics Functions
}
procedure RBar(var R: TRect);
procedure RRect(var R: TRect);
procedure OutTextP(P: TPoint; S: string);
function GetShortCut(S: string): Char;
procedure OutGVText(P: TPoint; S: String;
  Col1, Col2: Byte; Size: TPoint; Center: Boolean);
procedure SetGVStyle(AFont: Integer);
procedure PutGVImage(var R: TRect; Image: pointer; BkCol: Byte);

{ Size of old-style GV images;
  These values are not used any more.
}
const
  SignX: Byte = 30;
  SignY: Byte = 20;

procedure CloseDot; { don't call }
procedure BoxIcons; { don't call }

implementation

{$ifdef FPK}
uses Bitmaps;
{$ASMMODE INTEL}
{$else}
{$ifdef Windows}
uses WinRes, Bitmap;
{$else}
uses Gr, WinRes, MetaGr, MyMouse, MyFonts, Bitmap;
{$endif}
{$endif}

Const
  Font: Byte = ftSystem;

procedure TheIcons; {$ifndef FPK} near; {$endif} assembler;
asm
@D1:	DW	13			{ 0 CheckBox off }
	DW	1111111111111000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1111111111111000B
	DW	13			{ 1 CheckBox on }
	DW	1111111111111000B
	DW	1100000000011000B
	DW	1010000000101000B
	DW	1001000001001000B
	DW	1000100010001000B
	DW	1000010100001000B
	DW	1000001000001000B
	DW	1000010100001000B
	DW	1000100010001000B
	DW	1001000001001000B
	DW	1010000000101000B
	DW	1100000000011000B
	DW	1111111111111000B
	DW	13			{ 2 RadioButton off }
	DW	0000011100000000B
	DW	0001100011000000B
	DW	0010000000100000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0010000000100000B
	DW	0001100011000000B
	DW	0000011100000000B
	DW	13			{ 3 RadioButton on }
	DW	0000011100000000B
	DW	0001100011000000B
	DW	0010000000100000B
	DW	0100011100010000B
	DW	0100111110010000B
	DW	1001111111001000B
	DW	1001111111001000B
	DW	1001111111001000B
	DW	0100111110010000B
	DW	0100011100010000B
	DW	0010000000100000B
	DW	0001100011000000B
	DW	0000011100000000B
	DW	11			{ 4 Zoom }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000001000000B
	DW	0000000011100000B
	DW	0000000111110000B
	DW	0000001111111000B
	DW	15			{ 5 UnZoom }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000001000000B
	DW	0000000011100000B
	DW	0000000111110000B
	DW	0000001111111000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	12			{ 6 Symbol }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	12			{ 7 Scroll Arrow Right }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000011000000B
	DW	0000011111100000B
	DW	0000011111110000B
	DW	0000011111100000B
	DW	0000000011000000B
	DW	0000000010000000B
	DW	12			{ 8 Scroll Arrow Left }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000110000000B
	DW	0000001111110000B
	DW	0000011111110000B
	DW	0000001111110000B
	DW	0000000110000000B
	DW	0000000010000000B
	DW	12			{ 9 Scroll Arrow Up }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111100000B
	DW	0000011111110000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	12			{ 10 Scroll Arrow Down }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000011111110000B
	DW	0000001111100000B
	DW	0000000111000000B
	DW	0000000010000000B
	DW	13			{ 11 Scroll Arrow Right Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000011000000B
	DW	0000011111100000B
	DW	0000011111110000B
	DW	0000011111111000B
	DW	0000001111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	13			{ 12 Scroll Arrow Left Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111110000B
	DW	0000011111111000B
	DW	0000001111111000B
	DW	0000000111111000B
	DW	0000000011000000B
	DW	0000000001000000B
	DW	13			{ 13 Scroll Arrow Up Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111100000B
	DW	0000011111110000B
	DW	0000011111011000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000000011100000B
	DW	13			{ 14 Scroll Arrow Down Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000011111110000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	14			{ 15 Open List Button }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000011111110000B
	DW	0000001111100000B
	DW	0000000111000000B
	DW	0000000010000000B
	DW	0000000000000000B
	DW	0000011111110000B
	DW	16			{ 16 Submenu Arrow }
	DW      0000000000000000B
        DW      0000000000000000B
	DW      0000000000000000B
	DW	1000000000000000B
	DW	1100000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1111100000000000B
	DW	1111110000000000B
	DW	1111111000000000B
	DW	1111110000000000B
	DW	1111100000000000B
        DW      1111000000000000B
	DW      1110000000000000B
        DW      1100000000000000B
	DW      1000000000000000B
	DW	13			{ 17 held CheckBox off }
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	13			{ 18 held CheckBox on }
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1110000000111000B
	DW	1101000001011000B
	DW	1100100010011000B
	DW	1100010100011000B
	DW	1100001000011000B
	DW	1100010100011000B
	DW	1100100010011000B
	DW	1101000001011000B
	DW	1110000000111000B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	13			{ 19 held RadioButton off }
	DW	0000011100000000B
	DW	0001111111000000B
	DW	0011100011100000B
	DW	0111000001110000B
	DW	0110000000110000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	0110000000110000B
	DW	0111000001110000B
	DW	0011100011100000B
	DW	0001111111000000B
	DW	0000011100000000B
	DW	13			{ 20 held RadioButton on }
	DW	0000011100000000B
	DW	0001111111000000B
	DW	0011100011100000B
	DW	0111011101110000B
	DW	0110111110110000B
	DW	1101111111011000B
	DW	1101111111011000B
	DW	1101111111011000B
	DW	0110111110110000B
	DW	0111011101110000B
	DW	0011100011100000B
	DW	0001111111000000B
	DW	0000011100000000B
	DW	12			{ 21 small CheckBox off }
	DW	0000000000000000B	{ hhenkompatibel mit anderen!! }
	DW	0111111111110000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0111111111110000B
	DW	12			{ 22 small CheckBox on }
	DW	0000000000000000B	{ hhenkompatibel mit anderen!! }
	DW	0111111111110000B
	DW	0110000000110000B
	DW	0101000001010000B
	DW	0100100010010000B
	DW	0100010100010000B
	DW	0100001000010000B
	DW	0100010100010000B
	DW	0100100010010000B
	DW	0101000001010000B
	DW	0110000000110000B
	DW	0111111111110000B
	DW	20			{ 23 TNumInput Arrows }
	DW	1111111111111000B
	DW	1000000000001000B
	DW	1000001000001000B
	DW	1000011100001000B
	DW	1000011100001000B
	DW	1000111110001000B
	DW	1000111110001000B
	DW	1001111111001000B
	DW	1000000000001000B
	DW	1111111111111000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1001111111001000B
	DW	1000111110001000B
	DW	1000111110001000B
	DW	1000011100001000B
	DW	1000011100001000B
	DW	1000001000001000B
	DW	1000000000001000B
	DW	1111111111111000B
	DW      13                      { 24 Menu check symbol }
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0000000000000000B
        DW      0000000000000100B
        DW      0000000000000100B
        DW      0000000000001100B
        DW      0000000000001000B
	DW      0000000000011000B
        DW      0000001100010000B
	DW      0000000110110000B
	DW      0000000010100000B
        DW      0000000011100000B
        DW      0000000001000000B
        DW	12			{ 25 directory symbol }
        DW	0011111000000000B
	DW	0100000100000000B
	DW	1111111111111100B
	DW	1000000000000010B
	DW	1000000000000010B
	DW	1000000000000010B
	DW	1000000000000010B
        DW	1000000000000010B
	DW	1000000000000010B
	DW	1000000000000010B
        DW	1000000000000010B
        DW	0111111111111110B
	DW	12			{ 26 open directory symbol }
        DW	0011111000000000B
        DW	0100000100000000B
	DW	1000000011111000B
	DW	1000000000000100B
        DW	1000000000000100B
        DW	1000111111111111B
        DW	1001000000000001B
        DW	1001000000000010B
	DW	1010000000000010B
	DW	1010000000000100B
	DW	1100000000000100B
	DW	1111111111111000B
	DW	12			{ 27 open directory symbol selected }
	DW	0011111000000000B
        DW	0110101100000000B
	DW	1101010111111000B
        DW	1010101010101100B
        DW	1101010101010100B
	DW	1010111111111111B
        DW	1101000000000001B
        DW	1011000000000010B
        DW	1110000000000010B
	DW	1010000000000100B
	DW	1100000000000100B
        DW	1111111111111000B
        DW	9                	{ 28 disk drive symbol }
        DW	1111111111111111B
	DW	1000000000000001B
	DW	1000000000000101B
	DW	1000001111000001B
	DW	1011111111111101B
	DW	1000001111000001B
	DW	1000000000000001B
	DW	1000000000000001B
	DW	1111111111111111B
	DW	9                	{ 29 harddisk drive symbol }
        DW	1111111111111111B
	DW	1000000000000001B
        DW	1000000000000001B
        DW	1011111111111101B
        DW	1000000000000001B
        DW	1011011111111101B
	DW	1011000000000001B
	DW	1000000000000001B
        DW	1111111111111111B
	DW	9			{ 30 RAM drive symbol }
	DW	1111111111111111B
	DW	1000000000000001B
	DW	1000101010100001B
	DW	1001111111110001B
	DW	1001111111110001B
	DW	1001111111110001B
	DW	1000101010100001B
	DW	1000000000000001B
	DW	1111111111111111B
	DW	9			{ 31 Network drive symbol }
	DW	1111111111111111B
	DW	1000000000000001B
	DW	1010011110001101B
	DW	1011010001010001B
	DW	1010110000100001B
	DW	1010010001110001B
	DW	1010010001110001B
	DW	1000000000000001B
	DW	1111111111111111B
	DW	9			{ 32 SUBSTituted drive symbol }
	DW	1111111111111111B
	DW	1000000000000001B
	DW	1000100001000001B
	DW	1011110010111101B
	DW	1011111010000101B
	DW	1011110010000101B
	DW	1000100011111101B
	DW	1000000000000001B
	DW	1111111111111111B
	DW	9			{ 33 CD-ROM drive symbol }
	DW	1111111111111111B
	DW	1000000000000001B
	DW	1000111011110001B
	DW	1001000101001001B
	DW	1001000001001001B
	DW	1001000101001001B
	DW	1000111011110001B
	DW	1000000000000001B
	DW	1111111111111111B
	DW	12			{ 34 Scrollbar arrow up-left }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111100000B
	DW	0000001111000000B
	DW	0000001111000000B
	DW	0000001111100000B
	DW	0000001001110000B
	DW	0000000000100000B
	DW	11			{ 35 Scrollbar arrow down-left }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000100000B
	DW	0000001001110000B
	DW	0000001111100000B
	DW	0000001111000000B
	DW	0000001111000000B
	DW	0000001111100000B
	DW	12			{ 36 Scrollbar arrow up-right }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111100000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000001111100000B
	DW	0000011100100000B
	DW	0000001000000000B
	DW	11			{ 37 Scrollbar arrow down-right }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001000000000B
	DW	0000011100100000B
	DW	0000001111100000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000001111100000B
	DW	32			{ 38 MessageBox i and white left }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000001B
	DW	0000000000000011B
	DW	0000000000000111B
	DW	0000000000000111B
	DW	0000000000000111B
	DW	0000000000000011B
	DW	0000000000000001B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000001111B
	DW	0000000000001111B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000001111B
	DW	0000000000001111B
	DW	0000000000001111B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	32			{ 39 MessageBox i and white right }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1111100000000000B
	DW	1111100000000000B
	DW	1111100000000000B
	DW	1111000000000000B
	DW	1110000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1111111000000000B
	DW	1111111000000000B
	DW	1111111000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	32			{ 40 MessageBox ? and white left }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000111B
	DW	0000000000011111B
	DW	0000000000111111B
	DW	0000000000111111B
	DW	0000000001111111B
	DW	0000000001111111B
	DW	0000000001111110B
	DW	0000000001111110B
	DW	0000000001111110B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000011B
	DW	0000000000000011B
	DW	0000000000000111B
	DW	0000000000000111B
	DW	0000000000000111B
	DW	0000000000000000B
	DW	0000000000000001B
	DW	0000000000000111B
	DW	0000000000000111B
	DW	0000000000001111B
	DW	0000000000001111B
	DW	0000000000000111B
	DW	0000000000000111B
	DW	0000000000000001B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	32			{ 41 MessageBox ? and white right }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1110000000000000B
	DW	1111100000000000B
	DW	1111110000000000B
	DW	1111110000000000B
	DW	1111111000000000B
	DW	1111111000000000B
	DW	0111111000000000B
	DW	0111111000000000B
	DW	0111111000000000B
	DW	1111110000000000B
	DW	1111110000000000B
	DW	1111100000000000B
	DW	1111100000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1110000000000000B
	DW	1110000000000000B
	DW	1110000000000000B
	DW	0000000000000000B
	DW	1000000000000000B
	DW	1110000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1111000000000000B
	DW	1110000000000000B
	DW	1110000000000000B
	DW	1000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	31			{ 42 MessageBox i ? or blue/green left }
	DW	0000000000000000B
	DW	0000000000001111B
	DW	0000000001111111B
	DW	0000000111111111B
	DW	0000001111111111B
	DW	0000011111111111B
	DW	0000111111111111B
	DW	0001111111111111B
	DW	0001111111111111B
	DW	0011111111111111B
	DW	0011111111111111B
	DW	0011111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0011111111111111B
	DW	0011111111111111B
	DW	0011111111111111B
	DW	0001111111111111B
	DW	0001111111111111B
	DW	0000111111111111B
	DW	0000011111111111B
	DW	0000001111111111B
	DW	0000000111111111B
	DW	0000000001111111B
	DW	0000000000001111B
	DW	31			{ 43 MessageBox i ? or blue/green right }
	DW	0000000000000000B
	DW	1111000000000000B
	DW	1111111000000000B
	DW	1111111110000000B
	DW	1111111111000000B
	DW	1111111111100000B
	DW	1111111111110000B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1111111111111100B
	DW	1111111111111100B
	DW	1111111111111100B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111100B
	DW	1111111111111100B
	DW	1111111111111100B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1111111111110000B
	DW	1111111111100000B
	DW	1111111111000000B
	DW	1111111110000000B
	DW	1111111000000000B
	DW	1111000000000000B
	DW	32			{ 44 MessageBox ! and white left }
	DW	0000000000001111B
	DW	0000000001111111B
	DW	0000000111111111B
	DW	0000001111111111B
	DW	0000011111111111B
	DW	0000111111111111B
	DW	0001111111111111B
	DW	0011111111111111B
	DW	0011111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0011111111111111B
	DW	0011111111111111B
	DW	0001111111111111B
	DW	0000111111111111B
	DW	0000011111111111B
	DW	0000001111111111B
	DW	0000000111111111B
	DW	0000000001111111B
	DW	0000000000001111B
	DW	32			{ 45 MessageBox ! and white right }
	DW	1111000000000000B
	DW	1111111000000000B
	DW	1111111110000000B
	DW	1111111111000000B
	DW	1111111111100000B
	DW	1111111111110000B
	DW	1111111111111000B
	DW	1111111111111100B
	DW	1111111111111100B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111110B
	DW	1111111111111100B
	DW	1111111111111100B
	DW	1111111111111000B
	DW	1111111111110000B
	DW	1111111111100000B
	DW	1111111111000000B
	DW	1111111110000000B
	DW	1111111000000000B
	DW	1111000000000000B
	DW	31			{ 46 MessageBox ! or yellow left }
	DW	0000000000000000B
	DW	0000000000001111B
	DW	0000000001111111B
	DW	0000000111111111B
	DW	0000001111110000B
	DW	0000011111110000B
	DW	0000111111110000B
	DW	0001111111110000B
	DW	0001111111110000B
	DW	0011111111110000B
	DW	0011111111110000B
	DW	0011111111110000B
	DW	0111111111110000B
	DW	0111111111110000B
	DW	0111111111110000B
	DW	0111111111110000B
	DW	0111111111110000B
	DW	0111111111110000B
	DW	0111111111110000B
	DW	0111111111110000B
	DW	0011111111110000B
	DW	0011111111111111B
	DW	0011111111111110B
	DW	0001111111111000B
	DW	0001111111111000B
	DW	0000111111110000B
	DW	0000011111110000B
	DW	0000001111111000B
	DW	0000000111111000B
	DW	0000000001111110B
	DW	0000000000001111B
	DW	31			{ 47 MessageBox ! or yellow right }
	DW	0000000000000000B
	DW	1111000000000000B
	DW	1111111000000000B
	DW	1111111110000000B
	DW	0000111111000000B
	DW	0000111111100000B
	DW	0000111111110000B
	DW	0000111111111000B
	DW	0000111111111000B
	DW	0000111111111100B
	DW	0000111111111100B
	DW	0000111111111100B
	DW	0000111111111110B
	DW	0000111111111110B
	DW	0000111111111110B
	DW	0000111111111110B
	DW	0000111111111110B
	DW	0000111111111110B
	DW	0000111111111110B
	DW	0000111111111110B
	DW	0000111111111100B
	DW	1111111111111100B
	DW	0111111111111100B
	DW	0001111111111000B
	DW	0001111111111000B
	DW	0000111111110000B
	DW	0000111111100000B
	DW	0001111111000000B
	DW	0001111110000000B
	DW	0111111000000000B
	DW	1111000000000000B
	DW	31			{ 48 MessageBox STOP and (not red) left }
	DW	0000000000000000B
	DW	0000000001111111B
	DW	0000000011111111B
	DW	0000000111111111B
	DW	0000001111111111B
	DW	0000011111111111B
	DW	0000111111111111B
	DW	0001111111111111B
	DW	0011111111111111B
	DW	0111111111111111B
	DW	0111111001100000B
	DW	0111110110111011B
	DW	0111110110111011B
	DW	0111110111111011B
	DW	0111110111111011B
	DW	0111111001111011B
	DW	0111111110111011B
	DW	0111111110111011B
	DW	0111110110111011B
	DW	0111110110111011B
	DW	0111110110111011B
	DW	0111111001111011B
	DW	0111111111111111B
	DW	0011111111111111B
	DW	0001111111111111B
	DW	0000111111111111B
	DW	0000011111111111B
	DW	0000001111111111B
	DW	0000000111111111B
	DW	0000000011111111B
	DW	0000000001111111B
	DW	31			{ 49 MessageBox STOP and (not red) right }
	DW	0000000000000000B
	DW	1111111000000000B
	DW	1111111100000000B
	DW	1111111110000000B
	DW	1111111111000000B
	DW	1111111111100000B
	DW	1111111111110000B
	DW	1111111111111000B
	DW	1111111111111100B
	DW	1111111111111110B
	DW	1100111000111110B
	DW	1011011011011110B
	DW	1011011011011110B
	DW	1011011011011110B
	DW	1011011011011110B
	DW	1011011000111110B
	DW	1011011011111110B
	DW	1011011011111110B
	DW	1011011011111110B
	DW	1011011011111110B
	DW	1011011011111110B
	DW	1100111011111110B
	DW	1111111111111110B
	DW	1111111111111100B
	DW	1111111111111000B
	DW	1111111111110000B
	DW	1111111111100000B
	DW	1111111111000000B
	DW	1111111110000000B
	DW	1111111100000000B
	DW	1111111000000000B
{$ifdef FPK} 
	DW	20
	DW      1100000000000000B       { 50 arrow pointer, screen mask }
	DW      1110000000000000B
	DW      1111000000000000B
	DW      1111100000000000B
	DW      1111110000000000B
	DW      1111111000000000B
	DW      1111111100000000B
	DW      1111111110000000B
	DW      1111111111000000B
	DW      1111111111100000B
	DW      1111111111110000B
	DW      1111111100000000B
	DW      1111111100000000B
	DW      1110111110000000B
	DW      1100011110000000B
	DW      1000001111000000B
	DW      0000001111000000B
	DW      0000000111100000B
	DW      0000000111100000B
	DW      0000000011000000B
	DW	19
	DW      0000000000000000B       { 51 arrow pointer, pixel mask }
	DW      0100000000000000B
	DW      0110000000000000B
	DW      0111000000000000B
	DW      0111100000000000B
	DW      0111110000000000B
	DW      0111111000000000B
	DW      0111111100000000B
	DW      0111111110000000B
	DW      0111111111000000B
	DW      0111111000000000B
	DW      0111011000000000B
	DW      0110011000000000B
	DW      0100001100000000B
	DW      0000001100000000B
	DW      0000000110000000B
	DW      0000000110000000B
	DW      0000000011000000B
	DW      0000000011000000B
	DW	16
	DW      0000000000000000B       { 52 cross pointer, screen mask }
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0111111111111111B
	DW      0111111101111111B
	DW      0111111111111111B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW      0000000111000000B
	DW	16
	DW      0000000000000000B       { 53 arrow pointer, pixel mask }
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0111111101111111B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW      0000000010000000B
	DW	27			{ 54 hourglass pointer, screen mask}
	DW      1111111111111110B
	DW      1111111111111110B
	DW      1111111111111110B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0011111111111000B
	DW      0001111111110000B
	DW      0000111111100000B
	DW      0000011111000000B
	DW      0000011111000000B
	DW      0000011111000000B
	DW      0000111111100000B
	DW      0001111111110000B
	DW      0011111111111000B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      0111111111111100B
	DW      1111111111111110B
	DW      1111111111111110B
	DW      1111111111111110B
	DW	25			{ 55 hourglass pointer, pixel mask }
	DW      0000000000000000B
	DW      0000000000000000B
	DW      0011111111111000B
	DW      0000000000000000B
	DW      0001111111110000B
	DW      0001111111110000B
	DW      0001111110110000B
	DW      0001010101010000B
	DW      0001101010110000B
	DW      0000110101100000B
	DW      0000011011000000B
	DW      0000001110000000B
	DW      0000000100000000B
	DW      0000000100000000B
	DW      0000000100000000B
	DW      0000001110000000B
	DW      0000011111000000B
	DW      0000111011100000B
	DW      0001111111110000B
	DW      0001111011110000B
	DW      0001110101110000B
	DW      0001101010110000B
	DW      0001010101010000B
	DW      0000000000000000B
	DW      0011111111111000B
	DW	24
	DW	0000000000000001B	{ 56 mcMove screen #1 }
	DW	0000000000000011B
	DW	0000000000000111B
	DW	0000000000001111B
	DW	0000000000011111B
	DW	0000000000011111B
	DW	0000000000000011B
	DW	0000000011000011B
	DW	0000000111000011B
	DW	0000001111000011B
	DW	0000011111111111B
	DW	0000111111111111B
	DW	0000111111111111B
	DW	0000011111111111B
	DW	0000001111000011B
	DW	0000000111000011B
	DW	0000000011000011B
	DW	0000000000000011B
	DW	0000000000011111B
	DW	0000000000011111B
	DW	0000000000001111B
	DW	0000000000000111B
	DW	0000000000000011B
	DW	0000000000000001B
	DW	24
	DW	1000000000000000B	{ 57 mcMove screen #2 }
	DW	1100000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1111100000000000B
	DW	1111100000000000B
	DW	1100000000000000B
	DW	1100001100000000B
	DW	1100001110000000B
	DW	1100001111000000B
	DW	1111111111100000B
	DW	1111111111110000B
	DW	1111111111110000B
	DW	1111111111100000B
	DW	1100001111000000B
	DW	1100001110000000B
	DW	1100001100000000B
	DW	1100000000000000B
	DW	1111100000000000B
	DW	1111100000000000B
	DW	1111000000000000B
	DW	1110000000000000B
	DW	1100000000000000B
	DW	1000000000000000B
	DW	23
	DW	0000000000000000B	{ 58 mcMove pixel #1 }
	DW	0000000000000001B
	DW	0000000000000011B
	DW	0000000000000111B
	DW	0000000000001111B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000010000001B
	DW	0000000110000001B
	DW	0000001110000001B
	DW	0000011111111111B
	DW	0000011111111111B
	DW	0000001110000001B
	DW	0000000110000001B
	DW	0000000010000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000001111B
	DW	0000000000000111B
	DW	0000000000000011B
	DW	0000000000000001B
	DW	23
	DW	0000000000000000B	{ 59 mcMove pixel #2 }
	DW	1000000000000000B
	DW	1100000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000100000000B
	DW	1000000110000000B
	DW	1000000111000000B
	DW	1111111111100000B
	DW	1111111111100000B
	DW	1000000111000000B
	DW	1000000110000000B
	DW	1000000100000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1111000000000000B
	DW	1110000000000000B
	DW	1100000000000000B
	DW	1000000000000000B
	DW	12			{ 60 Window Resize Down Right }
	DW	0111111100000000B
	DW	1111111100000000B
	DW	1111111000000000B
	DW	1111110000000000B
	DW	1111111000110000B
	DW	1111111101110000B
	DW	1110111111110000B
	DW	1100011111110000B
	DW	0000001111110000B
	DW	0000011111110000B
	DW	0000111111110000B
	DW	0000111111100000B
	DW	11			{ 61 }
	DW	0000000000000000B
	DW	0111111000000000B
	DW	0111110000000000B
	DW	0111100000000000B
	DW	0111110000000000B
	DW	0110111000100000B
	DW	0100011101100000B
	DW	0000001111100000B
	DW	0000000111100000B
	DW	0000001111100000B
	DW	0000011111100000B
	DW	12			{ 62 Window Resize Down Left }
	DW	0000111111100000B
	DW	0000111111110000B
	DW	0000011111110000B
	DW	0000001111110000B
	DW	1100011111110000B
	DW	1110111111110000B
	DW	1111111101110000B
	DW	1111111000110000B
	DW	1111110000000000B
	DW	1111111000000000B
	DW	1111111100000000B
	DW	0111111100000000B
	DW	11			{ 63 }
	DW	0000000000000000B
	DW	0000011111100000B
	DW	0000001111100000B
	DW	0000000111100000B
	DW	0000001111100000B
	DW	0100011101100000B
	DW	0110111000100000B
	DW	0111110000000000B
	DW	0111100000000000B
	DW	0111110000000000B
	DW	0111111000000000B
	DW	18			 { 64 Window Resize Vertical }
	DW	0000011000000000B
	DW	0000111100000000B
	DW	0001111110000000B
	DW	0011111111000000B
	DW	0111111111100000B
	DW	1111111111110000B
	DW	1111111111110000B
	DW	0000111100000000B
	DW	0000111100000000B
	DW	0000111100000000B
	DW	0000111100000000B
	DW	1111111111110000B
	DW	1111111111110000B
	DW	0111111111100000B
	DW	0011111111000000B
	DW	0001111110000000B
	DW	0000111100000000B
	DW	0000011000000000B
	DW	17			{ 65 }
	DW	0000000000000000B
	DW	0000011000000000B
	DW	0000111100000000B
	DW	0001111110000000B
	DW	0011111111000000B
	DW	0111111111100000B
	DW	0000011000000000B
	DW	0000011000000000B
	DW	0000011000000000B
	DW	0000011000000000B
	DW	0000011000000000B
	DW	0000011000000000B
	DW	0111111111100000B
	DW	0011111111000000B
	DW	0001111110000000B
	DW	0000111100000000B
	DW	0000011000000000B
	DW	12			 { 66 Window Resize Horizontal }
	DW	0000011000011000B
	DW	0000111000011100B
	DW	0001111000011110B
	DW	0011111000011111B
	DW	0111111111111111B
	DW	1111111111111111B
	DW	1111111111111111B
	DW	0111111111111111B
	DW	0011111000011111B
	DW	0001111000011110B
	DW	0000111000011100B
	DW	0000011000011000B
	DW	8			{ 67 }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1000000000000000B
	DW	1100000000000000B
	DW	1100000000000000B
	DW	1000000000000000B
	DW	11			{ 68 }
	DW	0000000000000000B
	DW	0000010000001000B
	DW	0000110000001100B
	DW	0001110000001110B
	DW	0011110000001111B
	DW	0111111111111111B
	DW	0111111111111111B
	DW	0011110000001111B
	DW	0001110000001110B
	DW	0000110000001100B
	DW	0000010000001000B
	DW	7
	DW	0000000000000000B	{ 69 }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	17
	DW	1110111000000000B       { 70 input }
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	1110111000000000B
	DW	1	
	DW	0000000000000000B	{ 71 input }
{$endif}
	DW	0			{ end of list }
end;

{ BoxIcons for GvWinDlg
}
procedure BoxIcons; Assembler;
Asm
	DW	1
	DW      0000000000000000B
	DW	12
	DW	0000000000000000B
	DW	0100000000010000B
	DW	0010000000100000B
	DW	0001000001000000B
	DW	0000100010000000B
	DW	0000010100000000B
	DW	0000001000000000B
	DW	0000010100000000B
	DW	0000100010000000B
	DW	0001000001000000B
	DW	0010000000100000B
	DW	0100000000010000B
	DW	12
	DW	0000000000000000B
	DW	0010101010100000B
	DW	0101010101010000B
	DW	0010101010100000B
	DW	0101010101010000B
	DW	0010101010100000B
	DW	0101010101010000B
	DW	0010101010100000B
	DW	0101010101010000B
	DW	0010101010100000B
	DW	0101010101010000B
	DW	0010101010100000B
End;

procedure CloseDot; assembler;
asm
	dw	2
	dw	1010101010101010b
	dw	0101010101010101b
end;

{ Icon rendering management 
}

type
  PRenderedIcon = ^TRenderedIcon;
  TRenderedIcon = object(TObject)
    Bits: pointer;
    Color: Byte;
    Back: Byte;
    Mode: Byte;
    WriteMode: Byte;
{$ifdef FPK}
{$ifdef Linux}
    Bitmap:PBitmap;
{$else}
   Image: PBitmap;
   Mask: PBitmap;
{$endif}
{$else}
    Image:pointer;
    Mask: pointer;
{$endif}
    constructor Init(ABits: pointer; AColor, ABack: Word; AMode: Byte);
    destructor Done; virtual;
    procedure Draw(X, Y: Integer);
  end;

  PRenderedCollection = ^TRenderedCollection;
  TRenderedCollection = object(TSortedCollection)
    function Compare(Key1, Key2: pointer): Sw_Integer; virtual;
  end;

const
  _RenderedIcons: PRenderedCollection = nil;

function GetRenderedIcons: PRenderedCollection;
begin
  If _RenderedIcons = nil
  then _RenderedIcons := New(PRenderedCollection, Init(64, 64));
  GetRenderedIcons := _RenderedIcons
end;

procedure KillIcon(Icon: pointer);
var
  i: Integer;
begin
  If _RenderedIcons <> nil then
  with _RenderedIcons^ do
    For i := Count - 1 downto 0 do
      If PRenderedIcon(At(i))^.Bits = Icon
      then AtFree(i)
end;

procedure KillAllIcons;
begin
  If _RenderedIcons <> nil
  then begin
    Dispose(_RenderedIcons, Done);
    _RenderedIcons := nil
  end
end;

{$ifdef NOIASM}
function TRenderedCollection.Compare(Key1, Key2: pointer): Sw_Integer;
var
  I: LongInt;
  R1, R2: PRenderedIcon;
begin
  R1 := PRenderedIcon(Key1);
  R2 := PRenderedIcon(Key2);
  I := LongInt(R1^.Bits) - LongInt(R2^.Bits);
  if I <> 0 then begin Compare := I; Exit end;
  I := R1^.Color - R2^.Color;
  if I <> 0 then begin Compare := I; Exit end;
  I := R1^.Mode - R2^.Mode;
  Compare := I; 
end; { TRenderedCollection.Compare }
{$else}
function TRenderedCollection.Compare(Key1, Key2: pointer): Integer; assembler;
asm
	push	ds
	lds	si, Key1
	les	di, Key2
	mov	ax, es:[di].TRenderedIcon.Bits.Word.2
	sub	ax, [si].TRenderedIcon.Bits.Word.2
	jnz	@@0
	mov	ax, es:[di].TRenderedIcon.Bits.Word.0
	sub	ax, [si].TRenderedIcon.Bits.Word.0
	jnz	@@0
	mov	ax, es:[di].TRenderedIcon.Color.Word
	sub	ax, [si].TRenderedIcon.Color.Word
	jnz	@@0
	mov	al, es:[di].TRenderedIcon.Mode
	sub	al, [si].TRenderedIcon.Mode
	cbw
@@0:	pop	ds
end; { TRenderedCollection.Compare }
{$endif}

procedure DrawColIcon(x1, y1, n: Integer; Color: Byte);
Begin
  DrawIcon(x1, y1, n, $200+Color)
End;

{ Get a dynamic image from an old-style "icon" bitmap.
}

{$ifdef NOIASM}
procedure Convert(Src, Dst: pointer; Cnt: Word; XorMask: Word); 
var
  P, Q: PChar;
  i: Integer; 
begin 
  P := Src;
  Q := Dst;
  for i := 1 to Cnt do begin
    Q[0] := Char(Byte(P[1]) xor Lo(XorMask));      
    Q[1] := Char(Byte(P[0]) xor Hi(XorMask));
    Inc(P, 2);
    Inc(Q, 2)
  end;
end; { Convert }
{$else}
procedure Convert(Src, Dst: pointer; Cnt: Word; XorMask: Word); assembler;
asm
	mov	cx, Cnt
	mov	bx, XorMask
	push	ds
	lds	si, Src
	les	di, Dst
	cld
@@1:
	lodsw
	xchg	al, ah
	xor	ax, bx
	stosw
	loop	@@1
	pop	ds
end; { Convert }
{$endif}

{$ifdef FPK}
{ use G. Schouten's Bitmaps unit }

function Identity(i: longint): longint;
begin
  Identity := i
end;

function OldIconToImage(ABits: pointer; AColor, Back: Word; 
                        Mode: Byte): PBitmap;
var
  m: Word;
  Pal: array[0..1] of LongInt;
  Buf: pointer;
  Bitmap: PBitmap;
begin
  If Mode = 0
  then m := $FFFF
  else m := 0;

  Bitmap := New(PBitmap, Create);
  Bitmap^.SetWidth(16);
  Bitmap^.SetHeight(Word(ABits^));
  Bitmap^.SetBytesPerPixel(GetBytesPerPixel);

  Pal[0] := GetNearestPaletteIndex(GetRGBColor(0));
  if AColor = 0 then AColor := 1;
  Pal[1] := GetNearestPaletteIndex(GetRGBColor(AColor));

  Bitmap^.SetPalette(@Pal, 2, 0, 1);
  Bitmap^.SetEncodeColor(Identity);
  GetMem(Buf, Word(ABits^)*2);
  Convert(PChar(ABits)+2, Buf, Word(ABits^), m);
  Bitmap^.PutPixels(0, 0, Word(ABits^) * 16, Buf, 1);
  FreeMem(Buf, Word(ABits^)*2);
  OldIconToImage := Bitmap;
end;

{$else !FPK}

{ Use our own bitmap unit }
function OldIconToImage(IconBits: pointer; Color, Back: Word; Mode: Byte): PImage;
const
  Header: TBitmap =
    (bmType: 0; bmWidth: 16; bmHeight: 0; bmWidthBytes: 2;
     bmPlanes: 1; bmBitsPixel: 1);
var
  m: Word;
begin
  Header.bmHeight := Word(IconBits^);
  GetMem(Header.bmBits, Header.bmHeight * 2);
  If Mode = 0
  then m := $FFFF
  else m := 0;
  Convert(PChar(IconBits) + 2, Header.bmBits, Header.bmHeight, m);
  If Mode = 3
  then begin
    Bitmap.BkColor := Back;
    Bitmap.Color := Color
  end
  else begin
    Bitmap.BkColor := Color;
    If (Mode = 2) and (Color = 0)
    then Bitmap.Color := 1
    else Bitmap.Color := 0;
  end;
  OldIconToImage := BitmapToImage(@Header);
  FreeMem(Header.bmBits, Header.bmHeight * 2)
end;
{$endif}

{$ifdef Linux}
   { Using SVGALIB }

constructor TRenderedIcon.Init(ABits: pointer;
  AColor, ABack: Word; AMode: Byte);
begin 
  inherited Init;
  Bits := ABits;
  Color := AColor;
  Back := ABack;
  Mode := AMode;
  Bitmap := OldIconToImage(Bits, AColor, ABack, AMode);
  WriteMode := BackPut;
end;

destructor TRenderedIcon.Done;
begin
  Dispose(Bitmap, Destroy);
  inherited Done
end;

procedure TRenderedIcon.Draw(X, Y: Integer);
begin
  PasteImage(X, Y, Bitmap^.GetData, WriteMode);
end;

{$else !Linux}
   { Using BGI }
constructor TRenderedIcon.Init(ABits: pointer;
  AColor, ABack: Word; AMode: Byte);
begin
  inherited Init;
  Bits := ABits;
  Color := AColor;
  Back := ABack;
  Mode := AMode;
  Image := OldIconToImage(Bits, AColor, ABack, AMode);
  case Mode of
    0:
      WriteMode := AndPut {+ NotPut};
    1:
      WriteMode := OrPut;
    2:
      begin
	If GetVgaMemCaps and vmcBackPut = 0
	then begin
	  WriteMode := OrPut;
	  {$ifdef FPK}
	   { dont have MaskedImage }
	   if Color <> 15 then begin
	      Mask := OldIconToImage(Bits, 15, 0, 0);
	   end;
	   if Color = 0 then begin
	      Dispose(Image, Destroy);
	      Image := nil
	   end;
	   {$else}
	  If Color = 0
	  then SetBkColor(1)
	  else SetBkColor(0);
	  Mask := MaskedImage(Image);
	  If Color = 0 then begin
	    FreeImage(Image);
	    Image := nil
	  end;
	   {$endif}
	end
	else
	  WriteMode := NormalPut + BackPut
      end;
    3:
      WriteMode := NormalPut;
  end;
end;

destructor TRenderedIcon.Done;
  begin
{$ifdef FPK}
     if Mask <> nil then Dispose(Mask, Destroy);
     if Image <> nil then Dispose(Mask, Destroy);
{$else}
     FreeImage(Mask);
  FreeImage(Image);
{$endif}
     inherited Done
end;

procedure TRenderedIcon.Draw(X, Y: Integer);
begin
  If Mask <> nil then
     PutImage(X, Y, {$ifdef FPK} Mask^.getData^ {$else} Mask^ {$endif}, AndPut);
  If Color = 0
  then SetBkColor(1)
  else SetBkColor(0);
   If Image <> nil then PutImage(X, Y, {$ifdef FPK} Image^.getData^ {$else} Image^ {$endif}, WriteMode)
end;

{$endif !Linux}

{ Substitutes for VgaMem's old-style icon routines, which are only functional
  in non-mapped 16-color modes.
}

procedure PutIcon(x, y: Integer; IconBits: pointer; Color: Byte; Mode: Byte);
var
  Key: TRenderedIcon;
  Index: Sw_Integer;
  Icon: PRenderedIcon;
begin
  Key.Bits := IconBits;
  Key.Color := Color;
  Key.Back := 0;
  Key.Mode := Mode;
  If not GetRenderedIcons^.Search(@Key, Index)
  then begin
    Icon := New(PRenderedIcon, Init(IconBits, Color, 0, Mode));
    _RenderedIcons^.AtInsert(Index, Icon)
  end
  else
    Icon := _RenderedIcons^.At(Index);
  Icon^.Draw(x - DrawOrigin.x, y - DrawOrigin.y)
end;

procedure PutIconAnd(x1, y1: Integer; MapMask: Byte; Icon: Pointer);
begin
  PutIcon(x1, y1, Icon, MapMask, 0);
end;

procedure PutIconOr(x1, y1: Integer; MapMask: Byte; Icon: Pointer);
begin
  PutIcon(x1, y1, Icon, MapMask, 1);
end;

{$ifdef FPK}

type
  PWord	= ^Word;

function GetIconPtr(n: Integer): pointer;
var 
  p: PWord;
  l: Word;
  i: Integer;
begin
  p := pointer(@TheIcons);
  for i := 1 to n do begin
    l := p^;
    if l = 0 then Break;
    p := PWord(PChar(p) + 2*l + 2);
  end;
  GetIconPtr := p;
end;

function DrawIcon(x1, y1, n: Integer; Mode: Word): Word;
var
  p: PWord;
begin
  p := GetIconPtr(n);
  PutIcon(x1 + DrawOrigin.X, y1 + DrawOrigin.Y, p, Lo(Mode), Hi(Mode));
  DrawIcon := p^;
end;

procedure ColorFill(x1, y1, x2, y2: Integer;
  Fore, Back: Word; FillIcon: pointer);
begin
  SetFillStyle(SolidFill, Back);
  Bar(x1, y1, x2, y2);
end;

{$else !FPK }

function DrawIcon(x1, y1, n: Integer; Mode: Word): Word; assembler;
{ Low-Byte von Mode gibt beeinflute Speicherebenen an. Ist das High-Byte
  0, so erfolgt and-Verknpfung, ansonsten or-Verknpfung. Wenn Mode = $FFFF,
  wird nichts gemalt. Im Funktionsergebnis wird die Hhe des Icons
  zurckgegeben.
}
Asm
	MOV	SI, OFFSET TheIcons
	MOV	AX, n
	OR	AL, AL
	JZ 	@@1
@@2:	MOV	CX, [CS:SI]
	SHL	CX, 1
	JZ	@@3
	ADD	SI, CX
	ADD	SI, 2
	DEC	AL
	JNZ	@@2
@@1:
	PUSH	WORD PTR [CS:SI]
	CMP	Mode, -1
	JZ	@@3

	MOV     AX, x1
	ADD	AX, DrawOrigin.X
	MOV	BX, y1
	ADD	BX, DrawOrigin.Y
	PUSH	AX
	PUSH	BX
	PUSH	CS
	PUSH	SI
	push	Mode
	mov	al, BYTE PTR Mode + 1
	push	ax
	call    PutIcon
@@3:
	pop	ax
End;

procedure ColorFill(x1, y1, x2, y2: Integer;
  Fore, Back: Word; FillIcon: pointer);
{$ifndef Windows}
var
  Key: TRenderedIcon;
  Index: Integer;
  Icon: PRenderedIcon;
  x, y, dy: Integer;
begin
  Key.Bits := FillIcon;
  Key.Color := Fore;
  Key.Back := Back;
  Key.Mode := 3;
  If not GetRenderedIcons^.Search(@Key, Index)
  then begin
    Icon := New(PRenderedIcon, Init(FillIcon, Fore, Back, 3));
    _RenderedIcons^.AtInsert(Index, Icon)
  end
  else
    Icon := _RenderedIcons^.At(Index);
  dy := Word(FillIcon^);
  y := y1;
  while y < y2 do
  begin
    x := x1;
    while x < x2 do
    begin
      Icon^.Draw(x, y);
      Inc(x, 16)
    end;
    Inc(y, dy)
  end
end;
{$else Windows}
var
  Brush: HBrush;
  Rect: WinTypes.TRect;
  c1, c2: TColorRef;

	function av(b1, b2: Byte): Byte;
	begin
	  av := (integer(b1) + integer(b2)) div 2
	end;

begin
  Rect.top := y1;
  Rect.left := x1;
  Rect.bottom := y2;
  Rect.right := x2;
  c1 := transColor(Fore);
  c2 := transColor(Back);
  Brush := CreateSolidBrush(RGB(
    av(GetRValue(c1), GetRValue(c2)),
    av(GetGValue(c1), GetGValue(c2)),
    av(GetBValue(c1), GetBValue(c2))));
  FillRect(DC, Rect, Brush);
  DeleteObject(Brush);
end;
{$endif Windows}

{$endif}

procedure SetExactBkColor(R, G, B: Integer);
begin
{$ifndef FPK}
{$ifdef Windows}
  WinGr.ExBkColor := RGB(R, G, B);
{$else !Windows}
  Gr.SetBkColor(GetNearestPaletteIndex(RGB(R, G, B)));
{$endif Windows}
{$endif}
end;

{******************* Graphics Vision graphics routines **********************}

Procedure RBar(var R: TRect);
Begin
  Bar (R.A.X, R.A.Y, R.B.X-1, R.B.Y-1)
End;

Procedure RRect(var R: TRect);
Begin
  Rectangle (R.A.X, R.A.Y, R.B.X-1, R.B.Y-1)
End;

Procedure OutTextP(P: TPoint; S: string);
Begin
  OutTextXY (P.X, P.Y, S)
End;

Procedure SetGVStyle(AFont: Integer);
Begin
  Font:=AFont
End;

Function GetShortCut(S: string): Char;
Var i:Byte;
Begin
  For i:=1 to Length (S) do
    If S[i]='~' Then Begin GetShortCut:=UpCase (S[i+1]); Exit End;
  GetShortCut:=#255; { is not possible }
End;

Procedure OutGVText(P: TPoint; S: String;
  Col1, Col2: Byte; Size: TPoint; Center: Boolean);
Begin
  If S='' then Exit;
  SetTextParams (Font, 0, (Col2 shl 8)+Col1, True);
  If Center then Begin
    SetTextJustify (CenterText, CenterText);
    Inc (P.X, Size.X div 2);
  End
  Else SetTextJustify (LeftText, CenterText);
  Inc (P.Y, Size.Y div 2);
  OutTextXY (P.X, P.Y, S);
End;

procedure PutGVImage(var R: TRect; Image: pointer; BkCol: Byte);
var
  ImgR, BarR: TRect;
Begin
  ImgR.A.X := 0; ImgR.A.Y := 0;
  GetImageExtent(Image, ImgR.B);
  ImgR.Move((R.B.X + R.A.X - ImgR.B.X) div 2, (R.B.Y + R.A.Y - ImgR.B.Y) div 2);
  BarR := ImgR;
  BarR.Grow(2, 2);
  SetFillStyle(SolidFill, BkCol);
  With BarR do
    Bar (A.X, A.Y, B.X-1, B.Y-1);
  with ImgR do
    PutImage(A.X, A.Y, Image^, NormalPut);
End;

Procedure DrawButton(var R: TRect;
  Down, Small: Boolean; BkCol, FrameCol, NormCol, ShadowCol: Byte);
Begin
  SetColor (FrameCol);
  RectAngle (R.A.X, R.A.Y, R.B.X-1, R.B.Y-1);
  SetFillStyle (SolidFill, NormCol);
  Bar (R.A.X+1, R.A.Y+1, R.B.X-2, R.B.Y-2);
  SetColor (ShadowCol);
  If Down then Begin
    HoriLine (R.A.X+1, R.A.Y+1, R.B.X-2);
    VertLine (R.A.X+1, R.A.Y+1, R.B.Y-2);
    Inc (R.A.X); Inc (R.A.Y,2);
  End
  Else Begin
    VertLine (R.B.X-2, R.A.Y+1, R.B.Y-2);
    VertLine (R.B.X-3, R.A.Y+2, R.B.Y-2);
    HoriLine (R.A.X+1, R.B.Y-2, R.B.X-2);
    HoriLine (R.A.X+2, R.B.Y-3, R.B.X-2);
    SetColor (BkCol);
    HoriLine (R.A.X+1, R.A.Y+1, R.B.X-3);
    VertLine (R.A.X+1, R.A.Y+1, R.B.Y-3);
    If not Small then Begin
      HoriLine (R.A.X+2, R.A.Y+2, R.B.X-4);
      VertLine (R.A.X+2, R.A.Y+2, R.B.Y-4);
    End;
  End;
End;

{ 3D support 
}

function UpperColor(Color: Word): Word;
const
  Upper: array[0..15] of Byte =
    (8, 9, 10, 11, 12, 13, 14, 15, 7, 15, 15, 15, 15, 15, 15, 15);
begin
  If Color <= 15
  then UpperColor := Upper[Color]
  else UpperColor := Color
end;

function LowerColor(Color: Word): Word;
const
  Lower: array[0..15] of Byte =
    (0, 0, 0, 0, 0, 0, 0, 8, 0, 1, 2, 3, 4, 5, 6, 15);
begin
  If Color <= 15
  then LowerColor := Lower[Color]
  else LowerColor := Color
end;

function EdgeColor(Vector: TPoint; Color: Word): Word;
begin
  if Vector.y >= Vector.x
  then EdgeColor := UpperColor(Color)
  else EdgeColor := LowerColor(Color)
end;

procedure Edge(A, B: TPoint; Color: Word);
var
  Vector: TPoint;
begin
  Vector.x := B.x - A.x;
  Vector.y := B.y - A.y;
  SetColor(EdgeColor(Vector, Color));
  Line(A.x, A.y, B.x, B.y)
end;

{$ifndef FPK}
procedure EdgePolygon(var Polygon: array of TPoint; Color: Word);
var
  P: TPoint;
  i: Integer;
begin
  P := Polygon[0];
  For i := 1 to High(Polygon) do
  begin
    Edge(P, Polygon[i], Color);
    P := Polygon[i]
  end;
  Edge(P, Polygon[0], Color)
end;
{$endif}

procedure EdgeRect(A, B: TPoint; Down: Boolean; Color: Word);
begin
  EdgeR(A.x, A.y, B.x, B.y, Down, Color)
end;
{var
  Polygon: array[0..3] of TPoint;
begin
  if Down
  then begin
    Polygon[0] := A;
    Polygon[1].x := B.x;
    Polygon[1].y := A.y;
    Polygon[2] := B;
    Polygon[3].x := A.x;
    Polygon[3].y := B.y
  end
  else begin
    Polygon[3] := A;
    Polygon[2].x := B.x;
    Polygon[2].y := A.y;
    Polygon[1] := B;
    Polygon[0].x := A.x;
    Polygon[0].y := B.y
  end;
  EdgePolygon(Polygon, Color)
end;}

procedure EdgeR(x1, y1, x2, y2: Integer; Down: Boolean; Color: Word);
{var
  R: TRect;}
begin
  {R.Assign(x1, y1, x2, y2);
  EdgeRect(R.A, R.B, Down, Color)}
  if Down
  then SetColor(LowerColor(Color))
  else SetColor(UpperColor(Color));
  HoriLine(x1, y1, x2 - 1);
  VertLine(x1, y1, y2);
  if Down
  then SetColor(UpperColor(Color))
  else SetColor(LowerColor(Color));
  HoriLine(x1 + 1, y2, x2);
  VertLine(x2, y1, y2)
end;

function Point(var P: TPoint; Center: TPoint; Radius, Angle, Base: Integer;
  Color: Word): Word;
var
  Radiant: Real;
  Sine, Cosine: Real;
  Tangent: TPoint;
begin
  Radiant := Angle * (pi / 180.0);
  Cosine := cos(Radiant);
  Sine := sin(Radiant);
  If Base <> 0
  then begin
    Tangent.x := Round(Base * Sine);
    Tangent.y := Round(Base * Cosine);
    Point := EdgeColor(Tangent, Color)
  end
  else
    Point := 0;
  P.x := +Round(Radius * Cosine) + Center.x;
  P.y := -Round(Radius * Sine) + Center.y
end;

procedure EdgeArc(Center: TPoint; StAngle, EndAngle, Radius: Integer;
  StPoint, EndPoint: PPoint; Color: Word);
const
  PixelDelta = 1;
var
  A, B: TPoint;
  Base, Delta: Integer;

	procedure LineToAngle(Angle: Integer);
	begin
	  SetColor(Point(B, Center, Radius, Angle, Base, Color));
	  Line(A.x, A.y, B.x, B.y);
	  A := B
	end;

begin
  Delta := (PixelDelta * 60 + Radius) div Radius;
  Point(A, Center, Radius, StAngle, Color, 0);
  If StPoint <> nil then StPoint^ := A;

  If StAngle < EndAngle
  then begin
    Base := -1000;
    Inc(StAngle, Delta);
    while StAngle < EndAngle do
    begin
      LineToAngle(StAngle);
      Inc(StAngle, Delta)
    end
  end
  else begin
    Base := +1000;
    Dec(StAngle, Delta);
    while StAngle > EndAngle do
    begin
      LineToAngle(StAngle);
      Dec(StAngle, Delta)
    end
  end;

  LineToAngle(EndAngle);
  If EndPoint <> nil then EndPoint^ := B
end;

{ Notification
}
{$ifndef FPK}
{$ifndef Windows}
var
  NextNotify: TNotifyProc;

{ Note: NotifyExtGraph has priority 30 since it requires VgaMem (20) graphics
	still running for removing images.
}

function NotifyExtGraph(Notice: Word; Info: LongInt): LongInt; {$ifndef FPK}far;{$endif}
Begin
  case Notice of
    gnpCloseGraphics:
      KillAllIcons;
  end;
  NotifyExtGraph := DefaultNotify(Notice, Info, NotifyExtGraph, NextNotify, 30);
End;

begin
  InstallNotifyProc(GrNotifyProc, NotifyExtGraph);
{$endif}
{$endif}
end.
