unit GvFPK;

{ Graphics Vision unit: FPK support
  Copr. 1997,1998 Matthias K"oppe <mkoeppe@cs.uni-magdeburg.de>
}

interface

{$i platform.inc}

{$ifdef OS_LINUX}
uses Linux, CallSpec, Objects, Drivers;
{$endif}
{$ifdef OS_DOS}
uses CallSpec, {FMouse, Mouse, } TempMous, Go32, Objects, Drivers, Graph;
{$endif}

function Min (x, y: Integer): Integer;
function Max (x, y: Integer): Integer;
function Ranges (x, Lx, Hx: Integer): Boolean;
function Equal(A, B: Word): Boolean;

{ These functions do the same as CallSpec's
 CurrentFramePointer and PreviousFramePointer.
}
function CurBP: FramePointer;
function PrevBP: FramePointer;

{ Mouse and Timer }

const
  evTimer = $4000;

var
  CursorNum: Integer;
  NewNum: Integer;
  CriticalArea: TRect;

procedure SetMousePos(x, y: Integer);
procedure SetCurrentCursor(c: Integer);
procedure SetMouseArea(x1, y1, x2, y2: Integer);
procedure SetCriticalArea(x1, y1, x2, y2: Integer);
procedure SetCriticalAreaR(var R: TRect);
procedure GetTimerEvent(var Event: TEvent);
function GetTimerTicks: LongInt;
function MouseInstalled: Boolean;

const
  MCurStandard: Integer = 0;
  MCurrent: Integer = -1;

procedure Delay(MS: Word);

implementation

function Min (x, y: Integer): Integer;
begin
  if x < y then Min := x else Min := y
end;

function Max (x, y: Integer): Integer;
begin
  if x > y then Max := x else Max := y
end;

function Ranges (x, Lx, Hx: Integer): Boolean;
begin
  Ranges := (x >= Lx) and (x <= Hx)
end;

function Equal(A, B: Word): Boolean;
begin
  Equal := A = B
end;

{$ifdef OS_LINUX}
procedure SetMousePos(x, y: Integer);
begin
end;

procedure SetCurrentCursor(c: Integer);
begin
end;

procedure SetMouseArea(x1, y1, x2, y2: Integer);
begin
end;

procedure SetCriticalArea(x1, y1, x2, y2: Integer);
begin
end;

procedure SetCriticalAreaR(var R: TRect);
begin
end;

function MouseInstalled: Boolean;
begin
  MouseInstalled := true
end;

function GetTimerTicks: LongInt;
{var
  timev: timeval;
  timez: timezone;
begin
  GetTimeOfDay(timev, timez);
  GetTimerTicks := Trunc(18.2 * (GetEpochTime mod 86400) + timev.usec / 54945.0);
end;} { GetTimerTicks }
begin
  GetTimerTicks := Drivers.GetDosTicks
end;

procedure GetTimerEvent(var Event: TEvent);
var
  Tick: LongInt;
const
  LastTick: LongInt = 0;
begin
  Event.What := evNothing;
  Tick := GetTimerTicks;
  If Tick <> LastTick
  then begin
    Event.What := evTimer;
    Event.InfoPtr := pointer(Tick);
    LastTick := Tick
  end
end;
{$endif OS_LINUX}

{$ifdef OS_DOS}
procedure SetMousePos(x, y: Integer);
begin
  TEMPMOUS.mousesetpos(x * 8, y * 8);
end;

procedure SetCurrentCursor(c: Integer);
begin
end;

procedure SetMouseArea(x1, y1, x2, y2: Integer);
begin
  TEMPMOUS.mwindow(x1 * 8, y1 * 8, x2 * 8, y2 * 8);
end;

procedure SetCriticalArea(x1, y1, x2, y2: Integer);
begin
end;

procedure SetCriticalAreaR(var R: TRect);
begin
end;

function MouseInstalled: Boolean;
begin
  MouseInstalled := ButtonCount <> 0
end;

function GetTimerTicks: LongInt;
var
  Tick: LongInt;
begin
  DosMemGet($40, $6c, Tick, 4);
  GetTimerTicks := Tick;
end;

procedure GetTimerEvent(var Event: TEvent);
const
  LastTick: LongInt = 0;
var
  Tick: LongInt;
begin
  Event.What := evNothing;
  DosMemGet($40, $6c, Tick, 4);
  If Tick <> LastTick
  then begin
    Event.What := evTimer;
    Event.InfoPtr := pointer(Tick);
    LastTick := Tick
  end
end;
{$endif OS_DOS}

procedure Delay(MS: Word);
begin
end;

function CurBP: FRAMEPOINTER;
begin
  asm
    movl (%ebp), %eax
    leave
    ret
  end ['EAX'];
end;

function PrevBP: FRAMEPOINTER;
begin
  asm
    movl (%ebp), %eax
    movl (%eax), %eax
    leave
    ret
  end ['EAX'];
end;

end.
